/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.mybank.api.internal.parser.xml;

import com.qqt.platform.common.mybank.api.MybankApiException;
import com.qqt.platform.common.mybank.api.MybankApiExceptionEnum;
import com.qqt.platform.common.mybank.api.MybankResponse;
import com.qqt.platform.common.mybank.api.internal.mapping.Converter;
import com.qqt.platform.common.mybank.api.internal.util.JaxbUtil;
import com.qqt.platform.common.mybank.api.internal.util.XmlUtils;

public class XmlConverter
implements Converter {
    private XmlConverter() {
    }

    public static XmlConverter getInstance() {
        return XmlConverterInstance.instance;
    }

    @Override
    public <T extends MybankResponse> T toResponse(String responseXml, Class<T> clazz) throws MybankApiException {
        if (!XmlUtils.isXmlDocument(responseXml)) {
            throw new MybankApiException(MybankApiExceptionEnum.NOT_XML_TYPE);
        }
        return (T)((MybankResponse)this.getModelFromXML(responseXml, clazz));
    }

    private <T> T getModelFromXML(String responseXml, Class<T> clazz) throws MybankApiException {
        return JaxbUtil.converyToJavaBean(responseXml, clazz);
    }

    private static class XmlConverterInstance {
        static XmlConverter instance = new XmlConverter();

        private XmlConverterInstance() {
        }
    }
}

