/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.mybank.api.internal.util;

import com.qqt.platform.common.mybank.api.MybankApiException;
import com.qqt.platform.common.mybank.api.MybankApiExceptionEnum;
import com.qqt.platform.common.mybank.api.internal.util.MybankLogger;
import com.qqt.platform.common.mybank.api.internal.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class WebUtils {
    private static SSLContext sslContext = null;
    private static HostnameVerifier verifier = null;
    private static SSLSocketFactory socketFactory = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String doPost(String serverUrl, String xmlContent, String cookieValue, String charset, int connectTimeout, int readTimeout, String apiFunction, String apiVersion) throws MybankApiException {
        HttpURLConnection conn = null;
        OutputStreamWriter out = null;
        String rsp = null;
        try {
            try {
                conn = WebUtils.getConnection(new URL(serverUrl), "POST", xmlContent.length());
                if (!StringUtils.isEmpty(cookieValue)) {
                    conn.setRequestProperty("Cookie", cookieValue);
                }
                conn.setConnectTimeout(connectTimeout);
                conn.setReadTimeout(readTimeout);
            }
            catch (IOException e) {
                MybankLogger.logCommError((Exception)e, serverUrl, xmlContent, apiFunction, apiVersion);
                throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
            }
            try {
                out = new OutputStreamWriter(conn.getOutputStream(), charset);
                out.write(xmlContent);
                out.flush();
                rsp = WebUtils.getResponseAsString(conn);
            }
            catch (IOException e) {
                MybankLogger.logCommError((Exception)e, conn, xmlContent, apiFunction, apiVersion);
                throw new MybankApiException(MybankApiExceptionEnum.REQUEST_REMOTE_SERVER_ERROR, (Throwable)e);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new MybankApiException(MybankApiExceptionEnum.SERVER_SYSTEM_EXCEPTION, (Throwable)e);
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return rsp;
    }

    private static HttpURLConnection getConnection(URL url, String method, int length) throws IOException {
        HttpURLConnection conn = null;
        if ("https".equals(url.getProtocol())) {
            HttpsURLConnection connHttps = null;
            connHttps = (HttpsURLConnection)url.openConnection();
            connHttps.setHostnameVerifier(verifier);
            connHttps.setSSLSocketFactory(socketFactory);
            conn = connHttps;
        } else {
            conn = (HttpURLConnection)url.openConnection();
        }
        conn.setDoInput(true);
        conn.setDoOutput(true);
        conn.setRequestMethod(method);
        conn.setRequestProperty("Content-Type", "application/xml;charset=UTF-8");
        conn.setRequestProperty("Content-Length", String.valueOf(length));
        return conn;
    }

    protected static String getResponseAsString(HttpURLConnection conn) throws IOException {
        String charset = WebUtils.getResponseCharset(conn.getContentType());
        InputStream es = conn.getErrorStream();
        if (es == null) {
            return WebUtils.getStreamAsString(conn.getInputStream(), charset);
        }
        String msg = WebUtils.getStreamAsString(es, charset);
        if (StringUtils.isEmpty(msg)) {
            throw new IOException(conn.getResponseCode() + ":" + conn.getResponseMessage());
        }
        throw new IOException(msg);
    }

    private static String getResponseCharset(String ctype) {
        String charset = "UTF-8";
        if (!StringUtils.isEmpty(ctype)) {
            String[] params;
            for (String param : params = ctype.split(";")) {
                if (!(param = param.trim()).startsWith("charset")) continue;
                String[] pair = param.split("=", 2);
                if (pair.length != 2 || StringUtils.isEmpty(pair[1])) break;
                charset = pair[1].trim();
                break;
            }
        }
        return charset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getStreamAsString(InputStream stream, String charset) throws IOException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream, charset));
            StringWriter writer = new StringWriter();
            char[] chars = new char[256];
            int count = 0;
            while ((count = reader.read(chars)) > 0) {
                writer.write(chars, 0, count);
            }
            String string = writer.toString();
            return string;
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    static {
        try {
            sslContext = SSLContext.getInstance("SSL", "SunJSSE");
            sslContext.init(null, new TrustManager[]{new DefaultTrustManager()}, new SecureRandom());
            sslContext.getClientSessionContext().setSessionTimeout(15);
            sslContext.getClientSessionContext().setSessionCacheSize(1000);
            socketFactory = sslContext.getSocketFactory();
        }
        catch (Exception e) {
            MybankLogger.logBizError(e);
        }
        verifier = new HostnameVerifier(){

            @Override
            public boolean verify(String paramString, SSLSession paramSSLSession) {
                return true;
            }
        };
    }

    private static class DefaultTrustManager
    implements X509TrustManager {
        private DefaultTrustManager() {
        }

        @Override
        public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }
    }
}

