/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.service;

import com.qqt.platform.common.multitenant.redis.template.QQTRedisTemplate;
import com.qqt.platform.common.security.SecurityUtils;
import com.qqt.platform.common.security.TokenProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class SessionAddressService {
    private Logger logger = LoggerFactory.getLogger(SessionAddressService.class);
    @Autowired
    private QQTRedisTemplate qqtRedisTemplate;
    @Autowired
    private TokenProvider tokenProvider;
    private Long provinceId;
    private String province;
    private String provinceName;
    private Long cityId;
    private String city;
    private String cityName;
    private Long districtId;
    private String district;
    private String districtName;
    private Long streetId;
    private String street;
    private String streetName;

    public <T> T getInfo(String key) {
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        T info = null;
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA:" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            Map<String, Object> sessionDataMap = null;
            boolean hasJwtToken = this.qqtRedisTemplate.hasKey(tokenKey, true);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                sessionDataMap = this.qqtRedisTemplate.opsForHashEntries(tokenKey + "_ADDRESS", true);
                if (sessionDataMap != null && sessionDataMap.containsKey(key)) {
                    return (T)sessionDataMap.get(key);
                }
            }
        }
        return info;
    }

    public <T> T getInfo(String token, String key) {
        T info = null;
        if (!StringUtils.isEmpty((Object)token)) {
            token = token.replace("Bearer ", "");
            String tokenKey = "JWT_TOKEN_DATA:" + token.hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            Map<String, Object> sessionDataMap = null;
            boolean hasJwtToken = this.qqtRedisTemplate.hasKey(tokenKey, true);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                sessionDataMap = this.qqtRedisTemplate.opsForHashEntries(tokenKey + "_ADDRESS", true);
                if (sessionDataMap != null && sessionDataMap.containsKey(key)) {
                    return (T)sessionDataMap.get(key);
                }
            }
        }
        return info;
    }

    public void setInfo(String key, Object value) {
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA:" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            boolean hasJwtToken = this.qqtRedisTemplate.hasKey(tokenKey, true);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                Map<String, Object> sessionDataMap = this.qqtRedisTemplate.opsForHashEntries(tokenKey + "_ADDRESS", true);
                sessionDataMap.put(key, value);
                this.qqtRedisTemplate.opsForHashPutAll(tokenKey + "_ADDRESS", sessionDataMap, true);
            }
        }
    }

    public String getProvince() {
        return (String)this.getInfo("province");
    }

    public void setProvince(String province) {
        this.province = province;
        this.setInfo("province", province);
    }

    public String getCity() {
        return (String)this.getInfo("city");
    }

    public void setCity(String city) {
        this.city = city;
        this.setInfo("city", city);
    }

    public String getDistrict() {
        return (String)this.getInfo("district");
    }

    public void setDistrict(String district) {
        this.district = district;
        this.setInfo("district", district);
    }

    public String getProvinceName() {
        return (String)this.getInfo("provinceName");
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
        this.setInfo("provinceName", provinceName);
    }

    public String getCityName() {
        return (String)this.getInfo("cityName");
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
        this.setInfo("cityName", cityName);
    }

    public String getDistrictName() {
        return (String)this.getInfo("districtName");
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
        this.setInfo("districtName", districtName);
    }

    public String getStreet() {
        return (String)this.getInfo("street");
    }

    public void setStreet(String street) {
        this.street = street;
        this.setInfo("street", street);
    }

    public String getStreetName() {
        return (String)this.getInfo("streetName");
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
        this.setInfo("streetName", streetName);
    }

    public Long getProvinceId() {
        return (Long)this.getInfo("provinceId");
    }

    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
        this.setInfo("provinceId", provinceId);
    }

    public Long getCityId() {
        return (Long)this.getInfo("cityId");
    }

    public void setCityId(Long cityId) {
        this.cityId = cityId;
        this.setInfo("cityId", cityId);
    }

    public Long getDistrictId() {
        return (Long)this.getInfo("districtId");
    }

    public void setDistrictId(Long districtId) {
        this.districtId = districtId;
        this.setInfo("districtId", districtId);
    }

    public Long getStreetId() {
        return (Long)this.getInfo("streetId");
    }

    public void setStreetId(Long streetId) {
        this.streetId = streetId;
        this.setInfo("streetId", streetId);
    }

    public void initAddress(String tokenKey, Map<String, Object> sessionDataMap) {
        HashMap<String, Object> addressMap = new HashMap<String, Object>();
        String fields = "storeFrontId|province|provinceId|provinceName|city|cityId|cityName|district|districtId|districtName|street|streetId|streetName";
        for (String key : sessionDataMap.keySet()) {
            if (!key.matches(fields)) continue;
            addressMap.put(key, sessionDataMap.get(key));
        }
        this.qqtRedisTemplate.opsForHashPutAll(tokenKey + "_ADDRESS", addressMap, true);
    }

    public void updateAddress(Map data) {
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA:" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            boolean hasJwtToken = this.qqtRedisTemplate.hasKey(tokenKey, true);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                Map<String, Object> sessionDataMap = this.qqtRedisTemplate.opsForHashEntries(tokenKey + "_ADDRESS", true);
                sessionDataMap.putAll(data);
                this.qqtRedisTemplate.opsForHashPutAll(tokenKey + "_ADDRESS", sessionDataMap, true);
            }
        }
    }
}

