/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.service;

import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.common.config.CommonConstants;
import com.qqt.platform.common.config.KafkaMessage;
import com.qqt.platform.common.config.SessionCacheTemplate;
import com.qqt.platform.common.dto.DataPermissionDO;
import com.qqt.platform.common.multitenant.redis.template.QQTRedisTemplate;
import com.qqt.platform.common.security.SecurityUtils;
import com.qqt.platform.common.security.TokenProvider;
import com.qqt.platform.common.service.SessionAddressService;
import com.qqt.platform.common.service.dto.UserSession;
import com.qqt.platform.common.utils.KafkaProduceUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
public class SessionService {
    @Autowired
    private QQTRedisTemplate qqtRedisTemplate;
    @Autowired
    private SessionCacheTemplate sessionCacheTemplate;
    @Autowired
    private KafkaProduceUtil kafkaProduceUtil;
    @Value(value="${spring.profiles.active}")
    private String env;
    @Value(value="${spring.application.name}")
    private String appName;
    @Autowired
    private TokenProvider tokenProvider;
    @Autowired
    private SessionAddressService sessionAddressService;
    private Logger logger = LoggerFactory.getLogger(SessionService.class);
    public static final String SESSION_ADDRESS_FIELDS = "storeFrontId|province|provinceId|provinceName|city|cityId|cityName|district|districtId|districtName|street|streetId|streetName";
    private Long userId;
    private String userCode;
    private String userName;
    private String siteCode;
    private String siteElsAccount;
    private Long siteId;
    private Long storeId;
    private Long companyId;
    private Long currencyId;
    private Long languageId;
    private String storeCode;
    private String languageCode;
    private String companyCode;
    private String companyType;
    private String companyName;
    private Long departmentId;
    private String elsAccount;
    private Long provinceId;
    private String province;
    private String provinceName;
    private Long cityId;
    private String city;
    private String cityName;
    private Long districtId;
    private String district;
    private String districtName;
    private Long streetId;
    private String street;
    private String streetName;
    private Boolean isPlatform;
    private Boolean isPurchaser;
    private String subCompanyCode;
    private Long subCompanyId;
    private String subCompanyName;
    private Boolean anonymous;
    private Long siteCompanyId;
    private String storeCompanyCode;
    private String siteType;
    private Long platformCompanyId;
    private Long platformCompanySiteId;
    private Long proxyUserId;
    private String proxyUserToken;
    private String dataPermission;
    private String tenantCompanyName;
    private String oneIdUserId;
    private String oneSessionId;

    public UserSession getSessionInfo() {
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        UserSession userSession = new UserSession();
        Map<String, Object> sessionDataMap = null;
        if (jwtOpt.isPresent()) {
            boolean hasJwtToken;
            String tokenKey = "JWT_TOKEN_DATA:" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            sessionDataMap = this.querySessionLocalCache(tokenKey);
            if (CollectionUtils.isEmpty(sessionDataMap) && (hasJwtToken = this.qqtRedisTemplate.hasKey(tokenKey, true).booleanValue())) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                sessionDataMap = this.qqtRedisTemplate.opsForHashEntries(tokenKey, true);
                if (sessionDataMap != null) {
                    this.putSessionLocalCache(tokenKey, sessionDataMap);
                }
            }
        }
        if (sessionDataMap != null) {
            if (sessionDataMap.containsKey("userId")) {
                userSession.setUserId((Long)sessionDataMap.get("userId"));
            }
            if (sessionDataMap.containsKey("userCode")) {
                userSession.setUserCode((String)sessionDataMap.get("userCode"));
            }
            if (sessionDataMap.containsKey("userName")) {
                userSession.setUserName((String)sessionDataMap.get("userName"));
            }
            if (sessionDataMap.containsKey("companyId")) {
                userSession.setCompanyId((Long)sessionDataMap.get("companyId"));
            }
            if (sessionDataMap.containsKey("companyCode")) {
                userSession.setCompanyCode((String)sessionDataMap.get("companyCode"));
            }
            if (sessionDataMap.containsKey("companyType")) {
                userSession.setCompanyType((String)sessionDataMap.get("companyType"));
            }
            if (sessionDataMap.containsKey("companyName")) {
                userSession.setCompanyName((String)sessionDataMap.get("companyName"));
            }
            if (sessionDataMap.containsKey("languageCode")) {
                userSession.setLanguageCode((String)sessionDataMap.get("languageCode"));
            }
            if (sessionDataMap.containsKey("storeId")) {
                userSession.setStoreId((Long)sessionDataMap.get("storeId"));
            }
            if (sessionDataMap.containsKey("storeCode")) {
                userSession.setStoreCode((String)sessionDataMap.get("storeCode"));
            }
            if (sessionDataMap.containsKey("storeCompanyCode")) {
                userSession.setStoreCompanyCode((String)sessionDataMap.get("storeCompanyCode"));
            }
            if (sessionDataMap.containsKey("siteId")) {
                userSession.setSiteId((Long)sessionDataMap.get("siteId"));
            }
            if (sessionDataMap.containsKey("siteType")) {
                userSession.setSiteType((String)sessionDataMap.get("siteType"));
            }
            if (sessionDataMap.containsKey("siteCode")) {
                userSession.setSiteCode((String)sessionDataMap.get("siteCode"));
            }
            if (sessionDataMap.containsKey("siteElsAccount")) {
                userSession.setSiteElsAccount((String)sessionDataMap.get("siteElsAccount"));
            }
            if (sessionDataMap.containsKey("siteCompanyId")) {
                userSession.setSiteCompanyId((Long)sessionDataMap.get("siteCompanyId"));
            }
            if (sessionDataMap.containsKey("currencyId")) {
                userSession.setCurrencyId((Long)sessionDataMap.get("currencyId"));
            }
            if (sessionDataMap.containsKey("languageId")) {
                userSession.setLanguageId((Long)sessionDataMap.get("languageId"));
            }
            if (sessionDataMap.containsKey("departmentId")) {
                userSession.setDepartmentId((Long)sessionDataMap.get("departmentId"));
            }
            if (sessionDataMap.containsKey("elsAccount")) {
                userSession.setElsAccount((String)sessionDataMap.get("elsAccount"));
            }
            if (sessionDataMap.containsKey("province")) {
                userSession.setProvince((String)sessionDataMap.get("province"));
            }
            if (sessionDataMap.containsKey("provinceId")) {
                userSession.setProvinceId((Long)sessionDataMap.get("provinceId"));
            }
            if (sessionDataMap.containsKey("provinceName")) {
                userSession.setProvinceName((String)sessionDataMap.get("provinceName"));
            }
            if (sessionDataMap.containsKey("city")) {
                userSession.setCity((String)sessionDataMap.get("city"));
            }
            if (sessionDataMap.containsKey("cityId")) {
                userSession.setCityId((Long)sessionDataMap.get("cityId"));
            }
            if (sessionDataMap.containsKey("cityName")) {
                userSession.setCityName((String)sessionDataMap.get("cityName"));
            }
            if (sessionDataMap.containsKey("district")) {
                userSession.setDistrict((String)sessionDataMap.get("district"));
            }
            if (sessionDataMap.containsKey("districtId")) {
                userSession.setDistrictId((Long)sessionDataMap.get("districtId"));
            }
            if (sessionDataMap.containsKey("districtName")) {
                userSession.setDistrictName((String)sessionDataMap.get("districtName"));
            }
            if (sessionDataMap.containsKey("platformCompanyId")) {
                userSession.setPlatformCompanyId((Long)sessionDataMap.get("platformCompanyId"));
            }
            if (sessionDataMap.containsKey("platformCompanySiteId")) {
                userSession.setPlatformCompanySiteId((Long)sessionDataMap.get("platformCompanySiteId"));
            }
            if (sessionDataMap.containsKey("proxyUserId")) {
                userSession.setProxyUserId((Long)sessionDataMap.get("proxyUserId"));
            }
            if (sessionDataMap.containsKey("proxyUserToken")) {
                userSession.setProxyUserToken((String)sessionDataMap.get("proxyUserToken"));
            }
            if (sessionDataMap.containsKey("streetId")) {
                userSession.setStreetId((Long)sessionDataMap.get("streetId"));
            }
            if (sessionDataMap.containsKey("streetName")) {
                userSession.setStreetName((String)sessionDataMap.get("streetName"));
            }
            if (sessionDataMap.containsKey("street")) {
                userSession.setStreet((String)sessionDataMap.get("street"));
            }
            if (sessionDataMap.containsKey("isPlatform")) {
                userSession.setPlatform((Boolean)sessionDataMap.get("isPlatform"));
            }
            if (sessionDataMap.containsKey("isPurchaser")) {
                userSession.setPurchaser((Boolean)sessionDataMap.get("isPurchaser"));
            }
            if (sessionDataMap.containsKey("subCompanyCode")) {
                userSession.setSubCompanyCode((String)sessionDataMap.get("subCompanyCode"));
            }
            if (sessionDataMap.containsKey("subCompanyId")) {
                userSession.setSubCompanyId((Long)sessionDataMap.get("subCompanyId"));
            }
            if (sessionDataMap.containsKey("subCompanyName")) {
                userSession.setSubCompanyName((String)sessionDataMap.get("subCompanyName"));
            }
            if (sessionDataMap.containsKey("tenantCompanyName")) {
                userSession.setTenantCompanyName((String)sessionDataMap.get("tenantCompanyName"));
            }
            if (sessionDataMap.containsKey("supplierSiteId")) {
                userSession.setSupplierSiteId((Long)sessionDataMap.get("supplierSiteId"));
            }
            if (sessionDataMap.containsKey("storeFrontId")) {
                userSession.setStoreFrontId((Long)sessionDataMap.get("storeFrontId"));
            }
            if (sessionDataMap.containsKey("matrlSupplier")) {
                userSession.setMatrlSupplier((Boolean)sessionDataMap.get("matrlSupplier"));
            }
            if (sessionDataMap.containsKey("projectSupplier")) {
                userSession.setProjectSupplier((Boolean)sessionDataMap.get("projectSupplier"));
            }
            if (sessionDataMap.containsKey("designSupplier")) {
                userSession.setDesignSupplier((Boolean)sessionDataMap.get("designSupplier"));
            }
            if (sessionDataMap.containsKey("storeProjectSupplier")) {
                userSession.setStoreProjectSupplier((Boolean)sessionDataMap.get("storeProjectSupplier"));
            }
            if (sessionDataMap.containsKey("oneIdUserId")) {
                userSession.setOneIdUserId((String)sessionDataMap.get("oneIdUserId"));
            }
            if (sessionDataMap.containsKey("oneSessionId")) {
                userSession.setOneSessionId((String)sessionDataMap.get("oneSessionId"));
            }
        }
        return userSession;
    }

    public <T> T getInfo(String token, String key) {
        if (this.isSessionAddressKey(key)) {
            return this.sessionAddressService.getInfo(token, key);
        }
        T info = null;
        if (!StringUtils.isEmpty((Object)token)) {
            token = token.replace("Bearer ", "");
            String tokenKey = "JWT_TOKEN_DATA:" + token.hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            Map<String, Object> sessionDataMap = null;
            sessionDataMap = this.querySessionLocalCache(tokenKey);
            if (!CollectionUtils.isEmpty(sessionDataMap) && sessionDataMap.containsKey(key)) {
                return (T)sessionDataMap.get(key);
            }
            boolean hasJwtToken = this.qqtRedisTemplate.hasKey(tokenKey, true);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                sessionDataMap = this.qqtRedisTemplate.opsForHashEntries(tokenKey, true);
                if (sessionDataMap != null) {
                    this.putSessionLocalCache(tokenKey, sessionDataMap);
                    if (sessionDataMap.containsKey(key)) {
                        return (T)sessionDataMap.get(key);
                    }
                }
            }
        }
        return info;
    }

    private <T> T getInfo(String key) {
        if (this.isSessionAddressKey(key)) {
            return this.sessionAddressService.getInfo(key);
        }
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        T info = null;
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA:" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            Map<String, Object> sessionDataMap = null;
            sessionDataMap = this.querySessionLocalCache(tokenKey);
            if (!CollectionUtils.isEmpty(sessionDataMap) && sessionDataMap.containsKey(key)) {
                return (T)sessionDataMap.get(key);
            }
            boolean hasJwtToken = this.qqtRedisTemplate.hasKey(tokenKey, true);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                sessionDataMap = this.qqtRedisTemplate.opsForHashEntries(tokenKey, true);
                if (sessionDataMap != null) {
                    this.putSessionLocalCache(tokenKey, sessionDataMap);
                    if (sessionDataMap.containsKey(key)) {
                        return (T)sessionDataMap.get(key);
                    }
                }
            }
        }
        return info;
    }

    private void setInfo(String key, Object value) {
        if (this.isSessionAddressKey(key)) {
            this.sessionAddressService.setInfo(key, value);
            return;
        }
        Optional<String> jwtOpt = SecurityUtils.getCurrentUserJWT();
        if (jwtOpt.isPresent()) {
            String tokenKey = "JWT_TOKEN_DATA:" + jwtOpt.get().hashCode();
            this.logger.debug("getSessionInfo ==>check tokenKey:{}", (Object)tokenKey);
            boolean hasJwtToken = this.qqtRedisTemplate.hasKey(tokenKey, true);
            if (hasJwtToken) {
                this.logger.debug("checkExpired ==> begin get Jwt Token from redis.tokenKey:{}", (Object)tokenKey);
                Map<String, Object> sessionDataMap = this.qqtRedisTemplate.opsForHashEntries(tokenKey, true);
                sessionDataMap.put(key, value);
                this.qqtRedisTemplate.opsForHashPutAll(tokenKey, sessionDataMap, true);
                this.putSessionLocalCache(tokenKey, sessionDataMap);
            }
        }
    }

    private Map<String, Object> querySessionLocalCache(String key) {
        return this.sessionCacheTemplate.getCacheByKey(key);
    }

    public void putSessionLocalCache(String key, Map<String, Object> data) {
        this.sessionCacheTemplate.removeCacheByKey(key);
        this.sessionCacheTemplate.putCacheByKey(key, data);
        try {
            KafkaMessage kafkaMessage = new KafkaMessage();
            kafkaMessage.setChannel("b2b_session_cache_" + this.env);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("token", (Object)key);
            jsonObject.put("appName", (Object)this.appName);
            kafkaMessage.setMessage(jsonObject);
            this.kafkaProduceUtil.sendMessage(kafkaMessage);
        }
        catch (Exception e) {
            this.logger.error("kafkaProduceUtil.sendMessage error", (Throwable)e);
        }
    }

    public void removeSessionLocalCache(String key) {
        this.sessionCacheTemplate.removeCacheByKey(key);
    }

    public Long getCurrentUserId() {
        return (Long)this.getInfo("userId");
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getCurrentUserCode() {
        return (String)this.getInfo("userCode");
    }

    public void setUserCode(String userCode) {
        this.userCode = userCode;
    }

    public String getCurrentUserName() {
        return (String)this.getInfo("userName");
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getCurrentSiteCode() {
        return (String)this.getInfo("siteCode");
    }

    public void setSiteCode(String siteCode) {
        this.siteCode = siteCode;
    }

    public String getCurrentStoreCode() {
        return (String)this.getInfo("storeCode");
    }

    public void setStoreCode(String storeCode) {
        this.storeCode = storeCode;
    }

    public String getCurrentLanguageCode() {
        return (String)this.getInfo("languageCode");
    }

    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String getCurrentCompanyCode() {
        return (String)this.getInfo("companyCode");
    }

    public void setCompanyCode(String companyCode) {
        this.companyCode = companyCode;
    }

    public String getCurrentCompanyType() {
        return (String)this.getInfo("companyType");
    }

    public void setCompanyType(String companyType) {
        this.companyType = companyType;
    }

    public String getCurrentCompanyName() {
        return (String)this.getInfo("companyName");
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public Long getSiteId() {
        return (Long)this.getInfo("siteId");
    }

    public void setSiteId(Long siteId) {
        this.siteId = siteId;
    }

    public Long getSiteCompanyId() {
        return (Long)this.getInfo("siteCompanyId");
    }

    public void setSiteCompanyId(Long siteCompanyId) {
        this.siteCompanyId = siteCompanyId;
        this.setInfo("siteCompanyId", siteCompanyId);
    }

    public Long getStoreId() {
        return (Long)this.getInfo("storeId");
    }

    public void setStoreId(Long storeId) {
        this.storeId = storeId;
    }

    public Long getCompanyId() {
        return (Long)this.getInfo("companyId");
    }

    public void setCompanyId(Long companyId) {
        this.companyId = companyId;
    }

    public Long getCurrencyId() {
        return (Long)this.getInfo("currencyId");
    }

    public void setCurrencyId(Long currencyId) {
        this.currencyId = currencyId;
    }

    public Long getLanguageId() {
        return (Long)this.getInfo("languageId");
    }

    public void setLanguageId(Long languageId) {
        this.languageId = languageId;
    }

    public Long getDepartmentId() {
        return (Long)this.getInfo("departmentId");
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public boolean isPlatform() {
        return (Boolean)this.getInfo("isPlatform");
    }

    public String getElsAccount() {
        return (String)this.getInfo("elsAccount");
    }

    public void setElsAccount(String elsAccount) {
        this.elsAccount = elsAccount;
    }

    public String getProvince() {
        return (String)this.getInfo("province");
    }

    public String getStoreCompanyCode() {
        return (String)this.getInfo("storeCompanyCode");
    }

    public Boolean getNewIsPlatform() {
        String siteCode = CommonConstants.SiteCodeEnum.getSiteCode(this.getCurrentSiteCode());
        if (!StringUtils.isEmpty((Object)siteCode) && CommonConstants.SiteCodeEnum.QQTMANAGER.name().equalsIgnoreCase(siteCode)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getNewIsPurchaseManager() {
        String siteCode = CommonConstants.SiteCodeEnum.getSiteCode(this.getCurrentSiteCode());
        if (!StringUtils.isEmpty((Object)siteCode) && CommonConstants.SiteCodeEnum.QQTPURCHASERMANAGER.name().equalsIgnoreCase(siteCode)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getNewIsPurchaser() {
        String siteCode = CommonConstants.SiteCodeEnum.getSiteCode(this.getCurrentSiteCode());
        if (!StringUtils.isEmpty((Object)siteCode) && CommonConstants.SiteCodeEnum.QQTPURCHASE.name().equalsIgnoreCase(siteCode)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean getNewIsSupplierManager() {
        String siteCode = CommonConstants.SiteCodeEnum.getSiteCode(this.getCurrentSiteCode());
        if (!StringUtils.isEmpty((Object)siteCode) && CommonConstants.SiteCodeEnum.QQTSUPPLIERMANAGER.name().equalsIgnoreCase(siteCode)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void setProvince(String province) {
        this.province = province;
        this.setInfo("province", province);
    }

    public String getCity() {
        return (String)this.getInfo("city");
    }

    public void setCity(String city) {
        this.city = city;
        this.setInfo("city", city);
    }

    public String getDistrict() {
        return (String)this.getInfo("district");
    }

    public void setDistrict(String district) {
        this.district = district;
        this.setInfo("district", district);
    }

    public String getProvinceName() {
        return (String)this.getInfo("provinceName");
    }

    public void setProvinceName(String provinceName) {
        this.provinceName = provinceName;
        this.setInfo("provinceName", provinceName);
    }

    public String getCityName() {
        return (String)this.getInfo("cityName");
    }

    public void setCityName(String cityName) {
        this.cityName = cityName;
        this.setInfo("cityName", cityName);
    }

    public String getDistrictName() {
        return (String)this.getInfo("districtName");
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
        this.setInfo("districtName", districtName);
    }

    public String getStreet() {
        return (String)this.getInfo("street");
    }

    public void setStreet(String street) {
        this.street = street;
        this.setInfo("street", street);
    }

    public String getStreetName() {
        return (String)this.getInfo("streetName");
    }

    public void setStreetName(String streetName) {
        this.streetName = streetName;
        this.setInfo("streetName", streetName);
    }

    public Long getProvinceId() {
        return (Long)this.getInfo("provinceId");
    }

    public void setProvinceId(Long provinceId) {
        this.provinceId = provinceId;
        this.setInfo("provinceId", provinceId);
    }

    public Long getCityId() {
        return (Long)this.getInfo("cityId");
    }

    public void setCityId(Long cityId) {
        this.cityId = cityId;
        this.setInfo("cityId", cityId);
    }

    public Long getDistrictId() {
        return (Long)this.getInfo("districtId");
    }

    public void setDistrictId(Long districtId) {
        this.districtId = districtId;
        this.setInfo("districtId", districtId);
    }

    public Long getStreetId() {
        return (Long)this.getInfo("streetId");
    }

    public void setStreetId(Long streetId) {
        this.streetId = streetId;
        this.setInfo("streetId", streetId);
    }

    public Boolean getPlatform() {
        return (Boolean)this.getInfo("isPlatform");
    }

    public void setPlatform(Boolean platform) {
        this.isPlatform = platform;
        this.setInfo("isPlatform", platform);
    }

    public Boolean getPurchaser() {
        return (Boolean)this.getInfo("isPurchaser");
    }

    public void setPurchaser(Boolean purchaser) {
        this.isPurchaser = purchaser;
        this.setInfo("isPurchaser", purchaser);
    }

    public String getSubCompanyCode() {
        return (String)this.getInfo("subCompanyCode");
    }

    public void setSubCompanyCode(String subCompanyCode) {
        this.subCompanyCode = subCompanyCode;
        this.setInfo("subCompanyCode", subCompanyCode);
    }

    public Long getSubCompanyId() {
        return (Long)this.getInfo("subCompanyId");
    }

    public void setSubCompanyId(Long subCompanyId) {
        this.subCompanyId = subCompanyId;
        this.setInfo("subCompanyId", subCompanyId);
    }

    public String getSubCompanyName() {
        return (String)this.getInfo("subCompanyName");
    }

    public void setSubCompanyName(String subCompanyName) {
        this.subCompanyName = subCompanyName;
        this.setInfo("subCompanyName", subCompanyName);
    }

    public Boolean getAnonymous() {
        Boolean anonymous = (Boolean)this.getInfo("anonymous");
        if (anonymous == null) {
            return Boolean.FALSE;
        }
        return anonymous;
    }

    public String getSiteType() {
        return (String)this.getInfo("siteType");
    }

    public void setSiteType(String siteType) {
        this.siteType = siteType;
    }

    public Long getPlatformCompanyId() {
        return (Long)this.getInfo("platformCompanyId");
    }

    public void setPlatformCompanyId(Long platformCompanyId) {
        this.platformCompanyId = platformCompanyId;
    }

    public Long getPlatformCompanySiteId() {
        return (Long)this.getInfo("platformCompanySiteId");
    }

    public void setPlatformCompanySiteId(Long platformCompanySiteId) {
        this.platformCompanySiteId = platformCompanySiteId;
    }

    public Long getProxyUserId() {
        return (Long)this.getInfo("proxyUserId");
    }

    public void setProxyUserId(Long proxyUserId) {
        this.proxyUserId = proxyUserId;
    }

    public String getProxyUserToken() {
        return (String)this.getInfo("proxyUserToken");
    }

    public void setProxyUserToken(String proxyUserToken) {
        this.proxyUserToken = proxyUserToken;
    }

    public String getSiteElsAccount() {
        return (String)this.getInfo("siteElsAccount");
    }

    public void setSiteElsAccount(String siteElsAccount) {
        this.siteElsAccount = siteElsAccount;
    }

    public List<DataPermissionDO> getDataPermission() {
        return (List)this.getInfo("dataPermission");
    }

    public String getTenantCompanyName() {
        return (String)this.getInfo("tenantCompanyName");
    }

    public void setTenantCompanyName(String tenantCompanyName) {
        this.tenantCompanyName = tenantCompanyName;
    }

    public List<Long> getSubCompanyIdList() {
        List<Long> subCompanyIdList = (List<Long>)this.getInfo("subCompanyIdList");
        if (subCompanyIdList == null) {
            subCompanyIdList = Collections.emptyList();
        }
        return subCompanyIdList;
    }

    private boolean isSessionAddressKey(String key) {
        return key.matches(SESSION_ADDRESS_FIELDS);
    }

    public Long getStoreFrontId() {
        return (Long)this.getInfo("storeFrontId");
    }

    public Boolean getMatrlSupplier() {
        return (Boolean)this.getInfo("matrlSupplier");
    }

    public Boolean getDesignSupplier() {
        return (Boolean)this.getInfo("designSupplier");
    }

    public Boolean getProjectSupplier() {
        return (Boolean)this.getInfo("projectSupplier");
    }

    public Boolean getStoreProjectSupplier() {
        return (Boolean)this.getInfo("storeProjectSupplier");
    }

    public void setStoreFrontId(Long storeFrontId) {
        this.setInfo("storeFrontId", storeFrontId);
    }

    public void updateAddress(Map sessionDataMap) {
        this.sessionAddressService.updateAddress(sessionDataMap);
    }

    public String getOneIdUserId() {
        return (String)this.getInfo("oneIdUserId");
    }

    public void setOneIdUserId(String oneIdUserId) {
        this.oneIdUserId = oneIdUserId;
    }

    public String getOneSessionId() {
        return (String)this.getInfo("oneSessionId");
    }

    public void setOneSessionId(String oneSessionId) {
        this.oneSessionId = oneSessionId;
    }
}

