/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.qqt.platform.common.dto.AddressDO;
import com.qqt.platform.common.dto.CityDO;
import com.qqt.platform.common.dto.CompanyDO;
import com.qqt.platform.common.dto.CompanyGroupDO;
import com.qqt.platform.common.dto.CountryDO;
import com.qqt.platform.common.dto.CustomerLevelDO;
import com.qqt.platform.common.dto.DistrictDO;
import com.qqt.platform.common.dto.ProvinceDO;
import com.qqt.platform.common.dto.ResultDTO;
import com.qqt.platform.common.dto.SiteDO;
import com.qqt.platform.common.dto.StoreDO;
import com.qqt.platform.common.dto.UserDetailDO;
import com.qqt.platform.common.dto.UserGroupDO;
import com.qqt.platform.common.event.LoadDataEvent;
import com.qqt.platform.common.feign.AdminFeignService;
import com.qqt.platform.common.utils.EntityCacheUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;

@Component
public class AdminEntityCacheUtils {
    public static final String APP_NAME_ADMIN = "b2b-admin";
    public static final String APP_NAME_TENANT = "tenant";
    public static final String COMPANY_NAME = "Company";
    public static final String USER_NAME = "User";
    public static final String SITE_NAME = "Site";
    public static final String STORE_NAME = "Store";
    public static final String USERGROUP_NAME = "UserGroup";
    public static final String ADDRESS_NAME = "Address";
    public static final String COUNTRY_NAME = "Country";
    public static final String PROVINCE_NAME = "Province";
    public static final String CITY_NAME = "City";
    public static final String DISTRICT_NAME = "District";
    public static final String CUSTOMERLEVEL_NAME = "CustomerLevel";
    public static final String COMPANYGROUP_NAME = "CompanyGroup";
    @Autowired
    private EntityCacheUtils entityCacheUtils;
    @Autowired
    private AdminFeignService adminFeignService;
    @Autowired
    private ObjectMapper objectMapper;
    @Value(value="${spring.application.name}")
    private String appName;
    @Autowired
    private ApplicationEventPublisher applicationEventPublisher;

    public CompanyDO getCompanyDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), COMPANY_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "COMPANY");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (CompanyDO)loadDataEvent.getEntity();
            }
            ResponseEntity<ResultDTO<CompanyDO>> companyResp = this.adminFeignService.getCompanyById(id, new String[0]);
            if (companyResp != null && companyResp.getBody() != null && ((ResultDTO)companyResp.getBody()).isSuccess()) {
                CompanyDO companyDO = (CompanyDO)((ResultDTO)companyResp.getBody()).getData();
                return companyDO;
            }
        } else {
            if (null != map.get("categoryIds")) {
                String categoryIds = map.get("categoryIds").toString();
                List<String> categoryIdList = Arrays.asList(categoryIds.split(","));
                map.put("categoryIds", categoryIdList);
            }
            return (CompanyDO)this.objectMapper.convertValue((Object)map, CompanyDO.class);
        }
        return null;
    }

    public UserDetailDO getUserDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), USER_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "USER");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (UserDetailDO)loadDataEvent.getEntity();
            }
            ResponseEntity<ResultDTO<UserDetailDO>> responseEntity = this.adminFeignService.getUserDetailById(id, new String[]{"basic"});
            if (responseEntity != null && responseEntity.getBody() != null && ((ResultDTO)responseEntity.getBody()).isSuccess()) {
                UserDetailDO userDetailDO = (UserDetailDO)((ResultDTO)responseEntity.getBody()).getData();
                return userDetailDO;
            }
        } else {
            map.put("companyId", map.get("company"));
            return (UserDetailDO)this.objectMapper.convertValue((Object)map, UserDetailDO.class);
        }
        return null;
    }

    public SiteDO getSiteDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), SITE_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "SITE");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (SiteDO)loadDataEvent.getEntity();
            }
            ResponseEntity<SiteDO> responseEntity = this.adminFeignService.getSiteDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                SiteDO siteDO = (SiteDO)responseEntity.getBody();
                return siteDO;
            }
        } else {
            map.put("companyId", map.get("company"));
            return (SiteDO)this.objectMapper.convertValue((Object)map, SiteDO.class);
        }
        return null;
    }

    public StoreDO getStoreDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), STORE_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "STORE");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (StoreDO)loadDataEvent.getEntity();
            }
            ResponseEntity<StoreDO> responseEntity = this.adminFeignService.getStoreDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                StoreDO storeDO = (StoreDO)responseEntity.getBody();
                return storeDO;
            }
        } else {
            map.put("companyId", map.get("company"));
            map.put("siteId", map.get("site"));
            return (StoreDO)this.objectMapper.convertValue((Object)map, StoreDO.class);
        }
        return null;
    }

    public UserGroupDO getUserGroupDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), USERGROUP_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "USERGROUP");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (UserGroupDO)loadDataEvent.getEntity();
            }
            ResponseEntity<UserGroupDO> responseEntity = this.adminFeignService.getUserGroupById(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                UserGroupDO userGroupDO = (UserGroupDO)responseEntity.getBody();
                return (UserGroupDO)responseEntity.getBody();
            }
        } else {
            map.put("companyId", map.get("company"));
            map.put("parentId", map.get("parent"));
            return (UserGroupDO)this.objectMapper.convertValue((Object)map, UserGroupDO.class);
        }
        return null;
    }

    public AddressDO getAddressDO(Long companyId, Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), ADDRESS_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "ADDRESS");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (AddressDO)loadDataEvent.getEntity();
            }
            ResponseEntity<AddressDO> responseEntity = this.adminFeignService.getAddressDO(companyId, id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                AddressDO addressDO = (AddressDO)responseEntity.getBody();
                return addressDO;
            }
        } else {
            map.put("companyId", map.get("company"));
            map.put("userId", map.get("user"));
            AddressDO addressDO = (AddressDO)this.objectMapper.convertValue((Object)map, AddressDO.class);
            this.fillAddressDO(map, addressDO);
            return addressDO;
        }
        return null;
    }

    public AddressDO getAddressDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), ADDRESS_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "ADDRESS");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (AddressDO)loadDataEvent.getEntity();
            }
            ResponseEntity<AddressDO> responseEntity = this.adminFeignService.getAddressDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                AddressDO addressDO = (AddressDO)responseEntity.getBody();
                return addressDO;
            }
        } else {
            map.put("companyId", map.get("company"));
            map.put("userId", map.get("user"));
            AddressDO addressDO = (AddressDO)this.objectMapper.convertValue((Object)map, AddressDO.class);
            this.fillAddressDO(map, addressDO);
            return addressDO;
        }
        return null;
    }

    private void fillAddressDO(Map map, AddressDO addressDO) {
        try {
            if (null != map.get("country")) {
                Long country = (Long)map.get("country");
                Map countryMap = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), COUNTRY_NAME), country);
                CountryDO countryDO = (CountryDO)this.objectMapper.convertValue((Object)countryMap, CountryDO.class);
                addressDO.setCountryDO(countryDO);
                addressDO.setCountryId(country);
            }
            if (null != map.get("province")) {
                Long province = (Long)map.get("province");
                Map provinceMap = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), PROVINCE_NAME), province);
                ProvinceDO provinceDO = (ProvinceDO)this.objectMapper.convertValue((Object)provinceMap, ProvinceDO.class);
                addressDO.setProvinceDO(provinceDO);
                addressDO.setProvinceId(province);
            }
            if (null != map.get("city")) {
                Long city = (Long)map.get("city");
                Map cityMap = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), CITY_NAME), city);
                CityDO cityDO = (CityDO)this.objectMapper.convertValue((Object)cityMap, CityDO.class);
                addressDO.setCityDO(cityDO);
                addressDO.setCityId(city);
            }
            if (null != map.get("district")) {
                Long district = (Long)map.get("district");
                Map districtMap = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), DISTRICT_NAME), district);
                DistrictDO districtDO = (DistrictDO)this.objectMapper.convertValue((Object)districtMap, DistrictDO.class);
                addressDO.setDistrictDO(districtDO);
                addressDO.setDistrictId(district);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CustomerLevelDO getCustomerLevelDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), CUSTOMERLEVEL_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "CUSTOMERLEVEL");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (CustomerLevelDO)loadDataEvent.getEntity();
            }
            ResultDTO<CustomerLevelDO> responseEntity = this.adminFeignService.getCustomerLevelById(id);
            if (responseEntity != null && responseEntity.isSuccess()) {
                return responseEntity.getData();
            }
        } else {
            return (CustomerLevelDO)this.objectMapper.convertValue((Object)map, CustomerLevelDO.class);
        }
        return null;
    }

    public CountryDO getCountryDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), COUNTRY_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "COUNTRY");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (CountryDO)loadDataEvent.getEntity();
            }
            ResponseEntity<CountryDO> responseEntity = this.adminFeignService.getCountryDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                CountryDO countryDO = (CountryDO)responseEntity.getBody();
                return countryDO;
            }
        } else {
            CountryDO countryDO = (CountryDO)this.objectMapper.convertValue((Object)map, CountryDO.class);
            return countryDO;
        }
        return null;
    }

    public ProvinceDO getProvinceDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), PROVINCE_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "PROVINCE");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (ProvinceDO)loadDataEvent.getEntity();
            }
            ResponseEntity<ProvinceDO> responseEntity = this.adminFeignService.getProvinceDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                ProvinceDO provinceDO = (ProvinceDO)responseEntity.getBody();
                return provinceDO;
            }
        } else {
            ProvinceDO provinceDO = (ProvinceDO)this.objectMapper.convertValue((Object)map, ProvinceDO.class);
            return provinceDO;
        }
        return null;
    }

    public CityDO getCityDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), CITY_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "CITY");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (CityDO)loadDataEvent.getEntity();
            }
            ResponseEntity<CityDO> responseEntity = this.adminFeignService.getCityDO(id);
            if (responseEntity != null && responseEntity.getBody() != null) {
                CityDO cityDO = (CityDO)responseEntity.getBody();
                return cityDO;
            }
        } else {
            CityDO cityDO = (CityDO)this.objectMapper.convertValue((Object)map, CityDO.class);
            return cityDO;
        }
        return null;
    }

    public boolean isTargetApp() {
        return APP_NAME_ADMIN.equals(this.appName) || APP_NAME_TENANT.equals(this.appName);
    }

    private String getFixedAppName() {
        if (this.isTargetApp()) {
            return this.appName;
        }
        return APP_NAME_ADMIN;
    }

    public CompanyGroupDO getCompanyGroupDO(Long id) {
        if (id == null || id <= 0L) {
            return null;
        }
        Map map = this.entityCacheUtils.getFromCache(EntityClassEnum.getEntityClass(this.getFixedAppName(), COMPANYGROUP_NAME), id);
        if (map == null) {
            if (this.isTargetApp()) {
                LoadDataEvent loadDataEvent = new LoadDataEvent(id, "COMPANYGROUP");
                this.applicationEventPublisher.publishEvent(loadDataEvent);
                return (CompanyGroupDO)loadDataEvent.getEntity();
            }
            ResultDTO<CompanyGroupDO> responseEntity = this.adminFeignService.getCompanyGroupDOById(id);
            if (responseEntity != null && responseEntity.isSuccess()) {
                return responseEntity.getData();
            }
        } else {
            if (!map.containsKey("companyId")) {
                map.put("companyId", map.get("company"));
            }
            return (CompanyGroupDO)this.objectMapper.convertValue((Object)map, CompanyGroupDO.class);
        }
        return null;
    }

    static enum EntityClassEnum {
        ADMIN_COMPANY_CLASS("b2b-admin", "Company", "com.qqt.platform.admin.domain.Company"),
        ADMIN_USER_CLASS("b2b-admin", "User", "com.qqt.platform.admin.domain.User"),
        ADMIN_SITE_CLASS("b2b-admin", "Site", "com.qqt.platform.admin.domain.Site"),
        ADMIN_STORE_CLASS("b2b-admin", "Store", "com.qqt.platform.admin.domain.Store"),
        ADMIN_USERGROUP_CLASS("b2b-admin", "UserGroup", "com.qqt.platform.admin.domain.UserGroup"),
        ADMIN_ADDRESS_CLASS("b2b-admin", "Address", "com.qqt.platform.admin.domain.Address"),
        ADMIN_COUNTRY_CLASS("b2b-admin", "Country", "com.qqt.platform.admin.domain.Country"),
        ADMIN_PROVINCE_CLASS("b2b-admin", "Province", "com.qqt.platform.admin.domain.Province"),
        ADMIN_CITY_CLASS("b2b-admin", "City", "com.qqt.platform.admin.domain.City"),
        ADMIN_DISTRICT_CLASS("b2b-admin", "District", "com.qqt.platform.admin.domain.District"),
        ADMIN_CUSTOMERLEVEL_CLASS("b2b-admin", "CustomerLevel", "com.qqt.platform.admin.domain.CustomerLevel"),
        ADMIN_COMPANYGROUP_CLASS("b2b-admin", "CompanyGroup", "com.qqt.platform.admin.domain.CompanyGroup"),
        TENANT_COMPANY_CLASS("tenant", "Company", "com.qqt.platform.tenant.domain.Company"),
        TENANT_USER_CLASS("tenant", "User", "com.qqt.platform.tenant.domain.User"),
        TENANT_SITE_CLASS("tenant", "Site", "com.qqt.platform.tenant.domain.Site"),
        TENANT_STORE_CLASS("tenant", "Store", "com.qqt.platform.tenant.domain.Store"),
        TENANT_USERGROUP_CLASS("tenant", "UserGroup", "com.qqt.platform.tenant.domain.UserGroup"),
        TENANT_ADDRESS_CLASS("tenant", "Address", "com.qqt.platform.tenant.domain.Address"),
        TENANT_COUNTRY_CLASS("tenant", "Country", "com.qqt.platform.tenant.domain.Country"),
        TENANT_PROVINCE_CLASS("tenant", "Province", "com.qqt.platform.tenant.domain.Province"),
        TENANT_CITY_CLASS("tenant", "City", "com.qqt.platform.tenant.domain.City"),
        TENANT_DISTRICT_CLASS("tenant", "District", "com.qqt.platform.tenant.domain.District"),
        TENANT_CUSTOMERLEVEL_CLASS("tenant", "CustomerLevel", "com.qqt.platform.tenant.domain.CustomerLevel"),
        TENANT_COMPANYGROUP_CLASS("tenant", "CompanyGroup", "com.qqt.platform.tenant.domain.CompanyGroup");

        private String appName;
        private String entityName;
        private String className;

        private EntityClassEnum(String appName, String entityName, String className) {
            this.appName = appName;
            this.entityName = entityName;
            this.className = className;
        }

        public static String getEntityClass(String appName, String entityName) {
            for (EntityClassEnum entityClassEnum : EntityClassEnum.values()) {
                if (!entityClassEnum.getAppName().equals(appName) || !entityClassEnum.getEntityName().equals(entityName)) continue;
                return entityClassEnum.getClassName();
            }
            return null;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getEntityName() {
            return this.entityName;
        }

        public String getClassName() {
            return this.className;
        }
    }
}

