/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Date;

public class EasyExcelInstantDateConverter
implements Converter<Instant> {
    public Class<Instant> supportJavaTypeKey() {
        return Instant.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public Instant convertToJavaData(CellData cellData, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(cellData.getStringValue());
        return date.toInstant();
    }

    public CellData convertToExcelData(Instant instant, ExcelContentProperty excelContentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new CellData(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.of("UTC+8")).format(instant));
    }

    public static void main(String[] args) {
        System.out.println(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss").withZone(ZoneId.of("UTC+8")).format(Instant.now()));
    }
}

