/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GsonUtils {
    private static final Logger log = LoggerFactory.getLogger(GsonUtils.class);
    private static final Gson gson = new GsonBuilder().enableComplexMapKeySerialization().setPrettyPrinting().serializeNulls().setDateFormat("yyyy-MM-dd HH:mm:ss").create();
    private static final Type MAP_TYPE = new TypeToken<Map<String, String>>(){}.getType();

    public static <T> T fromToJson(String json, Type listType) {
        Gson gson = new Gson();
        Object t = null;
        t = gson.fromJson(json, listType);
        return (T)t;
    }

    public static <T> List<T> convertList(String json, TypeToken<List<T>> token) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList();
        }
        return (List)gson.fromJson(json, token.getType());
    }

    public static <T> List<T> convertList(String json, Class<T> cls) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return new ArrayList();
        }
        Type type = new TypeToken<List<JsonObject>>(){}.getType();
        List jsonObjs = (List)gson.fromJson(json, type);
        ArrayList<T> listOfT = new ArrayList<T>();
        for (JsonObject jsonObj : jsonObjs) {
            listOfT.add(GsonUtils.convertObj(jsonObj.toString(), cls));
        }
        return listOfT;
    }

    public static <T> T convertObj(String json, Class<T> cls) {
        if (StringUtils.isBlank((CharSequence)json)) {
            return null;
        }
        return (T)gson.fromJson(json, cls);
    }

    public static <T> T convertObjWithNotNull(String json, Class<T> cls) {
        if (StringUtils.isBlank((CharSequence)json)) {
            try {
                return cls.newInstance();
            }
            catch (ReflectiveOperationException rpe) {
                log.error("convertObjWithNotNull \u521b\u5efa\u7c7b\u5b9e\u4f8b\u65f6\u51fa\u9519 class={}", (Object)cls.getCanonicalName(), (Object)rpe);
                return null;
            }
        }
        return (T)gson.fromJson(json, cls);
    }

    public static String toJson(Object obj) {
        if (obj == null) {
            return "";
        }
        return gson.toJson(obj);
    }

    public static String getJsonObjectAsString(JsonObject jsonObject, String name) {
        if (jsonObject == null || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        JsonElement jsonElement = jsonObject.get(name);
        return jsonElement == null ? null : jsonElement.getAsString();
    }

    public static JsonObject getJsonObjectChild(JsonObject jsonObject, String name) {
        if (jsonObject == null || StringUtils.isBlank((CharSequence)name)) {
            return null;
        }
        JsonElement jsonElement = jsonObject.get(name);
        return jsonElement == null ? null : jsonElement.getAsJsonObject();
    }

    public static boolean getJsonObjectAsBoolean(JsonObject jsonObject, String name) {
        if (jsonObject == null || StringUtils.isBlank((CharSequence)name)) {
            return false;
        }
        JsonElement jsonElement = jsonObject.get(name);
        return jsonElement == null ? false : jsonElement.getAsBoolean();
    }

    public static Map<String, String> toMap(String json) {
        return (Map)gson.fromJson(json, MAP_TYPE);
    }
}

