/*
 * Decompiled with CFR 0.152.
 */
package com.qqt.platform.common.utils;

import com.alibaba.fastjson.JSONObject;
import com.qqt.platform.common.config.AbstractCriteria;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageScanner {
    private static final Logger logger = LoggerFactory.getLogger(PackageScanner.class);
    private String basePackage;
    private ClassLoader cl;

    public PackageScanner(String basePackage) {
        this.basePackage = basePackage;
        this.cl = this.getClass().getClassLoader();
    }

    public PackageScanner(String basePackage, ClassLoader cl) {
        this.basePackage = basePackage;
        this.cl = cl;
    }

    public List<String> getFullyQualifiedClassNameList() {
        logger.info("\u5f00\u59cb\u626b\u63cf\u5305{}\u4e0b\u7684\u6240\u6709\u7c7b", (Object)this.basePackage);
        return this.doScan(this.basePackage, new ArrayList<String>());
    }

    private List<String> doScan(String basePackage, List<String> nameList) {
        String splashPath = PackageScanner.dotToSplash(basePackage);
        URL url = this.cl.getResource(splashPath);
        String filePath = PackageScanner.getRootPath(url);
        List<String> names = null;
        if (this.isJarFile(filePath)) {
            if (logger.isDebugEnabled()) {
                logger.debug("{} \u662f\u4e00\u4e2aJAR\u5305", (Object)filePath);
            }
            names = this.readFromJarFile(filePath, splashPath);
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("{} \u662f\u4e00\u4e2a\u76ee\u5f55", (Object)filePath);
            }
            names = this.readFromDirectory(filePath);
        }
        for (String name : names) {
            if (name.endsWith("_.class")) continue;
            if (this.isClassFile(name)) {
                nameList.add(this.toFullyQualifiedName(name, basePackage));
                continue;
            }
            this.doScan(basePackage + "." + name, nameList);
        }
        return nameList;
    }

    private String toFullyQualifiedName(String shortName, String basePackage) {
        StringBuilder sb = new StringBuilder(basePackage);
        sb.append('.');
        sb.append(PackageScanner.trimExtension(shortName));
        return sb.toString();
    }

    private List<String> readFromJarFile(String jarPath, String splashedPackageName) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4eceJAR\u5305\u4e2d\u8bfb\u53d6\u7c7b: {}", (Object)jarPath);
        }
        ArrayList<String> nameList = new ArrayList<String>();
        JarInputStream jarIn = null;
        try {
            jarIn = new JarInputStream(new FileInputStream(jarPath));
            JarEntry entry = jarIn.getNextJarEntry();
            while (null != entry) {
                String name = entry.getName();
                if (name.startsWith(splashedPackageName) && this.isClassFile(name)) {
                    nameList.add(name);
                }
                entry = jarIn.getNextJarEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return nameList;
    }

    private List<String> readFromDirectory(String path) {
        File file = new File(path);
        String[] names = file.list();
        if (null == names) {
            return null;
        }
        return Arrays.asList(names);
    }

    private boolean isClassFile(String name) {
        return name.endsWith(".class");
    }

    private boolean isJarFile(String name) {
        return name.endsWith(".jar");
    }

    public static String getRootPath(URL url) {
        String fileUrl = url.getFile();
        int pos = fileUrl.indexOf(33);
        if (-1 == pos) {
            return fileUrl;
        }
        return fileUrl.substring(5, pos);
    }

    public static String dotToSplash(String name) {
        return name.replaceAll("\\.", "/");
    }

    public static String trimExtension(String name) {
        int pos = name.indexOf(46);
        if (-1 != pos) {
            return name.substring(0, pos);
        }
        return name;
    }

    public static String trimURI(String uri) {
        String trimmed = uri.substring(1);
        int splashIndex = trimmed.indexOf(47);
        return trimmed.substring(splashIndex);
    }

    public static Optional<String> findClass(String shortName, String basePackage) {
        PackageScanner scan = new PackageScanner(basePackage);
        List<String> names = scan.getFullyQualifiedClassNameList();
        return names.stream().filter(item -> item.toLowerCase().endsWith(shortName.toLowerCase())).findFirst();
    }

    public static void main(String[] args) throws Exception {
        Optional<String> optional = PackageScanner.findClass("cMSContentCriteria", "com.qqt");
        if (optional.isPresent()) {
            String name = optional.get();
            logger.debug("name=>{}", (Object)name);
            Object object = Class.forName(name).newInstance();
            if (object instanceof AbstractCriteria) {
                JSONObject jsonObject = ((AbstractCriteria)object).getFilters();
                logger.debug("filters=>{}", (Object)jsonObject.toString());
            }
        }
    }
}

