/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.enumerate;

import com.els.modules.base.api.dto.ElsEmailConfigDTO;
import java.util.Properties;

public enum MailProtocolType {
    smtp("smtp"),
    pop3("pop3"),
    imap("imap"),
    exchange("exchange");

    private String type;

    public static MailProtocolType buildMailProtocolType(String type) {
        for (MailProtocolType t : MailProtocolType.values()) {
            if (!t.getType().equals(type)) continue;
            return t;
        }
        return null;
    }

    public static Properties buildDefaultProperties(ElsEmailConfigDTO config, boolean needSsl, String sslClass) {
        Properties props = new Properties();
        props.put(String.format("mail.%s.host", config.getType()), config.getEmailHost());
        props.put(String.format("mail.%s.port", config.getType()), config.getEmailPort());
        props.put(String.format("mail.%s.ssl", config.getType()), (Object)needSsl);
        props.put(String.format("mail.%s.auth", config.getType()), (Object)true);
        props.put(String.format("mail.%s.starttls.enable", config.getType()), (Object)false);
        props.put(String.format("mail.%s.user", config.getType()), config.getEmailUsername());
        props.put(String.format("mail.%s.pass", config.getType()), config.getEmailPassword());
        props.put(String.format("mail.%s.socketFactory.fallback", config.getType()), (Object)false);
        if (needSsl) {
            String clazz = null == sslClass || sslClass.trim().equals("") ? "javax.net.ssl.SSLSocketFactory" : sslClass;
            props.put(String.format("mail.%s.socketFactory.class", config.getType()), clazz);
        }
        return props;
    }

    private MailProtocolType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }
}

