/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.sql.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;

public class OracleSqlUtil {
    public static final String DEFAULT_PATTERN_YMD_HMS = "yyyy-MM-dd HH:mm:ss";
    public static final String DEFAULT_PATTERN_YMD_HMS_S = "yyyy-MM-dd HH:mm:ss.s";
    public static final String DEFAULT_YMDHMS = "yyyyMMddHHmmss";
    static String tableHead = "select * from ";
    public static Integer default_size = 10000;

    public static String getAllDataSql(String tableName) {
        return new StringBuffer(tableHead).append(tableName).toString();
    }

    public static String getIncrementDataSql(String tableName, Date time) {
        return new StringBuffer(tableHead).append(tableName).append(" where UPDATE_TIME >= to_date('").append(OracleSqlUtil.getSearchTime(time)).append("','yyyy-mm-dd hh24:mi:ss')").toString();
    }

    public static String getAllDataPageSql(String tableName, Integer pageNo, Integer pageSize) {
        return new StringBuffer(tableHead).append("(select rownum no,a.* from ").append(tableName).append(" a) where no between ").append((pageNo - 1) * pageSize + 1).append("and").append(pageNo * pageSize).toString();
    }

    public static String getIncrementDataPageSql(String tableName, Date time, Integer pageNo, Integer pageSize) {
        return new StringBuffer(tableHead).append("(select rownum no,a.* from ").append(tableName).append(" a where a.UPDATE_DATE >= to_date('").append(OracleSqlUtil.getSearchTime(time)).append("','yyyy-mm-dd hh24:mi:ss')) where no between ").append((pageNo - 1) * pageSize + 1).append("and").append(pageNo * pageSize).toString();
    }

    public static void getPage(String tableName, JSONObject obj, Object custom) {
        JSONObject customJson = (JSONObject)custom;
        Integer pageNo = 1;
        Integer pageSize = default_size;
        if (customJson.containsKey((Object)"pageNo")) {
            pageNo = customJson.getInteger("pageNo");
        }
        if (customJson.containsKey((Object)"pageSize")) {
            pageSize = customJson.getInteger("pageSize");
        }
        customJson.put("pageNo", (Object)pageNo);
        customJson.put("pageSize", (Object)pageSize);
        obj.put("body", (Object)OracleSqlUtil.getAllDataPageSql(tableName, pageNo, pageSize));
        obj.put("business_message", (Object)tableName);
    }

    public static JSONArray handlerResultListInfo(JSONObject obj) {
        Assert.isTrue((obj.getIntValue("code") == 200 ? 1 : 0) != 0, (String)obj.getString("message"), (Object[])new Object[0]);
        JSONObject result = obj.getJSONObject("result");
        Assert.isTrue((result.getIntValue("status") == 200 ? 1 : 0) != 0, (String)result.getString("message"), (Object[])new Object[0]);
        return result.getJSONArray("result");
    }

    public static Date getUpdateTime(String strDate) {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return new Date();
        }
        return OracleSqlUtil.timeStrToDate(strDate, DEFAULT_PATTERN_YMD_HMS_S);
    }

    public static String getSearchTime(Date time) {
        return OracleSqlUtil.dateToStr(time, DEFAULT_PATTERN_YMD_HMS);
    }

    public static Date timeStrToDate(String time, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        return formatter.parse(time, pos);
    }

    public static String dateToStr(Date date, String pattern) {
        SimpleDateFormat formatter = new SimpleDateFormat(pattern);
        ParsePosition pos = new ParsePosition(0);
        return formatter.format(date);
    }

    public static void main(String[] args) {
        String str = "2017-11-23T22:28:01.45";
        String dateStr = "yyyy-MM-dd'T'HH:mm:ss";
        System.out.println(OracleSqlUtil.timeStrToDate(str, dateStr));
        System.out.println(IdWorker.getIdStr());
        System.out.println(IdWorker.getIdStr());
    }
}

