/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.account.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.api.service.InterfaceConverter;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.util.RedisUtil;
import com.els.modules.enterprise.entity.ElsEnterpriseInfo;
import com.els.modules.enterprise.service.ElsEnterpriseInfoService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

@RpcService(value="elsAccountToEnterpriseNameConverter")
public class ElsAccountToEnterpriseNameConverter
implements InterfaceConverter {
    private static final Logger log = LoggerFactory.getLogger(ElsAccountToEnterpriseNameConverter.class);
    private static final String REDIS_PREFIX = "srm:elsAccountToEnterpriseNameConvertor_";
    @Autowired
    private RedisUtil redisUtil;
    @Lazy
    @Resource
    private ElsEnterpriseInfoService elsEnterpriseInfoService;

    public Object convertData(Object data, Object obj, String ... args) {
        String elsAccount = (String)data;
        if (StrUtil.isNotBlank((CharSequence)elsAccount)) {
            ElsEnterpriseInfo elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)this.redisUtil.get(REDIS_PREFIX + elsAccount));
            if (elsEnterpriseInfo == null && (elsEnterpriseInfo = (ElsEnterpriseInfo)((Object)((LambdaQueryChainWrapper)this.elsEnterpriseInfoService.lambdaQuery().select(new SFunction[]{ElsEnterpriseInfo::getElsAccount, ElsEnterpriseInfo::getName}).eq(ElsEnterpriseInfo::getElsAccount, (Object)elsAccount)).one())) != null) {
                this.redisUtil.set(REDIS_PREFIX + elsAccount, (Object)elsEnterpriseInfo, 300L);
            }
            if (elsEnterpriseInfo != null) {
                return elsEnterpriseInfo.getName();
            }
        }
        return elsAccount;
    }
}

