/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.history.rocketMq.listener;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.history.entity.ElsInitialTable;
import com.els.modules.history.service.ElsInitialTableService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.stereotype.Component;

@Component
public class InitTableConsumer {
    private static final Logger log = LoggerFactory.getLogger(InitTableConsumer.class);
    @Autowired
    private ElsInitialTableService elsInitialTableService;

    @Bean(value={"inputInit"})
    public Consumer<String> receive() {
        return msgBody -> {
            try {
                if (StrUtil.isBlank((CharSequence)msgBody)) {
                    return;
                }
                JSONObject body = JSONObject.parseObject((String)msgBody);
                ElsInitialTable table = (ElsInitialTable)((Object)((Object)JSONObject.toJavaObject((JSON)body, ElsInitialTable.class)));
                if (StrUtil.isNotBlank((CharSequence)table.getRelationId()) && StrUtil.isNotBlank((CharSequence)table.getBusinessInfoJson())) {
                    log.info("msgBody: " + msgBody);
                    this.elsInitialTableService.saveElsInitialTable(table);
                }
            }
            catch (Exception e) {
                log.error("InitTableConsumer_receive_msgBody:" + msgBody, (Throwable)e);
                throw e;
            }
        };
    }
}

