/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.finance.service.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.config.mybatis.TenantContext;
import com.els.modules.finance.entity.ElsFinanceReconciliationConfig;
import com.els.modules.finance.enumerate.ConfigStatusEnum;
import com.els.modules.finance.mapper.ElsFinanceReconciliationConfigMapper;
import com.els.modules.finance.service.ElsFinanceReconciliationConfigService;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ElsFinanceReconciliationConfigServiceImpl
extends BaseServiceImpl<ElsFinanceReconciliationConfigMapper, ElsFinanceReconciliationConfig>
implements ElsFinanceReconciliationConfigService {
    private static final Logger log = LoggerFactory.getLogger(ElsFinanceReconciliationConfigServiceImpl.class);
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Override
    public void add(ElsFinanceReconciliationConfig elsFinanceReconciliationConfig) {
        String nextCode = this.invokeBaseRpcService.getNextCode("srmReconciliationConfigNumber", (Object)elsFinanceReconciliationConfig);
        elsFinanceReconciliationConfig.setRuleNumber(nextCode);
        elsFinanceReconciliationConfig.setStatus(ConfigStatusEnum.NORMAL.getValue());
        ((ElsFinanceReconciliationConfigMapper)this.baseMapper).insert((Object)elsFinanceReconciliationConfig);
    }

    @Override
    public void edit(ElsFinanceReconciliationConfig elsFinanceReconciliationConfig) {
        ((ElsFinanceReconciliationConfigMapper)this.baseMapper).updateById((Object)elsFinanceReconciliationConfig);
    }

    @Override
    public void delete(String id) {
        ((ElsFinanceReconciliationConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsFinanceReconciliationConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsFinanceReconciliationConfig getDefaultReconciliationConfig(String currentELSAccount, String businessType) {
        log.info("ElsFinanceReconciliationConfig : {} , {}", (Object)currentELSAccount, (Object)businessType);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(BaseEntity::getElsAccount, (Object)currentELSAccount);
        queryWrapper.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
        queryWrapper.eq(ElsFinanceReconciliationConfig::getStatus, (Object)"1");
        queryWrapper.eq(ElsFinanceReconciliationConfig::getBusinessType, (Object)businessType);
        ElsFinanceReconciliationConfig config = (ElsFinanceReconciliationConfig)((Object)((ElsFinanceReconciliationConfigMapper)this.baseMapper).selectOne((Wrapper)queryWrapper));
        log.info("ElsFinanceReconciliationConfig  currentELSAccount : {} ,result: {}", (Object)JSON.toJSONString((Object)queryWrapper), (Object)JSON.toJSONString((Object)((Object)config)));
        if (ObjectUtils.isEmpty((Object)((Object)config))) {
            LambdaQueryWrapper defaultQueryWrapper = new LambdaQueryWrapper();
            defaultQueryWrapper.eq(BaseEntity::getElsAccount, (Object)"100000");
            defaultQueryWrapper.eq(BaseEntity::getDeleted, (Object)CommonConstant.DEL_FLAG_0);
            defaultQueryWrapper.eq(ElsFinanceReconciliationConfig::getStatus, (Object)"1");
            defaultQueryWrapper.eq(ElsFinanceReconciliationConfig::getBusinessType, (Object)businessType);
            ElsFinanceReconciliationConfig defaultConfig = (ElsFinanceReconciliationConfig)((Object)((ElsFinanceReconciliationConfigMapper)this.baseMapper).selectOne((Wrapper)defaultQueryWrapper));
            log.info("ElsFinanceReconciliationConfig  ELSAccount : {} ,result: {}", (Object)JSON.toJSONString((Object)defaultQueryWrapper), (Object)JSON.toJSONString((Object)((Object)defaultConfig)));
            return defaultConfig;
        }
        return config;
    }

    @Override
    public void addBy100000(String id, String businessType) {
        ElsFinanceReconciliationConfig config = (ElsFinanceReconciliationConfig)((Object)((ElsFinanceReconciliationConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        ElsFinanceReconciliationConfig reconciliationConfig = new ElsFinanceReconciliationConfig();
        BeanUtils.copyProperties((Object)((Object)config), (Object)((Object)reconciliationConfig));
        reconciliationConfig.setBusinessType(businessType);
        reconciliationConfig.setElsAccount(TenantContext.getTenant());
        reconciliationConfig.setId(null);
        reconciliationConfig.setCreateBy(null);
        reconciliationConfig.setCreateTime(null);
        reconciliationConfig.setUpdateBy(null);
        reconciliationConfig.setUpdateTime(null);
        ((ElsFinanceReconciliationConfigMapper)this.baseMapper).insert((Object)reconciliationConfig);
    }
}

