/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.interfaceConversion.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.interfaceConversion.entity.ElsInterfaceConvertConfig;
import com.els.modules.interfaceConversion.entity.ElsInterfaceParam;
import com.els.modules.interfaceConversion.service.CommonInterfaceService;
import com.els.modules.interfaceConversion.service.ElsInterfaceConvertConfigService;
import com.els.modules.interfaceConversion.service.ElsInterfaceParamService;
import java.util.Calendar;
import java.util.Date;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CommonInterfaceServiceImpl
implements CommonInterfaceService {
    private static final Logger log = LoggerFactory.getLogger(CommonInterfaceServiceImpl.class);
    @Resource
    private InterfaceUtil interfaceUtil;
    @Resource
    private ElsInterfaceParamService interfaceParamService;
    @Resource
    private ElsInterfaceConvertConfigService convertConfigService;
    @Resource
    private RedisUtil redisUtil;
    private final Long LOCK_TIME_OUT = 1800000L;
    private final Long LOCK_WAIT_TIME = 1L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void pullData(String interfaceCode, JSONObject param) {
        String elsAccount = TenantContext.getTenant();
        String redisKey = "INTERFACE_EXECUTE_" + elsAccount + "_" + interfaceCode;
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date today = calendar.getTime();
        ElsInterfaceParam interfaceParam = this.interfaceParamService.getInterfaceParam(elsAccount, interfaceCode);
        if (interfaceParam == null) {
            interfaceParam = new ElsInterfaceParam();
            interfaceParam.setInterfaceCode(interfaceCode);
            interfaceParam.setElsAccount(elsAccount);
        }
        if (interfaceParam.getStartTime() == null) {
            interfaceParam.setStartTime(today);
        }
        if (interfaceParam.getPageNo() == null) {
            interfaceParam.setPageNo(1);
        }
        if (interfaceParam.getPageSize() == null) {
            interfaceParam.setPageSize(100);
        }
        if (interfaceParam.getIgnoreLock() == null) {
            interfaceParam.setIgnoreLock(false);
        }
        if (StrUtil.isBlank((CharSequence)interfaceParam.getFieldKeys())) {
            interfaceParam.setFieldKeys("FNumber");
        }
        interfaceParam.setParam(param);
        if (interfaceParam.getIgnoreLock().booleanValue() || this.redisUtil.tryLockWithTimeout(redisKey, interfaceCode, this.LOCK_TIME_OUT.longValue(), this.LOCK_WAIT_TIME.longValue())) {
            try {
                log.warn("\u83b7\u53d6\u9501");
                if (interfaceParam.getStartTimeOffset() != null && interfaceParam.getStartTimeOffset() > 0) {
                    DateTime startTime = DateUtil.offsetMinute((Date)interfaceParam.getStartTime(), (int)(-Math.abs(interfaceParam.getStartTimeOffset())));
                    interfaceParam.setStartTime((Date)startTime);
                }
                do {
                    this.interfaceUtil.callInterface(elsAccount, interfaceCode, (Object)interfaceParam);
                    interfaceParam.setPageNo(interfaceParam.getPageNo() + 1);
                    if (interfaceParam.isQueryByNumber()) continue;
                    this.interfaceParamService.saveOrUpdate((Object)interfaceParam);
                } while (interfaceParam.isHasMore());
                if (interfaceParam.isQueryByNumber()) return;
                interfaceParam.setPageNo(1);
                interfaceParam.setStartTime(now);
                interfaceParam.setIgnoreLock(false);
                this.interfaceParamService.saveOrUpdate((Object)interfaceParam);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ELSBootException((Throwable)e);
            }
            finally {
                log.warn("\u91ca\u653e\u9501");
                this.redisUtil.releaseDistributedLock(redisKey, interfaceCode);
            }
        } else {
            log.warn("\u83b7\u53d6\u9501\u8d85\u65f6");
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_ryViKRcsVRSKK_372f612d", (String)"\u8be5\u63a5\u53e3\u6b63\u5728\u6267\u884c\u4e2d\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01"));
        }
    }

    @Override
    public JSONObject getQueryParam(JSONObject obj) {
        ElsInterfaceParam interfaceParam = this.interfaceParamService.getInterfaceParam(TenantContext.getTenant(), obj.getString("srm_interface_code"));
        ElsInterfaceConvertConfig convertConfig = this.convertConfigService.getInterfaceConvertConfig(TenantContext.getTenant(), interfaceParam.getConvertConfig());
        JSONObject result = new JSONObject();
        result.put("convertElsAccount", (Object)interfaceParam.getElsAccount());
        result.put("elsAccount", (Object)TenantContext.getTenant());
        result.put("interfaceParam", (Object)interfaceParam);
        result.put("convertConfig", (Object)convertConfig);
        return result;
    }

    public static void main(String[] args) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        Date today = calendar.getTime();
        System.out.println(DateUtil.format((Date)today, (String)"yyyy-MM-dd HH:mm:ss"));
    }
}

