/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.DateUtils;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsPrintConfig;
import com.els.modules.system.mapper.ElsPrintConfigMapper;
import com.els.modules.system.rocketMq.util.InitPrintDataMqUtil;
import com.els.modules.system.service.ElsPrintConfigService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class ElsPrintConfigServiceImpl
extends BaseServiceImpl<ElsPrintConfigMapper, ElsPrintConfig>
implements ElsPrintConfigService {
    private static final Logger log = LoggerFactory.getLogger(ElsPrintConfigServiceImpl.class);

    @Override
    public void add(ElsPrintConfig elsPrintConfig) {
        if (StrUtil.isNotBlank((CharSequence)elsPrintConfig.getElsAccount())) {
            elsPrintConfig.setElsAccount(TenantContext.getTenant());
        }
        elsPrintConfig.setStatus("1");
        ((ElsPrintConfigMapper)this.baseMapper).insert((Object)elsPrintConfig);
    }

    @Override
    public void edit(ElsPrintConfig elsPrintConfig) {
        int count = ((ElsPrintConfigMapper)this.baseMapper).updateById((Object)elsPrintConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((ElsPrintConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((ElsPrintConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public ElsPrintConfig getElsPrintConfigByBusType(String elsAccount, String busType) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(ElsPrintConfig::getBusinessType, (Object)busType);
        queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
        queryWrapper.lambda().eq(ElsPrintConfig::getStatus, (Object)"1");
        List list = this.list((Wrapper)queryWrapper);
        if (CollectionUtil.isEmpty((Collection)list)) {
            queryWrapper.clear();
            queryWrapper.lambda().eq(ElsPrintConfig::getBusinessType, (Object)busType);
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)"100000");
            queryWrapper.lambda().eq(ElsPrintConfig::getStatus, (Object)"1");
            List superList = this.list((Wrapper)queryWrapper);
            if (CollectionUtil.isNotEmpty((Collection)superList)) {
                return (ElsPrintConfig)((Object)superList.get(0));
            }
        } else {
            return (ElsPrintConfig)((Object)list.get(0));
        }
        return null;
    }

    @Override
    public void addBy100000(String id) {
        JSONObject jsonObject = new JSONObject();
        ElsPrintConfig elsPrintConfig = (ElsPrintConfig)((Object)((ElsPrintConfigMapper)this.baseMapper).selectById((Serializable)((Object)id)));
        ElsPrintConfig elsPrintConfigAccount = new ElsPrintConfig();
        BeanUtils.copyProperties((Object)((Object)elsPrintConfig), (Object)((Object)elsPrintConfigAccount));
        elsPrintConfigAccount.setElsAccount(TenantContext.getTenant());
        elsPrintConfigAccount.setId(null);
        elsPrintConfigAccount.setCreateBy(null);
        elsPrintConfigAccount.setCreateTime(null);
        elsPrintConfigAccount.setUpdateBy(null);
        elsPrintConfigAccount.setUpdateTime(null);
        if ("ureport".equals(elsPrintConfigAccount.getPrintType())) {
            jsonObject.put("printType", (Object)"ureport");
            elsPrintConfigAccount.setPrintName(DateUtils.getMillis((Date)new Date()) + "_" + elsPrintConfigAccount.getPrintName());
            jsonObject.put("ureportName", Arrays.asList(elsPrintConfigAccount.getPrintName()));
        } else if ("jimu".equals(elsPrintConfigAccount.getPrintType())) {
            jsonObject.put("printType", (Object)"jimu");
            jsonObject.put("reportId", Arrays.asList(elsPrintConfigAccount.getPrintId()));
        }
        ((ElsPrintConfigMapper)this.baseMapper).insert((Object)elsPrintConfigAccount);
        jsonObject.put("elsAccount", Arrays.asList(TenantContext.getTenant()));
        jsonObject.put("shareType", (Object)"print");
        InitPrintDataMqUtil.sendInitMsg(jsonObject.toJSONString());
        log.info("\u53d1\u9001print\u6d88\u606f,\u6d88\u606f\u5185\u5bb9:" + jsonObject.toJSONString());
    }
}

