/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.survey.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.survey.entity.PurchaseSurveyAnswerLibrary;
import com.els.modules.survey.entity.PurchaseSurveyHead;
import com.els.modules.survey.entity.PurchaseSurveyItem;
import com.els.modules.survey.service.PurchaseSurveyAnswerLibraryService;
import com.els.modules.survey.service.PurchaseSurveyHeadService;
import com.els.modules.survey.service.PurchaseSurveyItemService;
import com.els.modules.survey.vo.PurchaseSurveyItemVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/survey/purchaseSurveyItem"})
@Api(tags={"\u95ee\u5377\u7b54\u5377\u5934"})
public class PurchaseSurveyItemController
extends BaseController<PurchaseSurveyItem, PurchaseSurveyItemService> {
    private static final Logger log = LoggerFactory.getLogger(PurchaseSurveyItemController.class);
    @Autowired
    private PurchaseSurveyHeadService purchaseSurveyHeadService;
    @Autowired
    private PurchaseSurveyItemService purchaseSurveyItemService;
    @Autowired
    private PurchaseSurveyAnswerLibraryService purchaseSurveyAnswerLibraryService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"survey#purchaseSurveyItem:list"})
    public Result<?> queryPageList(PurchaseSurveyItem purchaseSurveyItem, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseSurveyItem), (Map)req.getParameterMap());
        LoginUserDTO loginUser = SysUtil.getLoginUser();
        queryWrapper.lambda().eq(PurchaseSurveyItem::getAnswerAccount, (Object)loginUser.getElsAccount());
        queryWrapper.lambda().eq(PurchaseSurveyItem::getAnswerSubAccount, (Object)loginUser.getSubAccount());
        if (StrUtil.isNotBlank((CharSequence)purchaseSurveyItem.getKeyWord())) {
            queryWrapper.like((Object)"survey_name", (Object)purchaseSurveyItem.getKeyWord());
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<PurchaseSurveyItem> pageList = this.purchaseSurveyItemService.pageList((Page<PurchaseSurveyItem>)page, (QueryWrapper<PurchaseSurveyItem>)queryWrapper);
        return Result.ok(pageList);
    }

    @SrmValidated
    @AutoLog(busModule="\u95ee\u5377\u7b54\u5377\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"survey#purchaseSurveyItem:add"})
    public Result<?> add(@RequestBody PurchaseSurveyItemVO purchaseSurveyItemPage) {
        PurchaseSurveyItem purchaseSurveyItem = new PurchaseSurveyItem();
        BeanUtils.copyProperties((Object)((Object)purchaseSurveyItemPage), (Object)((Object)purchaseSurveyItem));
        this.purchaseSurveyItemService.saveMain(purchaseSurveyItem, purchaseSurveyItemPage.getPurchaseSurveyAnswerLibraryList());
        return Result.ok((Object)((Object)purchaseSurveyItem));
    }

    @SrmValidated
    @AutoLog(busModule="\u95ee\u5377\u7b54\u5377\u5934", value="\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"survey#purchaseSurveyItem:edit"})
    public Result<?> edit(@RequestBody PurchaseSurveyItemVO purchaseSurveyItemPage) {
        PurchaseSurveyItem purchaseSurveyItem = new PurchaseSurveyItem();
        BeanUtils.copyProperties((Object)((Object)purchaseSurveyItemPage), (Object)((Object)purchaseSurveyItem));
        this.purchaseSurveyItemService.updateMain(purchaseSurveyItem, purchaseSurveyItemPage.getPurchaseSurveyAnswerLibraryList());
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u63d0\u4ea4\u95ee\u5377", value="\u63d0\u4ea4\u95ee\u5377")
    @ApiOperation(value="\u63d0\u4ea4\u95ee\u5377", notes="\u63d0\u4ea4\u95ee\u5377")
    @PostMapping(value={"/submitSys"})
    @RequiresPermissions(value={"survey#purchaseSurveyItem:submitSys"})
    public Result<?> submitSys(@RequestBody PurchaseSurveyItemVO purchaseSurveyItemPage) {
        this.purchaseSurveyItemService.submitSys(purchaseSurveyItemPage);
        return this.commonSuccessResult(3);
    }

    @SrmValidated
    @AutoLog(busModule="\u63d0\u4ea4\u95ee\u5377", value="\u63d0\u4ea4\u95ee\u5377")
    @ApiOperation(value="\u63d0\u4ea4\u95ee\u5377", notes="\u63d0\u4ea4\u95ee\u5377")
    @PostMapping(value={"/noToken/submitOther"})
    public Result<?> submitOther(@RequestBody PurchaseSurveyItemVO purchaseSurveyItemPage) {
        this.purchaseSurveyItemService.submitOther(purchaseSurveyItemPage);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u95ee\u5377\u7b54\u5377\u5934", value="\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"survey#purchaseSurveyItem:delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.purchaseSurveyItemService.delMain(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u95ee\u5377\u7b54\u5377\u5934", value="\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"survey#purchaseSurveyItem:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.purchaseSurveyItemService.delBatchMain(Arrays.asList(ids.split(",")));
        return this.commonSuccessResult(4);
    }

    @AutoLog(busModule="\u95ee\u5377\u7b54\u5377\u5934", value="\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"survey#purchaseSurveyItem:view"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id, @RequestParam(name="elsAccount", required=false) String elsAccount) {
        String elsAccountStr = StrUtil.isBlank((CharSequence)elsAccount) ? TenantContext.getTenant() : elsAccount;
        PurchaseSurveyItem purchaseSurveyItem = (PurchaseSurveyItem)((Object)this.purchaseSurveyItemService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)elsAccountStr)));
        PurchaseSurveyHead byId = (PurchaseSurveyHead)((Object)this.purchaseSurveyHeadService.getById((Serializable)((Object)purchaseSurveyItem.getHeadId())));
        if (byId != null) {
            purchaseSurveyItem.setSurveyName(byId.getSurveyName());
            purchaseSurveyItem.setSurveyDesc(byId.getSurveyDesc());
            purchaseSurveyItem.setSurveyType(byId.getSurveyType());
        }
        PurchaseSurveyItemVO purchaseSurveyItemVO = new PurchaseSurveyItemVO();
        BeanUtils.copyProperties((Object)((Object)purchaseSurveyItem), (Object)((Object)purchaseSurveyItemVO));
        List<PurchaseSurveyAnswerLibrary> purchaseSurveyAnswerLibraryList = this.purchaseSurveyAnswerLibraryService.selectByMainId(id);
        purchaseSurveyItemVO.setPurchaseSurveyAnswerLibraryList(purchaseSurveyAnswerLibraryList);
        return Result.ok((Object)((Object)purchaseSurveyItemVO));
    }

    @ApiOperation(value="\u901a\u8fc7\u95ee\u5377\u7b54\u5377\u5934id\u67e5\u8be2\u95ee\u5377\u7b54\u5377\u884c", notes="\u901a\u8fc7\u95ee\u5377\u7b54\u5377\u5934id\u67e5\u8be2\u95ee\u5377\u7b54\u5377\u884c")
    @GetMapping(value={"/queryPurchaseSurveyAnswerLibraryByMainId"})
    @RequiresPermissions(value={"survey#purchaseSurveyItem:view"})
    public Result<?> queryPurchaseSurveyAnswerLibraryListByMainId(@RequestParam(name="id", required=true) String id) {
        List<PurchaseSurveyAnswerLibrary> purchaseSurveyAnswerLibraryList = this.purchaseSurveyAnswerLibraryService.selectByMainId(id);
        return Result.ok(purchaseSurveyAnswerLibraryList);
    }
}

