/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.barcode.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.barcode.entity.BarcodeSupplierList;
import com.els.modules.barcode.entity.ElsBarcodeRuleHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoDetail;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoHead;
import com.els.modules.barcode.entity.PurchaseBarcodeInfoItem;
import com.els.modules.barcode.enumerate.BarcodeResolveTypeEnum;
import com.els.modules.barcode.enumerate.PurchaseBarcodeInfoStatusEnum;
import com.els.modules.barcode.mapper.ElsBarcodeRuleHeadMapper;
import com.els.modules.barcode.service.BarcodeSupplierListService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoDetailService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoHeadService;
import com.els.modules.barcode.service.PurchaseBarcodeInfoItemService;
import com.els.modules.barcode.service.PurchaseBarcodePoolHeadService;
import com.els.modules.barcode.service.SaleBarcodeInfoHeadService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseBarcodeInfoRpcAdapter")
public class PurchaseBarcodeInfoAdapter
implements WorkflowAuditOptCallBackService {
    @Autowired
    private PurchaseBarcodeInfoHeadService purchaseBarcodeInfoHeadService;
    @Autowired
    private PurchaseBarcodeInfoItemService purchaseBarcodeInfoItemService;
    @Autowired
    private PurchaseBarcodeInfoDetailService purchaseBarcodeInfoDetailService;
    @Autowired
    private BarcodeSupplierListService barcodeSupplierListService;
    @Autowired
    private SaleBarcodeInfoHeadService saleBarcodeInfoHeadService;
    @Autowired
    private ElsBarcodeRuleHeadMapper elsBarcodeRuleHeadMapper;
    @Autowired
    private PurchaseBarcodePoolHeadService purchaseBarcodePoolHeadService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = (PurchaseBarcodeInfoHead)((Object)this.purchaseBarcodeInfoHeadService.getById((Serializable)((Object)flowCallbackDTO.getBusinessId())));
        purchaseBarcodeInfoHead.setId(flowCallbackDTO.getBusinessId());
        purchaseBarcodeInfoHead.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        purchaseBarcodeInfoHead.setInfoStatus(PurchaseBarcodeInfoStatusEnum.PUBLISH.getValue());
        this.purchaseBarcodeInfoHeadService.updateById((Object)purchaseBarcodeInfoHead);
        List<PurchaseBarcodeInfoItem> purchaseBarcodeInfoItemList = this.purchaseBarcodeInfoItemService.selectByMainId(flowCallbackDTO.getBusinessId());
        List<PurchaseBarcodeInfoDetail> purchaseBarcodeInfoDetailList = this.purchaseBarcodeInfoDetailService.selectByMainId(flowCallbackDTO.getBusinessId());
        List<PurchaseBarcodeInfoDetail> sysBarcodeList = purchaseBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 1).collect(Collectors.toList());
        List<PurchaseBarcodeInfoDetail> customBarcodeList = purchaseBarcodeInfoDetailList.stream().filter(detail -> detail.getBarcodeType() == 2).collect(Collectors.toList());
        List<BarcodeSupplierList> barcodeSupplierListList = this.barcodeSupplierListService.selectByMainId(flowCallbackDTO.getBusinessId());
        ElsBarcodeRuleHead ruleHead = (ElsBarcodeRuleHead)((Object)this.elsBarcodeRuleHeadMapper.selectById((Serializable)((Object)purchaseBarcodeInfoHead.getRuleId())));
        if (BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType())) {
            this.purchaseBarcodePoolHeadService.addByBarcodeInfo(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList);
        }
        this.saleBarcodeInfoHeadService.addByPurchase(purchaseBarcodeInfoHead, purchaseBarcodeInfoItemList, sysBarcodeList, customBarcodeList, barcodeSupplierListList, BarcodeResolveTypeEnum.BARCODE_POOL.getValue().equals(ruleHead.getResolveType()));
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String businessId) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfoHead = (PurchaseBarcodeInfoHead)((Object)this.purchaseBarcodeInfoHeadService.getById((Serializable)((Object)businessId)));
        return SrmUtil.toJSONObject((Object)((Object)purchaseBarcodeInfoHead));
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseBarcodeInfoHead purchaseBarcodeInfohead = new PurchaseBarcodeInfoHead();
        purchaseBarcodeInfohead.setId(flowCallbackDTO.getBusinessId());
        purchaseBarcodeInfohead.setAuditStatus(auditStatus);
        purchaseBarcodeInfohead.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseBarcodeInfoHeadService.updateById((Object)purchaseBarcodeInfohead);
    }
}

