/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bi.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.exception.ELSRepeatLoginException;
import com.els.common.system.util.JwtUtil;
import com.els.common.util.AdminFlagUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.LoginUserContext;
import com.els.common.util.RedisKeyUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SrmRpcUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.LoginUserDTO;
import com.els.modules.account.api.service.AccountInfoRpcService;
import com.els.modules.bi.service.BiInvokeService;
import com.els.modules.system.vo.pojo.BiUser;
import java.util.Collection;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="biInvokeService_tokenCheck")
public class BiInvokeTokenCheckServiceImpl
implements BiInvokeService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BiInvokeTokenCheckServiceImpl.class);

    @Override
    public Object invoke(JSONObject object) {
        String srmToken = object.getString("srmToken");
        if (CharSequenceUtil.isEmpty((CharSequence)srmToken)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"token\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        LoginUserDTO loginUser = this.checkUserTokenIsEffect(srmToken);
        BiUser biUser = new BiUser();
        biUser.setId(loginUser.getId());
        biUser.setElsAccount(loginUser.getElsAccount());
        biUser.setSubAccount(loginUser.getSubAccount());
        biUser.setName(loginUser.getRealname());
        biUser.setDisplayName(loginUser.getElsAccount() + "_" + loginUser.getSubAccount() + "_" + loginUser.getRealname());
        biUser.setIsAdmin(AdminFlagUtil.getAdminFlag());
        String newToken = JwtUtil.sign((String)loginUser.getElsAccount(), (String)loginUser.getSubAccount(), (String)loginUser.getPassword());
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        redisUtil.set("sys:token:" + newToken, (Object)newToken);
        redisUtil.expire("sys:token:" + newToken, 1200L * (long)SysUtil.getExpireTimeBase() / 1000L);
        biUser.setSrmToken(newToken);
        return biUser;
    }

    public LoginUserDTO checkUserTokenIsEffect(String token) {
        String adminFlag;
        JSONObject accountObj = JwtUtil.getAccountObj((String)token);
        if (accountObj == null || !accountObj.containsKey((Object)"elsAccount")) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"token\u975e\u6cd5\u65e0\u6548!"));
        }
        String elsAccount = accountObj.getString("elsAccount");
        String subAccount = accountObj.getString("subAccount");
        AccountInfoRpcService accountInfoRpcService = (AccountInfoRpcService)SrmRpcUtil.getExecuteServiceImpl(AccountInfoRpcService.class);
        LoginUserDTO loginUser = accountInfoRpcService.getLoginUserByAccount(elsAccount, subAccount);
        if (loginUser == null) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u7528\u6237\u4e0d\u5b58\u5728!"));
        }
        if (loginUser.getStatus() == null || loginUser.getStatus() != 1) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u8d26\u53f7\u5df2\u88ab\u51bb\u7ed3,\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458!"));
        }
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        if (!this.jwtTokenRefresh(token, elsAccount, subAccount, loginUser.getPassword(), loginUser, redisUtil)) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"Token\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55!"));
        }
        LoginUserContext.setUser((LoginUserDTO)loginUser);
        TenantContext.setTenant((String)elsAccount);
        String adminFlagRedisKey = RedisKeyUtil.getAdminFlagRedisKey((String)elsAccount, (String)subAccount);
        if (redisUtil.hasKey(adminFlagRedisKey)) {
            adminFlag = (String)redisUtil.get(adminFlagRedisKey);
        } else {
            adminFlag = accountInfoRpcService.getAdminFlagByAccountId(loginUser.getId());
            redisUtil.set(adminFlagRedisKey, (Object)adminFlag);
        }
        AdminFlagUtil.setAdminFlag((String)adminFlag);
        return loginUser;
    }

    private boolean jwtTokenRefresh(String token, String elsAccount, String subAccount, String passWord, LoginUserDTO loginUser, RedisUtil redisUtil) {
        String tokenRedisKey = JwtUtil.getTokenRedisKey((String)elsAccount, (String)subAccount, (String)token);
        if (redisUtil.hasKey(tokenRedisKey)) {
            String cacheToken = (String)redisUtil.get(tokenRedisKey);
            if (!JwtUtil.verify((String)cacheToken, (String)elsAccount, (String)subAccount, (String)passWord)) {
                String newToken = JwtUtil.sign((String)elsAccount, (String)subAccount, (String)passWord);
                redisUtil.set(tokenRedisKey, (Object)newToken, (long)JwtUtil.expireTime());
                log.info("\u2014\u2014\u2014NoToken\u573a\u666f\uff1a\u7528\u6237\u5728\u7ebf\u64cd\u4f5c\uff0c\u66f4\u65b0token\u4fdd\u8bc1\u4e0d\u6389\u7ebf\u2014\u2014\u2014\u2014\u2014\u2014\u2014 " + token);
            }
            return true;
        }
        Set keys = redisUtil.getKeys(JwtUtil.getTokenRedisKeyPrefix((String)elsAccount, (String)subAccount) + "*");
        if (CollectionUtil.isNotEmpty((Collection)keys)) {
            throw new ELSRepeatLoginException("\u8be5\u8d26\u53f7\u5df2\u5728\u5176\u4ed6\u5730\u65b9\u767b\u9646\uff0c\u5982\u975e\u672c\u4eba\u64cd\u4f5c\uff0c\u8bf7\u4fee\u6539\u5bc6\u7801\uff01");
        }
        return false;
    }
}

