/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.redisManager.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.redisManager.entity.RedisTree;
import com.els.modules.redisManager.entity.RedisValue;
import com.els.modules.redisManager.service.RedisManagerService;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Service;

@Service
public class RedisManagerServiceImpl
implements RedisManagerService {
    @Resource
    private RedisUtil redisUtil;

    @Override
    public List<RedisTree> getRedisTree(String redisKey) {
        Object pattern = StrUtil.isBlank((CharSequence)redisKey) ? "*" : redisKey + "*";
        Set keySet = this.redisUtil.scan((String)pattern);
        HashMap<Object, Boolean> containsMap = new HashMap<Object, Boolean>();
        ArrayList<RedisTree> resultList = new ArrayList<RedisTree>();
        if (StrUtil.isBlank((CharSequence)redisKey)) {
            for (String key : keySet) {
                String level_1_directory = key.contains(":") ? key.substring(0, key.indexOf(":") + 1) : key;
                if (containsMap.containsKey(level_1_directory)) continue;
                resultList.add(new RedisTree(level_1_directory.endsWith(":"), level_1_directory, level_1_directory));
                containsMap.put(level_1_directory, true);
            }
        } else {
            for (String key : keySet) {
                String sonKeySuffix;
                String sonText;
                String sonKey;
                if (!key.startsWith(redisKey) || containsMap.containsKey(sonKey = redisKey + (sonText = (sonKeySuffix = key.substring(redisKey.length())).contains(":") ? sonKeySuffix.substring(0, sonKeySuffix.indexOf(":") + 1) : sonKeySuffix))) continue;
                resultList.add(new RedisTree(sonKey.endsWith(":"), sonKey, sonText));
                containsMap.put(sonKey, true);
            }
        }
        return resultList;
    }

    @Override
    public RedisValue getValue(String redisKey) {
        RedisValue result = new RedisValue();
        result.setExpirationTime(this.redisUtil.getExpire(redisKey));
        result.setValue(this.redisUtil.get(redisKey));
        return result;
    }

    @Override
    public void deleteKey(String redisKey) {
        if (redisKey.endsWith(":")) {
            this.redisUtil.dels(redisKey);
        } else {
            this.redisUtil.del(new String[]{redisKey});
        }
    }
}

