/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.base.api.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.SysUtil;
import com.els.modules.attachment.entity.PurchaseAttachment;
import com.els.modules.attachment.service.PurchaseAttachmentService;
import com.els.modules.attachment.vo.AttachmentSendVO;
import com.els.modules.base.api.dto.AttachmentSendDTO;
import com.els.modules.base.api.dto.PurchaseAttachmentDTO;
import com.els.modules.base.api.service.PurchaseAttachmentRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeanUtils;

@RpcService
public class PurchaseAttachmentBeanServiceImpl
implements PurchaseAttachmentRpcService {
    @Resource
    private PurchaseAttachmentService purchaseAttachmentService;

    public List<PurchaseAttachmentDTO> selectByMainId(String id) {
        List<PurchaseAttachment> attachmentList = this.purchaseAttachmentService.selectByMainId(id);
        return SysUtil.copyProperties(attachmentList, PurchaseAttachmentDTO.class);
    }

    public List<PurchaseAttachmentDTO> listPurchaseFiles(List<String> ids) {
        List list = ((LambdaQueryChainWrapper)this.purchaseAttachmentService.lambdaQuery().in(ParentEntity::getId, ids)).list();
        return SysUtil.copyProperties((List)list, PurchaseAttachmentDTO.class);
    }

    public String getSignature(String saveType, String filePath, String tempContextUrl) {
        return this.purchaseAttachmentService.getSignature(saveType, filePath, tempContextUrl);
    }

    public void insertBatchSomeColumn(List<PurchaseAttachmentDTO> attachmentDTOList) {
        if (CollectionUtil.isEmpty(attachmentDTOList)) {
            return;
        }
        ArrayList attachmentList = SysUtil.copyProperties(attachmentDTOList, PurchaseAttachment.class);
        this.purchaseAttachmentService.saveBatch(attachmentList, 200);
    }

    public void deleteByMainId(String id) {
        this.purchaseAttachmentService.deleteByMainId(id);
    }

    public void deleteByMainIdAndBusinessType(String id, String businessType) {
        this.purchaseAttachmentService.deleteByMainIdAndBusinessType(id, businessType);
    }

    public void sendFile(AttachmentSendDTO sendDTO, boolean sendAllFlag) {
        AttachmentSendVO sendVO = new AttachmentSendVO();
        BeanUtils.copyProperties((Object)sendDTO, (Object)sendVO);
        this.purchaseAttachmentService.sendFile(sendVO, sendAllFlag);
    }

    public void updateSaleFile(AttachmentSendDTO sendDTO) {
        AttachmentSendVO sendVO = new AttachmentSendVO();
        BeanUtils.copyProperties((Object)sendDTO, (Object)sendVO);
        this.purchaseAttachmentService.updateSaleFile(sendVO);
    }

    public void updateById(PurchaseAttachmentDTO attachmentDTO) {
        PurchaseAttachment attachment = (PurchaseAttachment)((Object)SysUtil.copyProperties((Object)attachmentDTO, PurchaseAttachment.class));
        this.purchaseAttachmentService.updateById((Object)attachment);
    }

    public void insert(PurchaseAttachmentDTO attachmentDTO) {
        PurchaseAttachment attachment = (PurchaseAttachment)((Object)SysUtil.copyProperties((Object)attachmentDTO, PurchaseAttachment.class));
        this.purchaseAttachmentService.save((Object)attachment);
    }

    public void updateAttachmentBatchById(List<PurchaseAttachmentDTO> purchaseAttachmentDtoList) {
        ArrayList<PurchaseAttachment> purchaseAttachmentList = new ArrayList<PurchaseAttachment>();
        if (CollectionUtil.isNotEmpty(purchaseAttachmentDtoList)) {
            for (PurchaseAttachmentDTO purchaseAttachmentDTO : purchaseAttachmentDtoList) {
                PurchaseAttachment attachment = (PurchaseAttachment)((Object)SysUtil.copyProperties((Object)purchaseAttachmentDTO, PurchaseAttachment.class));
                purchaseAttachmentList.add(attachment);
            }
            this.purchaseAttachmentService.updateBatchById(purchaseAttachmentList);
        }
    }

    public void deleteByBatchId(List<String> ids) {
        this.purchaseAttachmentService.delBatchPurchaseAttachment(ids);
    }

    public PurchaseAttachmentDTO selectById(String id) {
        PurchaseAttachment attachment = (PurchaseAttachment)((Object)this.purchaseAttachmentService.getById((Serializable)((Object)id)));
        return (PurchaseAttachmentDTO)SysUtil.copyProperties((Object)((Object)attachment), PurchaseAttachmentDTO.class);
    }

    public List<PurchaseAttachmentDTO> selectByMainIds(List<String> mainId) {
        List<PurchaseAttachment> purchaseAttachmentList = this.purchaseAttachmentService.selectByMainIds(mainId);
        return SysUtil.copyProperties(purchaseAttachmentList, PurchaseAttachmentDTO.class);
    }

    public void deleteByMainIds(List<String> headIds) {
        this.purchaseAttachmentService.deleteByMainIds(headIds);
    }
}

