/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.handle.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson2.JSONObject;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConfigUtil;
import com.els.common.util.ExternalUtil;
import com.els.common.util.I18nUtil;
import com.els.common.util.MqUtil;
import com.els.common.util.TemplateParseUtil;
import com.els.modules.integration.api.dto.ExternalVoucherDto;
import com.els.modules.message.handle.ISendMsgService;
import com.els.modules.message.util.MessageHandleFactory;
import com.els.modules.message.vo.MsgVO;
import com.els.modules.system.entity.ElsSubAccount;
import java.util.Date;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public abstract class AbstractSendMsgImpl
implements ISendMsgService,
InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractSendMsgImpl.class);
    protected static final String DING_TALK_SEND_MSG_URL = "https://oapi.dingtalk.com/topapi/message/corpconversation/asyncsend_v2";
    protected static final String DING_TALK_OAUTH2_URL = "/els/base/thirdLogin/loadQrCode/%s/mobile/dingtalk_account";
    protected static final String FEISHU_SEND_MSG_URL = "https://open.feishu.cn/open-apis/im/v1/messages?receive_id_type=union_id";
    protected static final String FEISHU_OAUTH2_URL = "/els/base/thirdLogin/loadQrCode/%s/mobile/feishu";
    protected static final String WECHAT_EP_SEND_MSG_URL = "https://qyapi.weixin.qq.com/cgi-bin/message/send";
    protected static final String WECHAT_EP_OAUTH2_URL = "/els/base/thirdLogin/loadQrCode/%s/mobile/wechat_enterprise_web";
    protected static final String WECHAT_MP_SEND_MSG_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send";
    protected static final String WECHAT_MP_OAUTH2_URL = "/els/base/thirdLogin/loadQrCode/%s/mobile/wechat_mp";
    protected static final String WECHAT_MP_DEVELOP_OAUTH2_URL = "/els/base/thirdLogin/loadQrCode/%s/mobile/wechat_enterprise_develop";
    protected static final String WECHAT_MP_GET_USER = "https://api.weixin.qq.com/cgi-bin/user/get";

    public abstract void doSendMsg(MsgVO var1);

    @Override
    public void sendMsg(MsgVO msgVO) {
        this.doSendMsg(msgVO);
        try {
            JSONObject object = new JSONObject();
            object.put((Object)"logType", (Object)"msg");
            object.put((Object)"elsAccount", (Object)msgVO.getSendAccountInfo().getElsAccount());
            object.put((Object)"accountId", (Object)msgVO.getSendAccountInfo().getId());
            object.put((Object)"realname", (Object)msgVO.getSendAccountInfo().getRealname());
            object.put((Object)"businessId", (Object)msgVO.getBusinessId());
            object.put((Object)"businessName", (Object)msgVO.getMsgConfigName());
            object.put((Object)"operateName", (Object)msgVO.getMsgType());
            object.put((Object)"businessNumber", (Object)msgVO.getMsgConfigCode());
            object.put((Object)"logTime", (Object)DateUtil.formatDateTime((Date)new Date()));
            object.put((Object)"logContent", (Object)msgVO.getConfigItem().getMsgContent());
            MqUtil.sendLogMsg((String)object.toString());
        }
        catch (Exception e) {
            log.error("AbstractSendMsgImpl_log_failed:", (Throwable)e);
        }
    }

    protected String getConcat(String url) {
        if (StrUtil.isBlank((CharSequence)url)) {
            return "?";
        }
        return url.contains("?") ? "&" : "?";
    }

    protected StringBuilder getServiceBuilder() {
        return new StringBuilder(ConfigUtil.getServiceAddress());
    }

    private String reBuildUrlParam(String linkUrl, String urlParam, JSONObject businessObj) {
        if (CharSequenceUtil.isEmpty((CharSequence)linkUrl)) {
            linkUrl = "";
        }
        if (CharSequenceUtil.isEmpty((CharSequence)urlParam) || null == businessObj) {
            return linkUrl;
        }
        String urlPrams = ((String)linkUrl).split("\\?")[1];
        List<String> lingUrlKey = CharSequenceUtil.split((CharSequence)urlPrams, (CharSequence)"&").stream().map(x -> ((String)CharSequenceUtil.split((CharSequence)x.trim(), (CharSequence)"=").get(0)).trim()).toList();
        List params = StrUtil.split((CharSequence)urlParam.trim(), (CharSequence)",");
        StringBuilder sb = new StringBuilder();
        for (String p : params) {
            String val;
            if (lingUrlKey.contains(p) || !CharSequenceUtil.isNotEmpty((CharSequence)(val = businessObj.getString(p)))) continue;
            sb.append(p).append("=").append(val).append("&");
        }
        sb.deleteCharAt(sb.length() - 1);
        linkUrl = ((String)linkUrl).contains("?") ? (((String)linkUrl).endsWith("&") ? (String)linkUrl + sb : (String)linkUrl + "&" + sb) : (String)linkUrl + "?" + sb;
        return linkUrl;
    }

    protected String getUrl(String urlParam, String busAccount, ElsSubAccount accountInfo) {
        String routeUri = URLUtil.encodeAll((String)urlParam);
        return this.getServiceBuilder().append(String.format(this.getOauthUrl(), busAccount)).append("?routeUri=").append(routeUri).toString();
    }

    protected String getOauthUrl() {
        throw new ELSBootException("Please rewrite method to get oauth url");
    }

    protected String buildLinkUrl(JSONObject businessObj, String linkUrl, String urlParam, String elsAccount, ElsSubAccount accountInfo) {
        if (null == businessObj || businessObj.size() == 0 || CharSequenceUtil.isEmpty((CharSequence)linkUrl)) {
            return linkUrl;
        }
        linkUrl = this.parseContentTemplateText("", linkUrl, (Map<String, Object>)businessObj);
        linkUrl = this.reBuildUrlParam(linkUrl, urlParam, businessObj);
        return this.getUrl(linkUrl, elsAccount, accountInfo);
    }

    protected String parseContentTemplateText(String templateName, String msgContent, Map<String, Object> paramsMap) {
        if (CharSequenceUtil.isEmpty((CharSequence)msgContent)) {
            return "";
        }
        if (null == paramsMap || paramsMap.size() == 0) {
            return msgContent;
        }
        try {
            return TemplateParseUtil.getTemplateText((String)templateName, (String)msgContent, paramsMap);
        }
        catch (Exception e) {
            log.error("\u53d1\u6d88\u606f\u6784\u5efa\u6d88\u606f\u4f53\u62a5\u9519:{}", (Object)e.getMessage());
            return msgContent;
        }
    }

    protected ExternalVoucherDto getJustConfig(String busAccount, String type) {
        ExternalVoucherDto config = ExternalUtil.getVoucher((String)busAccount, (String)type);
        if (null == config) {
            log.error(":::\u8bf7\u5148\u5b8c\u5584\u7b2c\u4e09\u65b9\u51ed\u8bc1\u7ba1\u7406\u4e2d\u7684\u914d\u7f6e:{}", (Object)type);
            throw new ELSBootException(I18nUtil.translate((String)"\u8bf7\u5148\u5b8c\u5584\u7b2c\u4e09\u65b9\u51ed\u8bc1\u914d\u7f6e:") + type);
        }
        return config;
    }

    public void afterPropertiesSet() throws Exception {
        MessageHandleFactory.putMsgHandle(this.supportType(), this);
    }
}

