/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsTax;
import com.els.modules.system.excel.ElsTaxExportServiceImpl;
import com.els.modules.system.service.ElsTaxService;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Tag(name="\u7a0e\u7387\u7a0e\u7801")
@RestController
@RequestMapping(value={"/base/tax"})
public class ElsTaxController
extends BaseController<ElsTax, ElsTaxService> {
    private static final String fixPreRedisKey = "tax_";
    @Autowired
    private ElsTaxService elsTaxService;
    @Autowired
    private RedisUtil redisUtil;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"tax#tax:list"})
    public Result<?> queryPageList(ElsTax elsTax, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String elsAccount = SysUtil.getDeployWay().equals("cloud") ? (StrUtil.isBlank((CharSequence)req.getParameter("elsAccount")) ? TenantContext.getTenant() : req.getParameter("elsAccount")) : SysUtil.getPurchaseAccount();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTax), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)elsAccount);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTaxService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/sysList"})
    @RequiresPermissions(value={"tax#tax:sysList"})
    public Result<?> querySysPageList(ElsTax elsTax, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTax), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"els_account", (Object)"100000");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTaxService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @Operation(summary="\u67e5\u8be2\u5168\u90e8", description="\u67e5\u8be2\u5168\u90e8")
    @RequiresPermissions(value={"tax#tax:queryById"})
    @RequestMapping(value={"/listAll"}, method={RequestMethod.POST})
    public Result<List<ElsTax>> listAll(@RequestBody ElsTax elsTax) {
        List ls;
        String elsAccount = TenantContext.getTenant();
        String redisKey = fixPreRedisKey + elsAccount;
        Result result = new Result();
        if (StrUtil.isBlank((CharSequence)elsTax.getTaxCode())) {
            Object object = this.redisUtil.get(redisKey);
            if (object != null) {
                ls = (List)object;
            } else {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"els_account", (Object)elsAccount);
                ls = this.elsTaxService.list((Wrapper)queryWrapper);
                if (ls.isEmpty()) {
                    queryWrapper.clear();
                    queryWrapper.eq((Object)"els_account", (Object)"100000");
                    ls = this.elsTaxService.list((Wrapper)queryWrapper);
                    if (!ls.isEmpty()) {
                        this.redisUtil.set(redisKey, (Object)ls);
                    }
                }
            }
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"els_account", (Object)elsAccount);
            queryWrapper.eq((Object)"tax_code", (Object)elsTax.getTaxCode());
            ls = this.elsTaxService.list((Wrapper)queryWrapper);
            if (ls.isEmpty()) {
                queryWrapper.clear();
                queryWrapper.eq((Object)"els_account", (Object)"100000");
                queryWrapper.eq((Object)"tax_code", (Object)elsTax.getTaxCode());
                ls = this.elsTaxService.list((Wrapper)queryWrapper);
            }
        }
        result.setSuccess(true);
        result.setResult((Object)ls);
        return result;
    }

    @SrmValidated
    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u6dfb\u52a0", operateType=2)
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @RequiresPermissions(value={"tax#tax:add"})
    public Result<?> add(@RequestBody ElsTax elsTax) {
        this.elsTaxService.saveElsTax(elsTax);
        this.redisUtil.set(fixPreRedisKey + TenantContext.getTenant(), null);
        return Result.ok((Object)((Object)elsTax));
    }

    @SrmValidated
    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u7f16\u8f91", operateType=3)
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @RequiresPermissions(value={"tax#tax:edit"})
    public Result<?> edit(@RequestBody ElsTax elsTax) {
        this.elsTaxService.updateElsTax(elsTax);
        this.redisUtil.set(fixPreRedisKey + TenantContext.getTenant(), null);
        String id = elsTax.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u901a\u8fc7id\u5220\u9664", operateType=4)
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"tax#tax:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.elsTaxService.delElsTax(id);
        this.redisUtil.set(fixPreRedisKey + TenantContext.getTenant(), null);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u7a0e\u7387\u7a0e\u7801-\u6279\u91cf\u5220\u9664", operateType=4)
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"tax#tax:deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.elsTaxService.delBatchElsTax(idList);
        this.redisUtil.set(fixPreRedisKey + TenantContext.getTenant(), null);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"tax#tax:queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        ElsTax elsTax = (ElsTax)((Object)this.elsTaxService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        return Result.ok((Object)((Object)elsTax));
    }

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/queryTaxForTemplate"})
    @RequiresPermissions(value={"tax#tax:base"})
    public Result<?> queryTaxForTemplate(ElsTax elsTax, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        String elsAccount = StrUtil.isBlank((CharSequence)req.getParameter("purchaseAccount")) ? TenantContext.getTenant() : req.getParameter("purchaseAccount");
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTax), (Map)req.getParameterMap());
        queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)elsAccount);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.elsTaxService.page((IPage)page, (Wrapper)queryWrapper);
        if (pageList.getRecords().isEmpty()) {
            queryWrapper.clear();
            queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)elsTax), (Map)req.getParameterMap());
            queryWrapper.lambda().eq(ParentEntity::getElsAccount, (Object)"100000");
            pageList = this.elsTaxService.page((IPage)page, (Wrapper)queryWrapper);
        }
        return Result.ok((Object)pageList);
    }

    @PostMapping(value={"/exportXls"})
    @RequiresPermissions(value={"tax#tax:exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestBody Map<String, Object> object) {
        return super.exportXls(request, object, ElsTaxExportServiceImpl.class);
    }

    @Operation(summary="\u83b7\u53d6ERP\u6570\u636e", description="\u83b7\u53d6ERP\u6570\u636e")
    @GetMapping(value={"/getDataByErp"})
    @RequiresPermissions(value={"tax#tax:getDataByErp"})
    public Result<?> getDataByErp() {
        this.elsTaxService.getDataByErp();
        return Result.ok();
    }

    @Operation(summary="SRM\u63a8\u9001\u5230ERP", description="SRM\u63a8\u9001\u5230ERP")
    @GetMapping(value={"/pushDataToErp"})
    @RequiresPermissions(value={"tax#tax:pushDataToErp"})
    public Result<?> pushDataToErp(@RequestParam(value="ids") String ids) {
        this.elsTaxService.pushDataToErp(ids);
        return Result.ok();
    }

    @AutoLog(value="\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0", operateType=2)
    @Operation(summary="\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0", description="\u5c06100000\u53f7\u7684Excel\u914d\u7f6e\u6dfb\u52a0\u5230\u4f01\u4e1a\u7ea7-\u6dfb\u52a0")
    @GetMapping(value={"/addToEnterprise"})
    @RequiresPermissions(value={"tax#tax:addToEnterprise"})
    public Result<?> addToEnterprise(@RequestParam(value="id") String id) {
        this.elsTaxService.addToEnterprise(id);
        return Result.ok((Object)2);
    }
}

