/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.util;

import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.SheetWriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.excel.write.metadata.holder.WriteWorkbookHolder;
import com.els.modules.system.entity.ExcelDetail;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExcelCellStyleStrategy
implements CellWriteHandler,
SheetWriteHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExcelCellStyleStrategy.class);
    private final List<ExcelDetail> detailList;
    private final Set<Integer> widthSetCols = new HashSet<Integer>();

    public ExcelCellStyleStrategy(List<ExcelDetail> detailList) {
        this.detailList = null == detailList ? Lists.newArrayList() : detailList;
    }

    public void beforeSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
        this.widthSetCols.clear();
    }

    public void afterSheetCreate(WriteWorkbookHolder writeWorkbookHolder, WriteSheetHolder writeSheetHolder) {
    }

    public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        ExcelDetail excelDetail;
        if (isHead == null || !isHead.booleanValue()) {
            return;
        }
        if (relativeRowIndex != null && relativeRowIndex == 1 && cell.getColumnIndex() < this.detailList.size() && "1".equals((excelDetail = this.detailList.get(cell.getColumnIndex())).getRequired())) {
            log.info("\u4e3a\u7b2c {} \u5217\u521b\u5efa\u5e76\u5e94\u7528\u4e00\u4e2a\u65b0\u7684\u7ea2\u8272\u6837\u5f0f...", (Object)cell.getColumnIndex());
            CellStyle newRedStyle = this.createHeaderStyle(cell.getSheet().getWorkbook());
            cell.setCellStyle(newRedStyle);
        }
        if (!this.widthSetCols.contains(head.getColumnIndex())) {
            int maxWidth = 0;
            for (String headName : head.getHeadNameList()) {
                if (headName == null) continue;
                int length = 0;
                for (char c : headName.toCharArray()) {
                    if (c > '\u00ff') {
                        length += 2;
                        continue;
                    }
                    ++length;
                }
                if (length <= maxWidth) continue;
                maxWidth = length;
            }
            int columnWidth = (maxWidth + 8) * 256;
            if ((columnWidth = (int)((double)columnWidth * 1.2)) > 65280) {
                columnWidth = 65280;
            }
            cell.getSheet().setColumnWidth(head.getColumnIndex().intValue(), columnWidth);
            this.widthSetCols.add(head.getColumnIndex());
        }
    }

    private CellStyle createHeaderStyle(Workbook workbook) {
        CellStyle style = workbook.createCellStyle();
        Font font = workbook.createFont();
        font.setFontName("\u5b8b\u4f53");
        font.setFontHeightInPoints((short)11);
        font.setBold(true);
        font.setColor(IndexedColors.RED.getIndex());
        style.setFont(font);
        style.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        style.setAlignment(HorizontalAlignment.CENTER);
        style.setVerticalAlignment(VerticalAlignment.CENTER);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        return style;
    }
}

