/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson2.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.SrmUtil;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.dto.ImMessageCallbackDto;
import com.els.modules.im.dto.ImMessageDto;
import com.els.modules.im.entity.ImGroupChat;
import com.els.modules.im.entity.ImGroupChatConfig;
import com.els.modules.im.entity.ImGroupChatUser;
import com.els.modules.im.entity.ImMessage;
import com.els.modules.im.service.IImGroupChatService;
import com.els.modules.im.service.IImGroupChatUserService;
import com.els.modules.im.service.IImMessageService;
import com.els.modules.im.service.ImAccountLocalService;
import com.els.modules.im.service.ImGroupChatConfigService;
import com.els.modules.im.utils.ImUtils;
import com.els.modules.im.vo.ImGroupChatVO;
import com.els.modules.system.entity.ElsSubAccount;
import com.google.common.collect.Lists;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="IM\u804a\u5929\u6d88\u606f\u7ba1\u7406")
@RestController
@RequestMapping(value={"/im/message"})
public class ImMessageController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImMessageController.class);
    @Resource
    private IImMessageService iImMessageService;
    @Resource
    private IImGroupChatService imGroupChatService;
    @Resource
    private IImGroupChatUserService imChatGroupUserService;
    @Autowired
    private ImGroupChatConfigService imGroupChatConfigService;
    @Resource
    private BusinessHelper businessHelper;
    @Resource
    private ImAccountLocalService imAccountLocalService;

    @Operation(summary="\u5206\u9875\u83b7\u53d6\u7fa4\u7ec4\u804a\u5929\u8bb0\u5f55", description="\u5206\u9875\u83b7\u53d6\u7fa4\u7ec4\u804a\u5929\u8bb0\u5f55")
    @GetMapping(value={"group-page"})
    public Result<?> groupPage(ImMessageDto imMessageDto, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize) {
        List<ImGroupChatConfig> configLink = this.imGroupChatConfigService.loadConfig();
        Map<String, String> stringMap = configLink.stream().collect(Collectors.toMap(ImGroupChatConfig::getBusinessType, ImGroupChatConfig::getDescription, (v1, v2) -> v2));
        imMessageDto.setKeyWord(ImUtils.getImRecordTypeEnum(imMessageDto.getKeyWord(), configLink));
        IPage<ImGroupChatVO> pageList = this.iImMessageService.groupPage(imMessageDto, pageNo, pageSize);
        if (CollUtil.isNotEmpty((Collection)pageList.getRecords())) {
            List<ElsSubAccountDTO> userList = this.imAccountLocalService.getUsersByUserIdList(pageList.getRecords().stream().map(ImGroupChatVO::getGroupChatMasterId).distinct().collect(Collectors.toList()));
            Map<String, String> map = userList.stream().collect(Collectors.toMap(ParentEntityDTO::getId, x -> x.getRealname() + "_" + x.getElsAccount() + "_" + x.getSubAccount()));
            Map<String, String> avatarMap = userList.stream().collect(Collectors.toMap(ParentEntityDTO::getId, ElsSubAccountDTO::getAvatar));
            pageList.getRecords().forEach(m -> {
                String recordI18Value = ImUtils.getRecordI18Value(m.getBusinessType(), configLink);
                if (CharSequenceUtil.isNotEmpty((CharSequence)recordI18Value)) {
                    String groupName = m.getGroupChatName().replace(m.getBusinessType(), recordI18Value);
                    m.setGroupChatName(groupName);
                }
                if (stringMap.containsKey(m.getBusinessType())) {
                    m.setBusinessType((String)stringMap.get(m.getBusinessType()));
                }
                if (map.containsKey(m.getGroupChatMasterId())) {
                    m.setGroupChatMasterName((String)map.get(m.getGroupChatMasterId()));
                }
                if (avatarMap.containsKey(m.getGroupChatMasterId())) {
                    m.setGroupChatHeadPortrait((String)avatarMap.get(m.getGroupChatMasterId()));
                }
            });
        }
        return Result.ok(pageList);
    }

    @Operation(summary="\u5206\u9875\u83b7\u53d6\u804a\u5929\u8bb0\u5f55", description="\u5206\u9875\u83b7\u53d6\u804a\u5929\u8bb0\u5f55")
    @GetMapping(value={"list"})
    public Result<?> list(@RequestParam(name="chatId") String chatId, @RequestParam(name="chatType") String chatType, @RequestParam(name="pageNo") Long pageNo, Integer pageSize) {
        String fromId = SrmUtil.getLoginUser().getId();
        if (CharSequenceUtil.isEmpty((CharSequence)chatId) || CharSequenceUtil.isEmpty((CharSequence)fromId)) {
            throw new ELSBootException("\u6d88\u606fID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Page page = new Page();
        page.setSize(null == pageSize ? 2000L : (long)pageSize.intValue());
        if (pageNo == null) {
            pageNo = 0L;
        }
        page.setCurrent(pageNo.longValue());
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        if ("friend".equals(chatType) || "kefu".equals(chatType)) {
            wrapper.and(wrapper1 -> ((LambdaQueryWrapper)wrapper1.eq(ImMessage::getMessageToId, (Object)chatId)).eq(ImMessage::getMessageFromId, (Object)fromId));
            wrapper.or(wrapper2 -> ((LambdaQueryWrapper)wrapper2.eq(ImMessage::getMessageFromId, (Object)chatId)).eq(ImMessage::getMessageToId, (Object)fromId));
        } else {
            wrapper.eq(ImMessage::getMessageToId, (Object)chatId);
            ImGroupChat chatGroup = (ImGroupChat)((Object)this.imGroupChatService.getById((Serializable)((Object)chatId)));
            ElsSubAccount master = this.imAccountLocalService.getAccountInfoById(chatGroup.getGroupChatMasterId());
            if (!SrmUtil.getLoginUser().getId().equals(chatGroup.getGroupChatMasterId()) && !this.imAccountLocalService.checkIfSameElsAccountByUserId(master.getElsAccount(), SrmUtil.getLoginUser().getId()) && CharSequenceUtil.isNotBlank((CharSequence)chatGroup.getBusinessType())) {
                List<String> subAccountId = this.imAccountLocalService.loadElsAccountId(Lists.newArrayList((Object[])new String[]{master.getElsAccount(), SrmUtil.getLoginUser().getElsAccount()}));
                List<ImGroupChatUser> groupUserList = this.imChatGroupUserService.getChatUserByChatId(chatId);
                List<String> groupUserIds = groupUserList.stream().map(ImGroupChatUser::getUserId).toList();
                subAccountId = subAccountId.stream().filter(groupUserIds::contains).collect(Collectors.toList());
                wrapper.in(ImMessage::getMessageFromId, subAccountId);
            }
        }
        wrapper.eq(ImMessage::getMessageChatType, (Object)chatType);
        wrapper.orderByDesc(ImMessage::getMessageSendTime);
        IPage messagePage = this.iImMessageService.page((IPage)page, (Wrapper)wrapper);
        List imMessageList = messagePage.getRecords();
        ArrayList<WsMessageDataPackets> messageList = new ArrayList<WsMessageDataPackets>();
        List<String> userIds = imMessageList.stream().map(ImMessage::getMessageFromId).distinct().collect(Collectors.toList());
        List<ElsSubAccountDTO> imUserDTOList = this.imAccountLocalService.getUsersByUserIdList(userIds);
        Map userMap = imUserDTOList.stream().collect(Collectors.toMap(ParentEntityDTO::getId, Function.identity(), (v1, v2) -> v1));
        for (ImMessage imMessage : imMessageList) {
            WsMessageDataPackets message = new WsMessageDataPackets();
            message.setId(imMessage.getId());
            message.setMessageToId(imMessage.getMessageToId());
            message.setMine(fromId.equals(imMessage.getMessageFromId()));
            message.setMessageChatType(imMessage.getMessageChatType());
            ElsSubAccountDTO imUser = (ElsSubAccountDTO)userMap.get(imMessage.getMessageFromId());
            message.setElsAccount(imUser.getElsAccount());
            message.setSubAccount(imUser.getSubAccount());
            if (imUser != null) {
                message.setHeadPortrait(imUser.getAvatar());
                message.setRealname(imUser.getRealname());
                message.setCompanyName(imUser.getCompanyName());
            }
            if ("1".equals(imMessage.getMessageReplyByRobot())) {
                message.setRealname("\u673a\u667a\u7684\u5c0f\u4f01");
                message.setHeadPortrait("/kefu/static/robot.png");
                message.setCompanyName("QQT");
            }
            message.setMessageFromId(imMessage.getMessageFromId());
            message.setMessageContent(imMessage.getMessageContent());
            message.setMessageSendTime(imMessage.getMessageSendTime().getTime());
            message.setMessageType(imMessage.getMessageType());
            message.setUndoMessageId(imMessage.getId());
            message.setMessageUndoStatus(imMessage.getMessageUndoStatus());
            messageList.add(message);
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        map.put("records", messageList);
        map.put("total", Long.valueOf(messagePage.getTotal()));
        map.put("size", Long.valueOf(messagePage.getSize()));
        return Result.ok(map);
    }

    @PostMapping(value={"noToken/message-callback"})
    public Result<?> messageCallback(@RequestBody ImMessageCallbackDto dto) {
        ImMessage imMessage = (ImMessage)this.iImMessageService.getById((Serializable)((Object)dto.getSrmNewsId()));
        if (null == imMessage || !"kefu".equals(imMessage.getMessageChatType())) {
            throw new ELSBootException(I18nUtil.translate((String)"\u6d88\u606f\u4e0d\u5b58\u5728"));
        }
        this.businessHelper.messageCallback(imMessage, dto);
        return Result.ok();
    }

    @PostMapping(value={"/noToken/callback"})
    public Result<?> callback(@RequestBody JSONObject param) {
        this.checkParam(param);
        JSONObject bodyObj = param.getJSONObject("body");
        String msgId = bodyObj.getString("msgId");
        String content = bodyObj.getJSONObject("record").getString("content");
        ImMessage imMessage = (ImMessage)this.iImMessageService.getById((Serializable)((Object)msgId));
        if (null == imMessage || !"kefu".equals(imMessage.getMessageChatType())) {
            throw new ELSBootException(I18nUtil.translate((String)"\u6d88\u606f\u4e0d\u5b58\u5728"));
        }
        ImMessageCallbackDto callbackDto = new ImMessageCallbackDto();
        callbackDto.setSrmNewsId(msgId);
        callbackDto.setSendNews(content);
        callbackDto.setSendNewsType("0");
        this.businessHelper.messageCallback(imMessage, callbackDto);
        return Result.ok();
    }

    private void checkParam(JSONObject param) {
    }
}

