/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.im.core.server.handler.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.api.dto.ParentEntityDTO;
import com.els.common.util.SpringContextUtils;
import com.els.modules.im.core.ImSender;
import com.els.modules.im.core.message.BusinessHelper;
import com.els.modules.im.core.packets.GroupChatUserPackets;
import com.els.modules.im.core.packets.ImPackets;
import com.els.modules.im.core.packets.ImUserPackets;
import com.els.modules.im.core.packets.WsMessageDataPackets;
import com.els.modules.im.core.packets.WsMessagePackets;
import com.els.modules.im.core.packets.WsMsgTypePackets;
import com.els.modules.im.core.packets.WsResultPackets;
import com.els.modules.im.core.server.handler.AbstractConnHandler;
import com.els.modules.im.core.server.handler.Opt;
import com.els.modules.im.dto.GroupMessageUserDto;
import com.els.modules.im.entity.ImGroupChat;
import com.els.modules.im.entity.ImGroupChatConfig;
import com.els.modules.im.entity.ImGroupMessageUser;
import com.els.modules.im.service.ImGroupMessageUserService;
import com.els.modules.im.service.impl.ImGroupChatConfigServiceImpl;
import com.els.modules.im.utils.ImUtils;
import com.google.common.collect.Lists;
import jakarta.annotation.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.intf.Packet;
import org.tio.utils.lock.SetWithLock;
import org.tio.websocket.common.WsRequest;
import org.tio.websocket.common.WsResponse;

@Service
public class GroupChatHandler
extends AbstractConnHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupChatHandler.class);
    @Resource(name="srmBusinessHelper")
    private BusinessHelper srmBusinessHelper;

    @Override
    public Opt opt() {
        return Opt.GROUP_MSG_MESSAGE;
    }

    @Override
    public Object reCallOnText(WsRequest wsRequest, String text, ChannelContext channelContext) {
        return null;
    }

    @Override
    protected Object doHandler(WsResultPackets wsResult, WsRequest wsRequest, WsMessagePackets wsMessage, ChannelContext channelContext) {
        switch (wsMessage.getConnOpt()) {
            case "chat": {
                WsMessageDataPackets groupMsg = wsMessage.getMessage();
                ImUserPackets imUserPackets = this.srmBusinessHelper.loadLoginUserDtoId(groupMsg.getMessageFromId());
                groupMsg.setElsAccount(imUserPackets.getElsAccount());
                groupMsg.setSubAccount(imUserPackets.getSubAccount());
                groupMsg.setCompanyName(imUserPackets.getCompanyName());
                wsResult.setMsgType(WsMsgTypePackets.GROUP_MESSAGE.getMsgType());
                boolean inGroup = Tio.isInGroup((String)groupMsg.getMessageToId(), (ChannelContext)channelContext);
                if (!inGroup) {
                    Tio.bindGroup((ChannelContext)channelContext, (String)groupMsg.getMessageToId());
                }
                List<GroupChatUserPackets> chatGroupUser = this.srmBusinessHelper.getGroupUsersByGroupId(groupMsg.getMessageToId(), null);
                ArrayList<GroupMessageUserDto> messageUserVoList = new ArrayList<GroupMessageUserDto>(chatGroupUser.size());
                for (GroupChatUserPackets user : chatGroupUser) {
                    if (groupMsg.getMessageFromId().equals(user.getUserId()) || this.srmBusinessHelper.isOnline(user.getUserId())) continue;
                    GroupMessageUserDto vo = new GroupMessageUserDto();
                    vo.setGroupId(groupMsg.getMessageToId());
                    vo.setUserId(user.getUserId());
                    vo.setRead(false);
                    messageUserVoList.add(vo);
                }
                groupMsg.setId(IdWorker.getIdStr());
                wsResult.setData(groupMsg);
                ImPackets imPacket = this.buildImPacket(wsResult, groupMsg);
                String addMessageId = this.inOrderToSendGroupMessage(channelContext, groupMsg, imPacket, messageUserVoList);
                if (!CharSequenceUtil.isNotEmpty((CharSequence)addMessageId)) break;
                WsResultPackets wsResultMap = new WsResultPackets();
                wsResultMap.setMsgType(WsMsgTypePackets.SEND_MESSAGE_ID_RETURN.getMsgType());
                WsMessageDataPackets resultMessage = new WsMessageDataPackets();
                resultMessage.setUnSaveMessageId(groupMsg.getUnSaveMessageId());
                resultMessage.setUndoMessageId(addMessageId);
                wsResultMap.setData(resultMessage);
                SetWithLock mimeChannelContextSetWithLock = Tio.getByUserid((TioConfig)channelContext.getTioConfig(), (String)channelContext.userid);
                if (mimeChannelContextSetWithLock == null || mimeChannelContextSetWithLock.size() == 0) break;
                WsResponse wsResponse = WsResponse.fromText((String)wsResultMap.toJsonString(), (String)"utf-8");
                Tio.sendToUser((TioConfig)channelContext.getTioConfig(), (String)channelContext.userid, (Packet)wsResponse);
                break;
            }
            case "request_join_group": {
                break;
            }
        }
        return null;
    }

    private String inOrderToSendGroupMessage(ChannelContext channelContext, WsMessageDataPackets message, ImPackets imPacket, List<GroupMessageUserDto> messageUserVoList) {
        ImGroupChat group = this.srmBusinessHelper.getChatGroupById(message.getMessageToId());
        List<String> fromUserIds = new ArrayList<String>();
        if (!group.getGroupChatMasterId().equals(message.getMessageFromId())) {
            List<ImUserPackets> userList = this.srmBusinessHelper.getUsersByUserIdList(Lists.newArrayList((Object[])new String[]{message.getMessageFromId(), group.getGroupChatMasterId()}));
            Map<String, String> userMap = userList.stream().collect(Collectors.toMap(ParentEntityDTO::getId, ImUserPackets::getElsAccount));
            List<String> elsAccountList = userList.stream().map(ImUserPackets::getElsAccount).collect(Collectors.toList());
            Map<String, List<String>> idMap = this.srmBusinessHelper.loadElsAccountIdToMap(elsAccountList);
            List<String> masterIds = idMap.get(userMap.get(group.getGroupChatMasterId()));
            if (!masterIds.contains(message.getMessageFromId())) {
                fromUserIds = idMap.get(userMap.get(message.getMessageFromId()));
                fromUserIds.addAll(masterIds);
            }
        }
        String messageToId = message.getMessageToId();
        ImGroupChat chatGroupById = this.srmBusinessHelper.getChatGroupById(messageToId);
        List<ImGroupChatConfig> elsChatConfigs = ((ImGroupChatConfigServiceImpl)SpringContextUtils.getBean(ImGroupChatConfigServiceImpl.class)).loadConfig();
        if (null != group) {
            String recordI18Value = ImUtils.getRecordI18Value(group.getBusinessType(), elsChatConfigs);
            if (CharSequenceUtil.isNotEmpty((CharSequence)recordI18Value)) {
                String groupName = group.getGroupChatName().replace(group.getBusinessType(), recordI18Value);
                message.setGroupChatName(groupName);
            } else {
                message.setGroupChatName(group.getGroupChatName());
            }
        }
        message.setGroupChatHeadPortrait(chatGroupById.getGroupChatHeadPortrait());
        ImSender.sendToGroup(message.getMessageToId(), fromUserIds, null, channelContext.getTioConfig(), imPacket);
        WsMessageDataPackets imMessage = this.storeMessage(message, "1", "group");
        ArrayList<String> finalFromUserIds = fromUserIds;
        messageUserVoList = messageUserVoList.stream().filter(x -> CollectionUtils.isEmpty((Collection)finalFromUserIds) || finalFromUserIds.contains(x.getUserId())).collect(Collectors.toList());
        List collect = messageUserVoList.stream().filter(x -> !x.isRead()).map(x -> {
            ImGroupMessageUser tem = new ImGroupMessageUser();
            tem.setMessageStatus("1");
            tem.setUserId(x.getUserId());
            tem.setGroupChatId(message.getMessageToId());
            tem.setMessageId(imMessage.getId());
            return tem;
        }).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            ((ImGroupMessageUserService)SpringContextUtils.getBean(ImGroupMessageUserService.class)).saveBatch(collect);
        }
        if (CollectionUtils.isNotEmpty(messageUserVoList)) {
            this.srmBusinessHelper.sendOutLineMessage(message.getMessageFromId(), "imChatGroup", message.getMessageToId(), imMessage, messageUserVoList.stream().map(GroupMessageUserDto::getUserId).collect(Collectors.toList()));
        }
        return imMessage.getId();
    }
}

