/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.system.excel;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.aspect.annotation.RpcService;
import com.els.common.constant.CommonConstant;
import com.els.common.excel.service.ErrorExcelHandlerService;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.dto.ExcelImportDTO;
import com.els.modules.base.api.service.ExcelImportRpcService;
import com.els.modules.language.service.I18nService;
import com.els.modules.system.entity.Dict;
import com.els.modules.system.entity.DictItem;
import com.els.modules.system.service.DictItemService;
import com.els.modules.system.service.DictService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="dictItemListImportRpcImpl")
public class DictItemListItemImportImpl
extends ErrorExcelHandlerService
implements ExcelImportRpcService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DictItemListItemImportImpl.class);
    @Autowired
    private DictService dictService;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private I18nService i18nService;

    public List<Map<String, Object>> importExcel(ExcelImportDTO excelImportDTO) {
        List dataList = excelImportDTO.getDataList();
        int totalCount = 0 == excelImportDTO.getTotalCount() ? dataList.size() : excelImportDTO.getTotalCount();
        ArrayList<String> dictCodeList = new ArrayList<String>();
        ArrayList<CallSite> dictCodeItemList = new ArrayList<CallSite>();
        ArrayList<CallSite> dictCodeTextItemList = new ArrayList<CallSite>();
        Iterator iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Object msg;
            Map data = (Map)iterator.next();
            String dictCode = (String)data.get("dictCode");
            if (CharSequenceUtil.isEmpty((CharSequence)dictCode)) {
                String msg2 = I18nUtil.translate((String)"i18n_alert_JCAoxOLV_9aa1ee7c", (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg2, data);
                iterator.remove();
                continue;
            }
            String itemValue = (String)data.get("itemValue");
            if (CharSequenceUtil.isEmpty((CharSequence)itemValue)) {
                String msg3 = I18nUtil.translate((String)"i18n_alert_JCdAoxOLV_f8f457d3", (String)"\u5b57\u5178\u9879\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, msg3, data);
                iterator.remove();
                continue;
            }
            String itemText = (String)data.get("itemText");
            if (CharSequenceUtil.isEmpty((CharSequence)itemText)) {
                msg = I18nUtil.translate((String)"i18n_alert_JCdRLxOLV_a47577ab", (String)"\u5b57\u5178\u9879\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                this.errorAdd(excelImportDTO, (String)msg, data);
                iterator.remove();
                continue;
            }
            if (!dictCodeList.contains(dictCode)) {
                dictCodeList.add(dictCode);
            }
            if (dictCodeItemList.contains(dictCode + "_" + itemValue)) {
                msg = dictCode + I18nUtil.translate((String)"i18n_alert_JCAoMKVBJCdAo_86440a7", (String)"\u5b57\u5178\u7f16\u7801\u5b58\u5728\u91cd\u590d\u5b57\u5178\u9879\u7f16\u7801") + ":" + itemValue;
                this.errorAdd(excelImportDTO, (String)msg, data);
                iterator.remove();
            } else {
                dictCodeItemList.add((CallSite)((Object)(dictCode + "_" + itemValue)));
            }
            if (dictCodeTextItemList.contains(dictCode + "_" + itemText)) {
                msg = dictCode + I18nUtil.translate((String)"i18n_alert_JCAoMKVBJCdRL_85f0c7f", (String)"\u5b57\u5178\u7f16\u7801\u5b58\u5728\u91cd\u590d\u5b57\u5178\u9879\u540d\u79f0") + ":" + itemText;
                this.errorAdd(excelImportDTO, (String)msg, data);
                iterator.remove();
                continue;
            }
            dictCodeTextItemList.add((CallSite)((Object)(dictCode + "_" + itemText)));
        }
        if (CollUtil.isEmpty(dictCodeList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.select(new SFunction[]{ParentEntity::getId, Dict::getDictCode});
        ((LambdaQueryWrapper)wrapper.in(Dict::getDictCode, dictCodeList)).eq(ParentEntity::getElsAccount, (Object)TenantContext.getTenant());
        List dictList = this.dictService.list((Wrapper)wrapper);
        Map<String, String> dictIdMap = dictList.stream().collect(Collectors.toMap(Dict::getDictCode, ParentEntity::getId, (v1, v2) -> v2));
        iterator = dataList.iterator();
        ArrayList<CallSite> dbCheckItemList = new ArrayList<CallSite>();
        ArrayList<CallSite> dbCheckItemTextList = new ArrayList<CallSite>();
        HashMap<String, Dict> newDictMap = new HashMap<String, Dict>();
        HashSet i18NameList = Sets.newHashSet();
        while (iterator.hasNext()) {
            String dictId;
            Map data = (Map)iterator.next();
            String dictCode = (String)data.get("dictCode");
            if (!dictIdMap.containsKey(dictCode) && !newDictMap.containsKey(dictCode)) {
                String dictName = (String)data.get("dictName");
                if (CharSequenceUtil.isEmpty((CharSequence)dictName)) {
                    String msg = dictCode + I18nUtil.translate((String)"i18n_alert_JCAoIdjJCRLxOLV_f65cc591", (String)"\u5b57\u5178\u7f16\u7801\u5bf9\u5e94\u7684\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
                    this.errorAdd(excelImportDTO, msg, data);
                    iterator.remove();
                    continue;
                }
                Dict dict = new Dict();
                dict.setDictCode(dictCode);
                dict.setDictName(dictName);
                dict.setDictType(CharSequenceUtil.blankToDefault((CharSequence)((String)data.get("dictType")), (String)"user"));
                dict.setAllowAddToCompany(CharSequenceUtil.blankToDefault((CharSequence)((String)data.get("allowAddToCompany")), (String)"0"));
                dict.setElsAccount(TenantContext.getTenant());
                dict.setDescription((String)data.get("dictDescription"));
                dict.setSourceId((String)data.get("dictSourceId"));
                dict.setSourceType((String)data.get("dictSourceType"));
                dict.setSourceSystem((String)data.get("dictSourceSystem"));
                dict.setId(IdWorker.getIdStr());
                dict.setDeleted(CommonConstant.NO_0);
                newDictMap.put(dictCode, dict);
                i18NameList.add(dictName);
            }
            if (!CharSequenceUtil.isNotEmpty((CharSequence)(dictId = dictIdMap.get(dictCode)))) continue;
            String item = dictId + "_" + data.get("itemValue");
            String text = dictId + "_" + data.get("itemText");
            dbCheckItemList.add((CallSite)((Object)item));
            dbCheckItemTextList.add((CallSite)((Object)text));
        }
        if (CollUtil.isEmpty((Collection)dataList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        List<Object> dbExistDictItemList = Lists.newArrayList();
        if (CollUtil.isNotEmpty(dbCheckItemList)) {
            QueryWrapper itemWrapper = Wrappers.query();
            itemWrapper.lambda().select(new SFunction[]{DictItem::getItemValue, DictItem::getDictId});
            ((QueryWrapper)itemWrapper.in((Object)"dict_id||'_'||item_value", dbCheckItemList)).lambda().eq(DictItem::getElsAccount, (Object)TenantContext.getTenant());
            List dictItemList = this.dictItemService.list((Wrapper)itemWrapper);
            dbExistDictItemList = dictItemList.stream().map(x -> x.getDictId() + "_" + x.getItemValue()).distinct().collect(Collectors.toList());
        }
        List<Object> dbExistDictItemTextList = Lists.newArrayList();
        if (CollUtil.isNotEmpty(dbCheckItemTextList)) {
            QueryWrapper itemWrapper = Wrappers.query();
            itemWrapper.lambda().select(new SFunction[]{DictItem::getItemText, DictItem::getDictId});
            ((QueryWrapper)itemWrapper.in((Object)"dict_id||'_'||item_text", dbCheckItemTextList)).lambda().eq(DictItem::getElsAccount, (Object)TenantContext.getTenant());
            List dictItemList = this.dictItemService.list((Wrapper)itemWrapper);
            dbExistDictItemTextList = dictItemList.stream().map(x -> x.getDictId() + "_" + x.getItemText()).distinct().collect(Collectors.toList());
        }
        iterator = dataList.iterator();
        while (iterator.hasNext()) {
            Map data = (Map)iterator.next();
            String dictCode = (String)data.get("dictCode");
            String itemValue = (String)data.get("itemValue");
            String itemText = (String)data.get("itemText");
            String itemId = dictIdMap.get(dictCode) + "_" + (String)itemValue;
            if (dbExistDictItemList.contains(itemId)) {
                String msg = dictCode + I18nUtil.translate((String)"i18n_alert_JCAoIMKJCdAo_ef5d4aad", (String)"\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728\u5b57\u5178\u9879\u7f16\u7801") + ":" + (String)itemValue;
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            String textId = dictIdMap.get(dictCode) + "_" + itemText;
            if (dbExistDictItemTextList.contains(textId)) {
                String msg = dictCode + I18nUtil.translate((String)"i18n_alert_JCAoIMKJCdRL_ef581685", (String)"\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728\u5b57\u5178\u9879\u540d\u79f0") + ":" + itemText;
                this.errorAdd(excelImportDTO, msg, data);
                iterator.remove();
                continue;
            }
            i18NameList.add(itemText);
        }
        if (CollUtil.isEmpty((Collection)dataList)) {
            this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
            return dataList;
        }
        Map<String, String> i18Key = this.i18nService.checkAndAdd(Lists.newArrayList((Iterable)i18NameList), "dict");
        Collection newDictList = newDictMap.values();
        for (Dict dict : newDictList) {
            String key = i18Key.get(dict.getDictName());
            dict.setDictNameI18nKey(key);
        }
        ArrayList list = Lists.newArrayList();
        for (Map data : dataList) {
            String dictCode = (String)data.get("dictCode");
            DictItem dictItem = (DictItem)JSON.parseObject((String)JSON.toJSONString((Object)data), DictItem.class);
            String dictId = dictIdMap.get(dictCode);
            if (CharSequenceUtil.isEmpty((CharSequence)dictId)) {
                dictId = ((Dict)((Object)newDictMap.get(dictCode))).getId();
            }
            dictItem.setStatus((Integer)ObjectUtil.defaultIfNull((Object)dictItem.getStatus(), (Object)CommonConstant.STATUS_YES));
            dictItem.setSortOrder((Integer)ObjectUtil.defaultIfNull((Object)dictItem.getSortOrder(), (Object)1));
            dictItem.setElsAccount(TenantContext.getTenant());
            dictItem.setDictId(dictId);
            String key = i18Key.get(dictItem.getItemText());
            dictItem.setItemTextI18nKey(key);
            list.add(dictItem);
        }
        if (CollUtil.isNotEmpty(newDictList)) {
            this.dictService.saveBatch(newDictList);
        }
        if (CollUtil.isNotEmpty((Collection)list)) {
            this.dictItemService.saveBatch(list);
        }
        this.errorHandle(true, excelImportDTO, TenantContext.getTenant(), totalCount);
        return dataList;
    }
}

