/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.config;

import cn.hutool.core.util.StrUtil;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.ConvertUtils;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisSubInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisSubInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        if (parameter != null) {
            Field[] fields;
            if (SqlCommandType.INSERT == sqlCommandType) {
                Map map;
                if (parameter instanceof Map && (map = (Map)parameter).containsKey("list")) {
                    return invocation.proceed();
                }
                fields = ConvertUtils.getAllFields((Object)parameter);
                this.setInsertFields(fields, parameter);
            }
            if (SqlCommandType.UPDATE == sqlCommandType) {
                MapperMethod.ParamMap p;
                if (parameter instanceof MapperMethod.ParamMap && (parameter = (p = (MapperMethod.ParamMap)parameter).containsKey((Object)"et") ? p.get((Object)"et") : (p.containsKey((Object)"param1") ? p.get((Object)"param1") : (p.containsKey((Object)"param2") ? p.get((Object)"param2") : null))) == null) {
                    return invocation.proceed();
                }
                fields = ConvertUtils.getAllFields((Object)parameter);
                this.setUpdateFields(fields, parameter);
            }
        }
        return invocation.proceed();
    }

    private void setInsertFields(Field[] fields, Object parameter) {
        LoginUser sysUser = this.getLoginUser();
        boolean injectionEls = this.getInjectionEls(fields, parameter);
        Field[] var5 = fields;
        int var6 = fields.length;
        for (int var7 = 0; var7 < var6; ++var7) {
            Field field = var5[var7];
            log.debug("------field.name------" + field.getName());
            try {
                String sysOrgCode;
                Object local_sysOrgCode;
                if ("elsAccount".equals(field.getName())) {
                    this.injectionElsAccount(field, parameter, injectionEls);
                }
                if ("createBy".equals(field.getName()) || "updateBy".equals(field.getName())) {
                    field.setAccessible(true);
                    local_sysOrgCode = field.get(parameter);
                    field.setAccessible(false);
                    String string = sysOrgCode = sysUser == null ? "els" : sysUser.getSubAccount() + "_" + sysUser.getRealname();
                    if (ConvertUtils.isNotEmpty((Object)sysOrgCode)) {
                        field.setAccessible(true);
                        field.set(parameter, sysOrgCode);
                        field.setAccessible(false);
                    }
                }
                if ("createTime".equals(field.getName()) || "updateTime".equals(field.getName())) {
                    field.setAccessible(true);
                    local_sysOrgCode = field.get(parameter);
                    field.setAccessible(false);
                    if (local_sysOrgCode == null || local_sysOrgCode.equals("")) {
                        field.setAccessible(true);
                        field.set(parameter, new Date());
                        field.setAccessible(false);
                    }
                }
                if (!"sysOrgCode".equals(field.getName())) continue;
                field.setAccessible(true);
                local_sysOrgCode = field.get(parameter);
                field.setAccessible(false);
                if (local_sysOrgCode != null && !local_sysOrgCode.equals("")) continue;
                String string = sysOrgCode = sysUser == null ? "" : sysUser.getOrgCode();
                if (!ConvertUtils.isNotEmpty((Object)sysOrgCode)) continue;
                field.setAccessible(true);
                field.set(parameter, sysOrgCode);
                field.setAccessible(false);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setUpdateFields(Field[] fields, Object parameter) {
        LoginUser sysUser = this.getLoginUser();
        Field[] var4 = fields;
        int var5 = fields.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            Field field = var4[var6];
            log.debug("------field.name------" + field.getName());
            try {
                if ("updateBy".equals(field.getName()) && sysUser != null) {
                    String updateBy = sysUser.getSubAccount() + "_" + sysUser.getRealname();
                    field.setAccessible(true);
                    field.set(parameter, updateBy);
                    field.setAccessible(false);
                }
                if (!"updateTime".equals(field.getName())) continue;
                field.setAccessible(true);
                field.set(parameter, new Date());
                field.setAccessible(false);
                continue;
            }
            catch (Exception var9) {
                log.error(":::MybatisInterceptor setUpdateFields:{}", (Object)var9.getMessage());
            }
        }
    }

    private LoginUser getLoginUser() {
        try {
            return SysUtil.getLoginUser();
        }
        catch (Exception var2) {
            return null;
        }
    }

    private void injectionElsAccount(Field field, Object parameter, boolean injectionEls) throws IllegalAccessException {
        field.setAccessible(true);
        Object local_elsAccount = field.get(parameter);
        field.setAccessible(false);
        if (injectionEls && (local_elsAccount == null || local_elsAccount.equals(""))) {
            String elsAccount;
            String string = elsAccount = StrUtil.isNotBlank((CharSequence)TenantContext.getTenant()) ? TenantContext.getTenant() : "100000";
            if (ConvertUtils.isNotEmpty((Object)elsAccount)) {
                field.setAccessible(true);
                field.set(parameter, elsAccount);
                field.setAccessible(false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getInjectionEls(Field[] fields, Object parameter) {
        Field[] var3 = fields;
        int var4 = fields.length;
        for (int var5 = 0; var5 < var4; ++var5) {
            boolean var8;
            Field field = var3[var5];
            if (!"injectionEls".equals(field.getName())) continue;
            try {
                boolean var7;
                field.setAccessible(true);
                boolean bl = var7 = ((Boolean)field.get(parameter)).booleanValue();
                return bl;
            }
            catch (IllegalAccessException var12) {
                var8 = true;
            }
            finally {
                field.setAccessible(false);
            }
            return var8;
        }
        return true;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

