/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.adapter;

import com.els.common.aspect.annotation.RpcService;
import com.els.common.enumerate.AuditStatusEnum;
import com.els.common.util.SrmUtil;
import com.els.modules.contract.entity.PurchaseContractHead;
import com.els.modules.contract.mapper.PurchaseContractHeadMapper;
import com.els.modules.contract.service.PurchaseContractHeadService;
import com.els.modules.workflow.modules.dto.FlowCallBackDTO;
import com.els.modules.workflow.modules.rpc.WorkflowAuditOptCallBackService;
import com.els.rpc.service.InvokeAccountRpcService;
import jakarta.annotation.Resource;
import java.io.Serializable;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@RpcService(value="purchaseContractAuditDubboAdapter")
public class PurchaseContractAuditOptCallBackServiceImpl
implements WorkflowAuditOptCallBackService {
    @Resource
    private PurchaseContractHeadMapper purchaseContractHeadMapper;
    @Autowired
    private PurchaseContractHeadService purchaseContractHeadService;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;

    public void startProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue(), flowCallbackDTO);
    }

    public void createTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeTaskCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void completeProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue(), flowCallbackDTO);
    }

    public void invalidProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
    }

    public void rejectProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue(), flowCallbackDTO);
    }

    public void cancelProcessCallBack(FlowCallBackDTO flowCallbackDTO) {
        this.updateAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue(), flowCallbackDTO);
    }

    public Map<String, Object> getById(String id) {
        PurchaseContractHead head = (PurchaseContractHead)((Object)this.purchaseContractHeadService.getById((Serializable)((Object)id)));
        if (head != null) {
            return SrmUtil.toJSONObject((Object)((Object)head));
        }
        return null;
    }

    private void updateAuditStatus(String auditStatus, FlowCallBackDTO flowCallbackDTO) {
        PurchaseContractHead head = new PurchaseContractHead();
        head.setId(flowCallbackDTO.getBusinessId());
        head.setAuditStatus(auditStatus);
        head.setFlowId(flowCallbackDTO.getProcessInstanceId());
        this.purchaseContractHeadMapper.updateById((Object)head);
        if (AuditStatusEnum.AUDIT_FINISH.getValue().equals(auditStatus)) {
            this.purchaseContractHeadService.publish(flowCallbackDTO.getBusinessId());
        }
    }
}

