/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.contract.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.BusinessModule;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.validator.SrmLength;
import com.els.config.mybatis.TenantContext;
import com.els.modules.contract.entity.PurchaseContractPromise;
import com.els.modules.contract.entity.PurchasePromiseItem;
import com.els.modules.contract.entity.SaleContractPromise;
import com.els.modules.contract.enumerate.ContractPromiseStatusEnum;
import com.els.modules.contract.service.PurchaseContractPromiseService;
import com.els.modules.contract.service.PurchasePromiseItemService;
import com.els.modules.contract.service.SaleContractPromiseService;
import com.els.modules.contract.vo.PurchaseContractPromiseVO;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="\u5c65\u7ea6\u7ba1\u7406")
@RestController
@RequestMapping(value={"/contract/purchaseContractPromise"})
@BusinessModule(module="contractPromise")
public class PurchaseContractPromiseController
extends BaseController<PurchaseContractPromise, PurchaseContractPromiseService> {
    @Autowired
    private PurchaseContractPromiseService purchaseContractPromiseService;
    @Autowired
    private SaleContractPromiseService saleContractPromiseService;
    @Autowired
    private PurchasePromiseItemService purchasePromiseItemService;

    @Operation(summary="\u5206\u9875\u5217\u8868\u67e5\u8be2", description="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:list"})
    public Result<?> queryPageList(PurchaseContractPromise purchaseContractPromise, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)purchaseContractPromise), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.purchaseContractPromiseService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u5408\u540c\u5c65\u7ea6\u7ba1\u7406-\u6dfb\u52a0")
    @Operation(summary="\u6dfb\u52a0", description="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    @SrmValidated
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:add"})
    public Result<?> add(@RequestBody PurchaseContractPromise purchaseContractPromise) {
        this.purchaseContractPromiseService.savePurchaseContractPromise(purchaseContractPromise);
        return Result.ok((Object)((Object)purchaseContractPromise));
    }

    @AutoLog(value="\u5408\u540c\u5c65\u7ea6\u7ba1\u7406-\u53d1\u5e03")
    @Operation(summary="\u53d1\u5e03", description="\u53d1\u5e03")
    @PostMapping(value={"/publishEvent"})
    @SrmValidated
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:pulish"})
    public Result<?> publishEvent(@RequestBody PurchaseContractPromiseVO purchaseContractPromise) {
        PurchaseContractPromise promise = new PurchaseContractPromise();
        BeanUtils.copyProperties((Object)((Object)purchaseContractPromise), (Object)((Object)promise));
        this.purchaseContractPromiseService.updateMain(promise, purchaseContractPromise.getPurchasePromiseItemList());
        this.purchaseContractPromiseService.publishEvent(purchaseContractPromise);
        return Result.ok((Object)((Object)purchaseContractPromise));
    }

    @AutoLog(value="\u5408\u540c\u5c65\u7ea6\u7ba1\u7406-\u9000\u56de")
    @Operation(summary="\u901a\u8fc7id\u9000\u56de", description="\u901a\u8fc7id\u9000\u56de")
    @GetMapping(value={"/refund"})
    @SrmValidated
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:refund"})
    public Result<?> refund(@RequestParam(name="id", required=true) String id, @RequestParam(name="refundRemark") @SrmLength(max=1000, scopeTitle="\u9000\u56de\u5907\u6ce8", scopeI18key="") String refundRemark) {
        this.purchaseContractPromiseService.refundMain(id, refundRemark);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u5408\u540c\u5c65\u7ea6\u7ba1\u7406-\u7f16\u8f91")
    @Operation(summary="\u7f16\u8f91", description="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    @SrmValidated
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:edit"})
    public Result<?> edit(@RequestBody PurchaseContractPromiseVO purchaseContractPromise) {
        PurchaseContractPromise promise = new PurchaseContractPromise();
        BeanUtils.copyProperties((Object)((Object)purchaseContractPromise), (Object)((Object)promise));
        this.purchaseContractPromiseService.updateMain(promise, purchaseContractPromise.getPurchasePromiseItemList());
        String id = promise.getId();
        return this.queryById(id);
    }

    @AutoLog(value="\u5408\u540c\u5c65\u7ea6\u7ba1\u7406-\u901a\u8fc7id\u5220\u9664")
    @Operation(summary="\u901a\u8fc7id\u5220\u9664", description="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.purchaseContractPromiseService.delPurchaseContractPromise(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5408\u540c\u5c65\u7ea6\u7ba1\u7406-\u6279\u91cf\u5220\u9664")
    @Operation(summary="\u6279\u91cf\u5220\u9664", description="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:delete"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.purchaseContractPromiseService.delBatchPurchaseContractPromise(idList);
        return this.commonSuccessResult(4);
    }

    @Operation(summary="\u901a\u8fc7id\u67e5\u8be2", description="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:view"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PurchaseContractPromise purchaseContractPromise = (PurchaseContractPromise)((Object)this.purchaseContractPromiseService.getOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id", (Object)id)).eq((Object)"els_account", (Object)TenantContext.getTenant())));
        PurchaseContractPromiseVO purchaseContractPromiseVO = new PurchaseContractPromiseVO();
        BeanUtils.copyProperties((Object)((Object)purchaseContractPromise), (Object)((Object)purchaseContractPromiseVO));
        List<PurchasePromiseItem> purchasePromiseItemList = this.purchasePromiseItemService.selectByMainId(id);
        purchaseContractPromiseVO.setPurchasePromiseItemList(purchasePromiseItemList);
        return Result.ok((Object)((Object)purchaseContractPromiseVO));
    }

    @AutoLog(value="\u5408\u540c\u5c65\u7ea6\u7ba1\u7406-\u4f5c\u5e9f")
    @Operation(summary="\u91c7\u8d2d\u5c65\u7ea6\u5934-\u4f5c\u5e9f", description="\u91c7\u8d2d\u5408\u540c\u5934-\u4f5c\u5e9f")
    @PostMapping(value={"/cancel"})
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:cancel"})
    public Result<?> cancel(@RequestBody PurchaseContractPromise head) {
        PurchaseContractPromise purchaseContractPromise = (PurchaseContractPromise)((Object)this.purchaseContractPromiseService.getById((Serializable)((Object)head.getId())));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.purchaseContractPromiseService.lambdaUpdate().set(PurchaseContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.CANCEL.getValue())).eq(ParentEntity::getId, (Object)head.getId())).update((Object)new PurchaseContractPromise());
        if (StrUtil.isNotBlank((CharSequence)purchaseContractPromise.getRelationId())) {
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.saleContractPromiseService.lambdaUpdate().set(SaleContractPromise::getPromiseStatus, (Object)ContractPromiseStatusEnum.CANCEL.getValue())).eq(ParentEntity::getId, (Object)head.getRelationId())).update((Object)new SaleContractPromise());
        }
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u5408\u540c\u5c65\u7ea6\u7ba1\u7406-\u786e\u8ba4\u4f9b\u5e94\u5546\u5c65\u884c\u5355")
    @Operation(summary="\u786e\u8ba4\u4f9b\u5e94\u5546\u5c65\u884c\u5355", description="\u786e\u8ba4\u4f9b\u5e94\u5546\u5c65\u884c\u5355")
    @PostMapping(value={"/confirmedSupplier"})
    @SrmValidated
    @RequiresPermissions(value={"contractPromise#purchaseContractPromise:confirmedSupplier"})
    public Result<?> confirmedSupplier(@RequestBody PurchaseContractPromise purchaseContractPromise) {
        this.purchaseContractPromiseService.confirmedSupplier(purchaseContractPromise);
        return this.commonSuccessResult(3);
    }
}

