/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esign.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.config.IpaasConfig;
import com.els.modules.electronsign.esign.entity.PurchaseEsignSeals;
import com.els.modules.electronsign.esign.entity.SaleEsignSeals;
import com.els.modules.electronsign.esign.mapper.PurchaseEsignSealsMapper;
import com.els.modules.electronsign.esign.mapper.SaleEsignSealsMapper;
import com.els.modules.electronsign.esign.service.PurchaseEsignSealsService;
import com.els.modules.electronsign.esign.util.EsignFileEncryptUtil;
import com.els.modules.electronsign.esign.util.EsignResultAnalysisUtil;
import com.els.modules.electronsign.esign.vo.SealVO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PurchaseEsignSealsServiceImpl
extends BaseServiceImpl<PurchaseEsignSealsMapper, PurchaseEsignSeals>
implements PurchaseEsignSealsService {
    @Value(value="${els.path.upload}")
    private String uploadpath;
    @Autowired
    private SaleEsignSealsMapper saleEsignSealsMapper;
    @Autowired
    private InvokeBaseRpcService invokeBaseRpcService;
    private Map<String, String> configMap = ((IpaasConfig)SpringContextUtils.getBean(IpaasConfig.class)).getConfig();
    private String service = this.configMap.get("service");

    @Override
    public void savePurchaseEsignSeals(PurchaseEsignSeals purchaseEsignSeals) {
        purchaseEsignSeals.setBusAccount("100000");
        this.save((Object)purchaseEsignSeals);
    }

    @Override
    public void updatePurchaseEsignSeals(PurchaseEsignSeals purchaseEsignSeals) {
        ((PurchaseEsignSealsMapper)this.baseMapper).updateById((Object)purchaseEsignSeals);
    }

    @Override
    public void delPurchaseEsignSeals(String id) {
        ((PurchaseEsignSealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void delBatchPurchaseEsignSeals(List<String> idList) {
        ((PurchaseEsignSealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void send(PurchaseEsignSeals seals) {
        seals.setSendStatus("1");
        SaleEsignSeals saleEsignSeals = (SaleEsignSeals)((Object)SysUtil.copyProperties((Object)((Object)seals), SaleEsignSeals.class));
        saleEsignSeals.setElsAccount(saleEsignSeals.getToElsAccount());
        saleEsignSeals.setToElsAccount(seals.getElsAccount());
        saleEsignSeals.setRelationId(seals.getId());
        saleEsignSeals.setId(null);
        this.saleEsignSealsMapper.insert((Object)saleEsignSeals);
        seals.setRelationId(saleEsignSeals.getId());
        this.updateById((Object)seals);
    }

    @Override
    public Result<?> uploadToEsign(PurchaseEsignSeals seals) {
        if (StrUtil.isNotBlank((CharSequence)seals.getId())) {
            this.updatePurchaseEsignSeals(seals);
        } else {
            this.savePurchaseEsignSeals(seals);
        }
        Result<?> response = null;
        if (StrUtil.isBlank((CharSequence)seals.getSealId())) {
            File file = new File(this.uploadpath + seals.getFilePath());
            if (file.exists() && file.isFile() && file.length() > 0x100000L) {
                return Result.error((String)(I18nUtil.translate((String)"i18n_alert_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25\uff1a") + I18nUtil.translate((String)"i18n_field_QIfXxOBR_f2502a49", (String)"\u6587\u4ef6\u5927\u5c0f\u4e0d\u80fd\u8d85\u8fc7") + " 1M"));
            }
            String data = null;
            if (file.exists()) {
                data = EsignFileEncryptUtil.fileToBase64(this.uploadpath + seals.getFilePath());
            } else {
                try {
                    data = EsignFileEncryptUtil.GetUrlImageToBase64(seals.getFilePath().toString());
                }
                catch (Exception e) {
                    return Result.error((String)I18nUtil.translate((String)"i18n_alert_XVKmWWePOIH_31bf6c3f", (String)"\u4e0a\u4f20\u5931\u8d25:\u5370\u7ae0\u56fe\u7247\u5f02\u5e38"));
                }
            }
            SealVO sealVO = new SealVO(seals, data);
            JSONObject requestJSON = new JSONObject();
            JSONObject bascis = new JSONObject();
            if ("1".equals(seals.getSealType())) {
                bascis.put("accountId", (Object)seals.getOrgId());
            } else {
                bascis.put("accountId", (Object)seals.getAccountId());
            }
            requestJSON.put("base", (Object)bascis);
            requestJSON.put("body", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)sealVO)));
            JSONObject object = this.invokeBaseRpcService.callIPaasInterface(requestJSON, this.service, this.invokeBaseRpcService.getIpaasInterfaceCode("create-person-or-org-seal-image"));
            response = EsignResultAnalysisUtil.analysisResult(object);
            if (response.isSuccess()) {
                JSONObject jsonObject = (JSONObject)response.getResult();
                seals.setSealId(jsonObject.getString("sealId"));
                seals.setUploaded("1");
                this.updatePurchaseEsignSeals(seals);
                return Result.ok((String)I18nUtil.translate((String)"i18n_alert_XVLR_24aeb765", (String)"\u4e0a\u4f20\u6210\u529f\uff01"));
            }
            return Result.error((String)(I18nUtil.translate((String)"i18n_alert_XVKm_24addeea", (String)"\u4e0a\u4f20\u5931\u8d25:") + response.getMessage()));
        }
        return Result.error((String)I18nUtil.translate((String)"i18n_alert_WeIXV_d10ea058", (String)"\u5370\u7ae0\u5df2\u4e0a\u4f20"));
    }
}

