/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.dto.FadadaCreateMemberDTO;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaOrg;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaOrgPsn;
import com.els.modules.electronsign.fadada.entity.PurchaseFadadaPersonal;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaOrgMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaOrgPsnMapper;
import com.els.modules.electronsign.fadada.mapper.PurchaseFadadaPersonalMapper;
import com.els.modules.electronsign.fadada.service.PurchaseFadadaOrgPsnService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaseFadadaOrgPsnServiceImpl
extends BaseServiceImpl<PurchaseFadadaOrgPsnMapper, PurchaseFadadaOrgPsn>
implements PurchaseFadadaOrgPsnService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;
    @Autowired
    private PurchaseFadadaPersonalMapper purchaseFadadaPersonalMapper;
    @Autowired
    private PurchaseFadadaOrgMapper purchaseFadadaOrgMapper;

    @Override
    public void add(PurchaseFadadaOrgPsn purchaseFadadaOrgPsn) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"client_user_id", (Object)purchaseFadadaOrgPsn.getClientUserId());
        queryWrapper.eq((Object)"client_corp_id", (Object)purchaseFadadaOrgPsn.getClientCorpId());
        if (!this.list((Wrapper)queryWrapper).isEmpty()) {
            throw new ELSBootException(purchaseFadadaOrgPsn.getOrgName() + " \u673a\u6784\u5df2\u7ecf\u5b58\u5728 " + purchaseFadadaOrgPsn.getMemberName());
        }
        String elsAccount = TenantContext.getTenant();
        QueryWrapper purchaseFadadaPersonalQueryWrapper = new QueryWrapper();
        purchaseFadadaPersonalQueryWrapper.eq((Object)"els_account", (Object)elsAccount);
        purchaseFadadaPersonalQueryWrapper.eq((Object)"client_user_id", (Object)purchaseFadadaOrgPsn.getClientUserId());
        PurchaseFadadaPersonal personal = (PurchaseFadadaPersonal)((Object)this.purchaseFadadaPersonalMapper.selectOne((Wrapper)purchaseFadadaPersonalQueryWrapper));
        if (personal == null) {
            throw new ELSBootException("\u8bf7\u9009\u62e9\u5458\u5de5");
        }
        purchaseFadadaOrgPsn.setMemberStatus("enable");
        purchaseFadadaOrgPsn.setActive("0");
        purchaseFadadaOrgPsn.setOpenUserId(personal.getOpenUserId());
        QueryWrapper purchaseFadadaOrgQueryWrapper = new QueryWrapper();
        purchaseFadadaOrgQueryWrapper.eq((Object)"els_account", (Object)elsAccount);
        purchaseFadadaOrgQueryWrapper.eq((Object)"client_corp_id", (Object)purchaseFadadaOrgPsn.getClientCorpId());
        PurchaseFadadaOrg purchaseFadadaOrg = (PurchaseFadadaOrg)((Object)this.purchaseFadadaOrgMapper.selectOne((Wrapper)purchaseFadadaOrgQueryWrapper));
        if (purchaseFadadaOrg == null) {
            throw new ELSBootException("\u8bf7\u9009\u62e9\u673a\u6784");
        }
        purchaseFadadaOrgPsn.setOpenCorpId(purchaseFadadaOrg.getOpenCorpId());
        FadadaCreateMemberDTO fadadaCreateMemberDTO = new FadadaCreateMemberDTO(purchaseFadadaOrgPsn, personal.getAccountType());
        String requestStr = JSONObject.toJSONString((Object)fadadaCreateMemberDTO);
        JSONObject response = this.fadadaCallUtil.call(requestStr, "fadada_create_member");
        JSONArray array = response.getJSONArray("data");
        JSONObject memberObject = JSONArray.parseObject((String)array.get(0).toString());
        purchaseFadadaOrgPsn.setMemberId(memberObject.getString("memberId"));
        purchaseFadadaOrgPsn.setMemberActiveUrl(memberObject.getString("memberActiveUrl"));
        purchaseFadadaOrgPsn.setMemberActiveEmbedUrl(memberObject.getString("memberActiveEmbedUrl"));
        if ("activated".equals(memberObject.getString("memberStatus"))) {
            purchaseFadadaOrgPsn.setActive("1");
        }
        this.save((Object)purchaseFadadaOrgPsn);
    }

    @Override
    public void edit(PurchaseFadadaOrgPsn purchaseFadadaOrgPsn) {
        if (StrUtil.isBlank((CharSequence)purchaseFadadaOrgPsn.getId())) {
            this.add(purchaseFadadaOrgPsn);
        } else {
            int count = ((PurchaseFadadaOrgPsnMapper)this.baseMapper).updateById((Object)purchaseFadadaOrgPsn);
            Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
        }
    }

    @Override
    public void delete(String id) {
        PurchaseFadadaOrgPsn purchaseFadadaOrgPsn = (PurchaseFadadaOrgPsn)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)purchaseFadadaOrgPsn.getMemberId())) {
            JSONObject request = new JSONObject();
            request.put("openCorpId", (Object)purchaseFadadaOrgPsn.getOpenCorpId());
            String[] memberIds = new String[]{purchaseFadadaOrgPsn.getMemberId()};
            request.put("memberIds", (Object)memberIds);
            JSONObject response = this.fadadaCallUtil.call(request.toJSONString(), "fadada_delete_member");
            ((PurchaseFadadaOrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        } else {
            ((PurchaseFadadaOrgPsnMapper)this.baseMapper).deleteById((Serializable)((Object)id));
        }
    }

    @Override
    public void deleteBatch(List<String> idList) {
        for (String id : idList) {
            this.delete(id);
        }
    }

    @Override
    public void disabled(String id, String status) {
        PurchaseFadadaOrgPsn purchaseFadadaOrgPsn = (PurchaseFadadaOrgPsn)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.isNotBlank((CharSequence)purchaseFadadaOrgPsn.getMemberId())) {
            JSONObject request = new JSONObject();
            request.put("openCorpId", (Object)purchaseFadadaOrgPsn.getOpenCorpId());
            String[] memberIds = new String[]{purchaseFadadaOrgPsn.getMemberId()};
            request.put("memberIds", (Object)memberIds);
            request.put("memberStatus", (Object)status);
            this.fadadaCallUtil.call(request.toJSONString(), "fadada_set_member_status");
            purchaseFadadaOrgPsn.setMemberStatus(status);
            if (!"enable".equals(status)) {
                purchaseFadadaOrgPsn.setMemberStatus("disabled");
            }
            this.updateById((Object)purchaseFadadaOrgPsn);
        }
    }

    @Override
    public void refreshOrgPsnList(String id) {
        PurchaseFadadaOrg purchaseFadadaOrg = (PurchaseFadadaOrg)((Object)this.purchaseFadadaOrgMapper.selectById((Serializable)((Object)id)));
        if (purchaseFadadaOrg != null) {
            JSONObject requestObject = new JSONObject();
            requestObject.put("openCorpId", (Object)purchaseFadadaOrg.getOpenCorpId());
            requestObject.put("currentAccount", (Object)purchaseFadadaOrg.getElsAccount());
            JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_list_member");
            if (StrUtil.isNotBlank((CharSequence)response.getString("employeeInfos"))) {
                JSONArray employeeInfos = response.getJSONArray("employeeInfos");
                ArrayList<PurchaseFadadaOrgPsn> fadadaOrgPsns = new ArrayList<PurchaseFadadaOrgPsn>();
                ArrayList<String> existOrgPsnIds = new ArrayList<String>();
                for (Object object : employeeInfos) {
                    JSONObject memberObject = JSONObject.parseObject((String)object.toString());
                    PurchaseFadadaOrgPsn fadadaOrgPsn = (PurchaseFadadaOrgPsn)((Object)SysUtil.copyProperties((Object)memberObject, PurchaseFadadaOrgPsn.class));
                    QueryWrapper orgPsnQueryWrapper = new QueryWrapper();
                    orgPsnQueryWrapper.eq((Object)"member_id", (Object)memberObject.getString("memberId"));
                    orgPsnQueryWrapper.eq((Object)"open_corp_id", (Object)purchaseFadadaOrg.getOpenCorpId());
                    orgPsnQueryWrapper.eq((Object)"els_account", (Object)purchaseFadadaOrg.getElsAccount());
                    List purchaseFadadaOrgPsnList = this.list((Wrapper)orgPsnQueryWrapper);
                    if (!purchaseFadadaOrgPsnList.isEmpty()) {
                        fadadaOrgPsn.setClientUserId(((PurchaseFadadaOrgPsn)((Object)purchaseFadadaOrgPsnList.get(0))).getClientUserId());
                        fadadaOrgPsn.setOpenUserId(((PurchaseFadadaOrgPsn)((Object)purchaseFadadaOrgPsnList.get(0))).getOpenUserId());
                        fadadaOrgPsn.setId(((PurchaseFadadaOrgPsn)((Object)purchaseFadadaOrgPsnList.get(0))).getId());
                        existOrgPsnIds.add(((PurchaseFadadaOrgPsn)((Object)purchaseFadadaOrgPsnList.get(0))).getId());
                    }
                    fadadaOrgPsn.setElsAccount(purchaseFadadaOrg.getElsAccount());
                    fadadaOrgPsn.setClientCorpId(purchaseFadadaOrg.getClientCorpId());
                    fadadaOrgPsn.setOpenCorpId(purchaseFadadaOrg.getOpenCorpId());
                    fadadaOrgPsn.setOrgName(purchaseFadadaOrg.getCorpName());
                    if ("activated".equals(fadadaOrgPsn.getMemberStatus())) {
                        fadadaOrgPsn.setActive("1");
                    }
                    fadadaOrgPsn.setMemberDeptids(this.fadadaCallUtil.arrayToString(memberObject.getJSONArray("memberDeptIds")));
                    fadadaOrgPsn.setRoleType(this.fadadaCallUtil.arrayToString(memberObject.getJSONArray("roleType")));
                    fadadaOrgPsns.add(fadadaOrgPsn);
                }
                if (fadadaOrgPsns.size() > 0) {
                    QueryWrapper orgPsnQueryWrapper = new QueryWrapper();
                    orgPsnQueryWrapper.eq((Object)"open_corp_id", (Object)purchaseFadadaOrg.getOpenCorpId());
                    orgPsnQueryWrapper.eq((Object)"els_account", (Object)purchaseFadadaOrg.getElsAccount());
                    if (existOrgPsnIds.size() > 0) {
                        orgPsnQueryWrapper.notIn((Object)"id", existOrgPsnIds);
                    }
                    this.remove((Wrapper)orgPsnQueryWrapper);
                    this.saveOrUpdateBatch(fadadaOrgPsns);
                }
            }
        }
    }
}

