/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.fadada.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.fadada.dto.FadadaGetPersonAuthUrlDTO;
import com.els.modules.electronsign.fadada.entity.SaleFadadaPersonal;
import com.els.modules.electronsign.fadada.mapper.SaleFadadaPersonalMapper;
import com.els.modules.electronsign.fadada.service.SaleFadadaPersonalService;
import com.els.modules.electronsign.fadada.util.FadadaCallUtil;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleFadadaPersonalServiceImpl
extends BaseServiceImpl<SaleFadadaPersonalMapper, SaleFadadaPersonal>
implements SaleFadadaPersonalService {
    @Autowired
    private FadadaCallUtil fadadaCallUtil;

    @Override
    public void add(SaleFadadaPersonal saleFadadaPersonal) {
        if ("mobile".equals(saleFadadaPersonal.getAccountType())) {
            saleFadadaPersonal.setAccountName(saleFadadaPersonal.getMobile());
        } else {
            saleFadadaPersonal.setAccountName(saleFadadaPersonal.getEmail());
        }
        this.saveFlag(saleFadadaPersonal);
        this.save((Object)saleFadadaPersonal);
    }

    public void saveFlag(SaleFadadaPersonal saleFadadaPersonal) {
        QueryWrapper saleFadadaPersonalQueryWrapper = new QueryWrapper();
        saleFadadaPersonalQueryWrapper.eq((Object)"sub_account", (Object)saleFadadaPersonal.getSubAccount());
        saleFadadaPersonalQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaPersonal.getBusAccount());
        saleFadadaPersonalQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        if (this.getOne((Wrapper)saleFadadaPersonalQueryWrapper) != null) {
            throw new ELSBootException(saleFadadaPersonal.getSubAccount() + "\u7ed1\u5b9a\u7684\u6388\u6743\u7528\u6237\u5df2\u7ecf\u88ab\u521b\u5efa\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa\uff01");
        }
        saleFadadaPersonal.setClientUserId(saleFadadaPersonal.getAccountName());
    }

    @Override
    public void edit(SaleFadadaPersonal saleFadadaPersonal) {
        if ("mobile".equals(saleFadadaPersonal.getAccountType())) {
            saleFadadaPersonal.setAccountName(saleFadadaPersonal.getMobile());
        } else {
            saleFadadaPersonal.setAccountName(saleFadadaPersonal.getEmail());
        }
        this.editFlag(saleFadadaPersonal);
        int count = ((SaleFadadaPersonalMapper)this.baseMapper).updateById((Object)saleFadadaPersonal);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    public void editFlag(SaleFadadaPersonal saleFadadaPersonal) {
        QueryWrapper saleFadadaPersonalQueryWrapper = new QueryWrapper();
        saleFadadaPersonalQueryWrapper.eq((Object)"sub_account", (Object)saleFadadaPersonal.getSubAccount());
        saleFadadaPersonalQueryWrapper.eq((Object)"bus_account", (Object)saleFadadaPersonal.getBusAccount());
        saleFadadaPersonalQueryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        SaleFadadaPersonal personal = (SaleFadadaPersonal)((Object)this.getOne((Wrapper)saleFadadaPersonalQueryWrapper));
        if (personal != null && !saleFadadaPersonal.getId().equals(personal.getId())) {
            throw new ELSBootException(saleFadadaPersonal.getSubAccount() + "\u7ed1\u5b9a\u7684\u6388\u6743\u7528\u6237\u5df2\u88ab\u521b\u5efa\uff0c\u53ef\u6362\u5176\u4ed6\u5b50\u8d26\u53f7");
        }
        saleFadadaPersonal.setClientUserId(saleFadadaPersonal.getAccountName());
    }

    @Override
    public void delete(String id) {
        ((SaleFadadaPersonalMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleFadadaPersonalMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void auth(SaleFadadaPersonal saleFadadaPersonal) {
        if ("mobile".equals(saleFadadaPersonal.getAccountType())) {
            saleFadadaPersonal.setAccountName(saleFadadaPersonal.getMobile());
        } else {
            saleFadadaPersonal.setAccountName(saleFadadaPersonal.getEmail());
        }
        if (StrUtil.isNotBlank((CharSequence)saleFadadaPersonal.getId())) {
            this.editFlag(saleFadadaPersonal);
        } else {
            this.saveFlag(saleFadadaPersonal);
        }
        String redirectUrl = this.fadadaCallUtil.getRedirectUrl();
        FadadaGetPersonAuthUrlDTO fadadaGetPersonAuthUrlDTO = new FadadaGetPersonAuthUrlDTO(saleFadadaPersonal, redirectUrl);
        String requestStr = JSONObject.toJSONString((Object)fadadaGetPersonAuthUrlDTO);
        JSONObject requestObject = JSONObject.parseObject((String)requestStr);
        requestObject.put("currentAccount", (Object)saleFadadaPersonal.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_personal_auth_url");
        if ("210002".equals(response.getString("code"))) {
            saleFadadaPersonal.setAuthFailedReason("exist");
            this.getAuthInfo(saleFadadaPersonal);
        } else {
            saleFadadaPersonal.setAuthUrl(response.getString("authUrl"));
            ((SaleFadadaPersonalMapper)this.baseMapper).updateById((Object)saleFadadaPersonal);
        }
    }

    @Override
    public void updateAuthStatus(SaleFadadaPersonal saleFadadaPersonal) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("clientUserId", (Object)saleFadadaPersonal.getClientUserId());
        requestObject.put("currentAccount", (Object)saleFadadaPersonal.getBusAccount());
        JSONObject response = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_personal_auth_info");
        saleFadadaPersonal.setAuthResult(response.getString("bindingStatus"));
        saleFadadaPersonal.setIdentProcessStatus(response.getString("identStatus"));
        saleFadadaPersonal.setAvailableStatus(response.getString("availableStatus"));
        this.updateById((Object)saleFadadaPersonal);
    }

    @Override
    public void getAuthInfo(SaleFadadaPersonal saleFadadaPersonal) {
        JSONObject requestObject = new JSONObject();
        requestObject.put("clientUserId", (Object)saleFadadaPersonal.getClientUserId());
        requestObject.put("currentAccount", (Object)saleFadadaPersonal.getBusAccount());
        JSONObject authInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_personal_auth_info");
        saleFadadaPersonal.setClientUserId(authInfo.getString("clientUserId"));
        saleFadadaPersonal.setOpenUserId(authInfo.getString("openUserId"));
        saleFadadaPersonal.setAuthResult(authInfo.getString("bindingStatus"));
        saleFadadaPersonal.setIdentProcessStatus(authInfo.getString("identStatus"));
        saleFadadaPersonal.setAvailableStatus(authInfo.getString("availableStatus"));
        if (StrUtil.isNotBlank((CharSequence)authInfo.getString("authScope"))) {
            JSONArray array = authInfo.getJSONArray("authScope");
            for (Object object : array) {
                this.log.debug(object.toString());
            }
        }
        requestObject = new JSONObject();
        requestObject.put("openUserId", (Object)saleFadadaPersonal.getOpenUserId());
        requestObject.put("currentAccount", (Object)saleFadadaPersonal.getBusAccount());
        JSONObject identInfo = this.fadadaCallUtil.call(requestObject.toJSONString(), "fadada_get_personal_ident_info");
        saleFadadaPersonal.setIdentMethod(identInfo.getString("identMethod"));
        JSONObject userIdentInfo = identInfo.getJSONObject("userIdentInfo");
        saleFadadaPersonal.setUserName(userIdentInfo.getString("userName"));
        saleFadadaPersonal.setUserIdentType(userIdentInfo.getString("identType"));
        saleFadadaPersonal.setUserIdentNo(userIdentInfo.getString("identNo"));
        JSONObject userIdentInfoExtend = identInfo.getJSONObject("userIdentInfoExtend");
        saleFadadaPersonal.setBankAccountNo(userIdentInfoExtend.getString("userIdentInfoExtend"));
        saleFadadaPersonal.setMobile(userIdentInfoExtend.getString("mobile"));
        saleFadadaPersonal.setAuthFailedReason("");
        this.updateById((Object)saleFadadaPersonal);
    }
}

