/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.electronsign.esignv3.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.system.base.entity.ParentEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.electronsign.config.EsignV3Properties;
import com.els.modules.electronsign.enums.SealsTypeEnum;
import com.els.modules.electronsign.esign.enumerate.EsignRoleTypeEnum;
import com.els.modules.electronsign.esignv3.dto.CallBackDto;
import com.els.modules.electronsign.esignv3.dto.OrgPsnQueryRq;
import com.els.modules.electronsign.esignv3.dto.OrgSealsAuthQueryRp;
import com.els.modules.electronsign.esignv3.dto.OrgSealsQueryRp;
import com.els.modules.electronsign.esignv3.dto.SealsAuthRq;
import com.els.modules.electronsign.esignv3.dto.SealsOrgAuthRq;
import com.els.modules.electronsign.esignv3.dto.SealsRp;
import com.els.modules.electronsign.esignv3.dto.SealsRq;
import com.els.modules.electronsign.esignv3.entity.EsignV3SealsAuth;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Org;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Personal;
import com.els.modules.electronsign.esignv3.entity.SaleEsignV3Seals;
import com.els.modules.electronsign.esignv3.enums.SealAuthStatusEnum;
import com.els.modules.electronsign.esignv3.enums.SealCallBackEnum;
import com.els.modules.electronsign.esignv3.enums.SealRoleEnum;
import com.els.modules.electronsign.esignv3.enums.SealStatusEnum;
import com.els.modules.electronsign.esignv3.mapper.SaleEsignV3SealsMapper;
import com.els.modules.electronsign.esignv3.service.EsignV3SealsAuthService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3OrgService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3PersonalService;
import com.els.modules.electronsign.esignv3.service.SaleEsignV3SealsService;
import com.els.modules.electronsign.util.ESignUtil;
import com.els.modules.electronsign.util.IpassUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class SaleEsignV3SealsServiceImpl
extends BaseServiceImpl<SaleEsignV3SealsMapper, SaleEsignV3Seals>
implements SaleEsignV3SealsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SaleEsignV3SealsServiceImpl.class);
    @Autowired
    private SaleEsignV3OrgService saleEsignV3OrgService;
    @Autowired
    private EsignV3SealsAuthService esignV3SealsAuthService;
    @Autowired
    private IpassUtil ipassUtil;
    @Autowired
    private EsignV3Properties esignV3Properties;
    @Autowired
    private SaleEsignV3PersonalService saleEsignV3PersonalService;
    @Value(value="${els.storage.type}")
    private String storeType;

    @Override
    public void add(SaleEsignV3Seals saleEsignV3Seals) {
        saleEsignV3Seals.setElsAccount(TenantContext.getTenant());
        this.save((Object)saleEsignV3Seals);
    }

    @Override
    public void edit(SaleEsignV3Seals saleEsignV3Seals) {
        int count = ((SaleEsignV3SealsMapper)this.baseMapper).updateById((Object)saleEsignV3Seals);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        JSONObject jSONObject;
        SealsAuthRq sealsAuthRq;
        SaleEsignV3Seals saleEsignV3Seals = (SaleEsignV3Seals)((Object)this.getById((Serializable)((Object)id)));
        if (StrUtil.equals((CharSequence)saleEsignV3Seals.getSealType(), (CharSequence)SealsTypeEnum.ORG.getCode()) && StrUtil.isNotBlank((CharSequence)saleEsignV3Seals.getSealId()) && StrUtil.isNotBlank((CharSequence)saleEsignV3Seals.getOrgId())) {
            sealsAuthRq = new SealsAuthRq();
            sealsAuthRq.setSealId(saleEsignV3Seals.getSealId());
            sealsAuthRq.setOrgId(saleEsignV3Seals.getOrgId());
            IpassUtil.setNullValue(sealsAuthRq);
            jSONObject = this.ipassUtil.sendBaseAndChangeElsAccountRequest(sealsAuthRq, "e3-seal-org-del", saleEsignV3Seals.getBusAccount(), JSONObject.class);
        }
        if (StrUtil.equals((CharSequence)saleEsignV3Seals.getSealType(), (CharSequence)SealsTypeEnum.PSN.getCode()) && StrUtil.isNotBlank((CharSequence)saleEsignV3Seals.getSealId()) && StrUtil.isNotBlank((CharSequence)saleEsignV3Seals.getPsnId())) {
            sealsAuthRq = new SealsAuthRq();
            sealsAuthRq.setSealId(saleEsignV3Seals.getSealId());
            sealsAuthRq.setPsnId(saleEsignV3Seals.getPsnId());
            IpassUtil.setNullValue(sealsAuthRq);
            jSONObject = this.ipassUtil.sendBaseAndChangeElsAccountRequest(sealsAuthRq, "e3-seal-psn-del", saleEsignV3Seals.getBusAccount(), JSONObject.class);
        }
        ((SaleEsignV3SealsMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((SaleEsignV3SealsMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public void auth(SealsAuthRq sealsAuthRq) {
    }

    @Override
    public void processCallback(JSONObject jsonObject) {
        CallBackDto.Seal callBackDto = (CallBackDto.Seal)jsonObject.toJavaObject(CallBackDto.Seal.class);
        SealCallBackEnum sealCallBackEnum = SealCallBackEnum.getByCode(callBackDto.getAction());
        SaleEsignV3Seals saleEsignV3Seals = ((SaleEsignV3SealsMapper)this.baseMapper).selectByRequestId(callBackDto.getSealId());
        if (ObjectUtil.isNotEmpty((Object)((Object)saleEsignV3Seals))) {
            this.processDb(saleEsignV3Seals, jsonObject, sealCallBackEnum);
        } else {
            try {
                for (int i = 0; i <= 4; ++i) {
                    log.info("\u7b49\u5f85\u6570\u636e\u6267\u884c,{}\u6b21", (Object)i);
                    Thread.sleep(5000L);
                    saleEsignV3Seals = ((SaleEsignV3SealsMapper)this.baseMapper).selectByRequestId(callBackDto.getSealId());
                    if (!ObjectUtil.isNotEmpty((Object)((Object)saleEsignV3Seals))) continue;
                    this.processDb(saleEsignV3Seals, jsonObject, sealCallBackEnum);
                    return;
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void uploadToEsign(SaleEsignV3Seals seals) {
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)seals.getId()), (String)I18nUtil.translate((String)"i18n_field_VWsM_40db030c", (String)"\u8bf7\u5148\u4fdd\u5b58"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)seals.getBusAccount()), (String)I18nUtil.translate((String)"i18n_alert_ICWWWeyxOLV_356925cd", (String)"\u91c7\u8d2dELS\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)seals.getSealType()), (String)I18nUtil.translate((String)"i18n_field_WeAcxOLV_d79e77f0", (String)"\u5370\u7ae0\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)seals.getSealName()), (String)I18nUtil.translate((String)"i18n_field_WeqRxOLV_725a9bc2", (String)"\u5370\u7ae0\u522b\u540d\u4e0d\u80fd\u4e3a\u7a7a"));
        SealsTypeEnum st = SealsTypeEnum.getByCode(seals.getSealType());
        Assert.isTrue((st.equals((Object)SealsTypeEnum.PSN) || StrUtil.isNotBlank((CharSequence)seals.getOrgId()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_dWtRxOLV_5390ca38", (String)"\u6240\u5c5e\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((st.equals((Object)SealsTypeEnum.ORG) || StrUtil.isNotBlank((CharSequence)seals.getPsnId()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"\u5370\u7ae0\u6240\u5c5e\u4eba\u4e0d\u80fd\u4e3a\u7a7a", (String)"\u5370\u7ae0\u6240\u5c5e\u4eba\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)seals.getSealWidth(), (String)I18nUtil.translate((String)"i18n_field_WeVzxOLV_5c72d389", (String)"\u5370\u7ae0\u5bbd\u5ea6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.notNull((Object)seals.getSealHeight(), (String)I18nUtil.translate((String)"i18n_field_WexzxOLV_bd4cd4e", (String)"\u5370\u7ae0\u9ad8\u5ea6\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)seals.getSealBizType()), (String)I18nUtil.translate((String)"i18n_field_WeESAcxOLV_96c47277", (String)"\u5370\u7ae0\u4e1a\u52a1\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a"));
        String filePath = seals.getFilePath();
        Assert.notNull((Object)filePath, (String)I18nUtil.translate((String)"i18n_field_POnRxOLV_a32d3269", (String)"\u56fe\u7247\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a"));
        Assert.isTrue((!StrUtil.equals((CharSequence)"1", (CharSequence)seals.getManualAudit()) || StrUtil.isNotBlank((CharSequence)seals.getSealMaterialPaths()) ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_field_AKQLRUnLKKWeqpnLxOLV_8a71fd81", (String)"\u5f53\u662f\u5426\u4eba\u5de5\u5ba1\u6838\u4e3a\u662f\u65f6\uff0c\u5370\u7ae0\u5907\u6848\u6750\u6599\u4e0d\u80fd\u4e3a\u7a7a"));
        SealsRq sealsRq = new SealsRq();
        BeanUtil.copyProperties((Object)((Object)seals), (Object)sealsRq, (String[])new String[0]);
        sealsRq.setSealImageFileKey(this.ipassUtil.uploadFileToEsignV3GetFileKey(filePath, seals.getBusAccount()));
        sealsRq.setManualAudit(StrUtil.equals((CharSequence)"1", (CharSequence)seals.getManualAudit()));
        if (StrUtil.isNotBlank((CharSequence)seals.getSealMaterialPaths())) {
            ArrayList sealFilingMaterials = Lists.newArrayList();
            for (String sealMaterialPath : seals.getSealMaterialPaths().split(",")) {
                sealFilingMaterials.add(this.ipassUtil.uploadFileToEsignV3GetFileKey(sealMaterialPath, seals.getBusAccount()));
            }
            seals.setSealFilingMaterials(sealFilingMaterials.stream().collect(Collectors.joining(",")));
            sealsRq.setSealFilingMaterials(sealFilingMaterials);
        }
        IpassUtil.setNullValue(sealsRq);
        SealsRp sealsRp = this.ipassUtil.sendRequestAndChangeElsAccountRequest(sealsRq, st.getIpassCode(), seals.getBusAccount(), SealsRp.class);
        seals.setSealId(sealsRp.getSealId());
        seals.setSealStatus(SealStatusEnum.BE_AUDIT.getCode());
        this.ipassUtil.callIpassCreateBack(seals.getBusAccount(), seals.getSealId(), this.esignV3Properties.getCallBackUrl() + "/esignv3/saleEsignV3Seals/noToken/callback", null);
        this.updateById((Object)seals);
    }

    @Override
    public IPage<SaleEsignV3Seals> getSignSeal(Page<SaleEsignV3Seals> page, String orgId, String psnId, String sealType, String keyWord) {
        SaleEsignV3Org org = this.saleEsignV3OrgService.getByOrgId(orgId);
        Assert.notNull((Object)((Object)org), (String)I18nUtil.translate((String)"i18n_field_VnKIdtRVH_3e1b20d0", (String)"\u8bf7\u6838\u5b9e\u5bf9\u5e94\u673a\u6784\u4fe1\u606f"));
        if (org.getPsnId().equals(psnId)) {
            return ((SaleEsignV3SealsMapper)this.baseMapper).selectPage((IPage)page, (Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Seals::getOrgId, (Object)orgId)).eq(SaleEsignV3Seals::getSealStatus, (Object)"1"));
        }
        return ((SaleEsignV3SealsMapper)this.baseMapper).getSignSeal(page, orgId, psnId, sealType, keyWord);
    }

    @Override
    public SaleEsignV3Seals orgAuth(SealsOrgAuthRq rq) {
        SaleEsignV3Seals saleEsignV3Seals = (SaleEsignV3Seals)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Seals::getSealId, (Object)rq.getSealId()), false));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)saleEsignV3Seals)), (String)"saleEsignV3Seals is null");
        SaleEsignV3Org org = this.saleEsignV3OrgService.getByOrgId(saleEsignV3Seals.getOrgId());
        rq.setOrgId(saleEsignV3Seals.getOrgId());
        rq.setTransactorPsnId(org.getPsnId());
        rq.setEffectiveTime(rq.getEffectiveTimeDate().getTime());
        rq.setExpireTime(rq.getExpireTimeDate().getTime());
        JSONObject jsonObject = this.ipassUtil.sendRequestAndChangeElsAccountRequest(rq, "e3-seal-org-qqt-auth", saleEsignV3Seals.getBusAccount(), JSONObject.class);
        saleEsignV3Seals.setAuthorizationSignUrl(jsonObject.getString("authorizationSignUrl"));
        saleEsignV3Seals.setEffectiveTime(rq.getEffectiveTimeDate());
        saleEsignV3Seals.setExpireTime(rq.getExpireTimeDate());
        this.updateById((Object)saleEsignV3Seals);
        return saleEsignV3Seals;
    }

    @Override
    public SaleEsignV3Seals getBySealId(String sealId) {
        SaleEsignV3Seals saleEsignV3Seals = (SaleEsignV3Seals)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Seals::getSealId, (Object)sealId), false));
        return saleEsignV3Seals;
    }

    @Override
    public void synchronizeSeals(String ids) {
        int pageSize = 20;
        block2: for (String id : ids.split(",")) {
            SaleEsignV3Org org = (SaleEsignV3Org)((Object)this.saleEsignV3OrgService.getById((Serializable)((Object)id)));
            OrgPsnQueryRq orgPsnQueryRq = new OrgPsnQueryRq();
            orgPsnQueryRq.setOrgId(org.getOrgId());
            int i = 1;
            while (true) {
                orgPsnQueryRq.setPageSize(20);
                orgPsnQueryRq.setPageNum(i);
                OrgSealsQueryRp rp = this.ipassUtil.sendBaseAndChangeElsAccountRequest(orgPsnQueryRq, "e3-seal-org-list", org.getBusAccount(), OrgSealsQueryRp.class);
                block4: for (OrgSealsQueryRp.Seals seal : rp.getSeals()) {
                    SaleEsignV3Seals saleEsignV3Seals = (SaleEsignV3Seals)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Seals::getSealId, (Object)seal.getSealId()), false));
                    if (ObjectUtil.isEmpty((Object)((Object)saleEsignV3Seals))) {
                        saleEsignV3Seals = new SaleEsignV3Seals();
                        BeanUtil.copyProperties((Object)seal, (Object)((Object)saleEsignV3Seals), (String[])new String[0]);
                        saleEsignV3Seals.setElsAccount(org.getElsAccount());
                        saleEsignV3Seals.setBusAccount(org.getBusAccount());
                        saleEsignV3Seals.setSealType(SealsTypeEnum.ORG.getCode());
                        saleEsignV3Seals.setOrgId(org.getOrgId());
                        saleEsignV3Seals.setOrgName(org.getOrgName());
                        try {
                            InputStream inputStream = IpassUtil.getInputStreamFromUrl(seal.getSealImageDownloadUrl());
                            URI uri = new URI(seal.getSealImageDownloadUrl());
                            String path = uri.getPath();
                            Path filePath = Paths.get(path, new String[0]);
                            String fileName = filePath.getFileName().toString();
                            saleEsignV3Seals.setFilePath(ESignUtil.saveFileGetPath(inputStream.readAllBytes(), fileName, this.storeType));
                        }
                        catch (Exception e) {
                            log.error("\u4fdd\u5b58e\u7b7e\u5b9d\u56fe\u7247\u5f02\u5e38", (Throwable)e);
                            saleEsignV3Seals.setFilePath(seal.getSealImageDownloadUrl());
                        }
                        this.save((Object)saleEsignV3Seals);
                    }
                    OrgPsnQueryRq orgPsnQueryAuthRq = new OrgPsnQueryRq();
                    int authNum = 1;
                    while (true) {
                        orgPsnQueryAuthRq.setPageSize(20);
                        orgPsnQueryAuthRq.setPageNum(authNum);
                        orgPsnQueryAuthRq.setSealId(seal.getSealId());
                        orgPsnQueryAuthRq.setOrgId(org.getOrgId());
                        OrgSealsAuthQueryRp authRp = this.ipassUtil.sendBaseAndChangeElsAccountRequest(orgPsnQueryAuthRq, "e3-seal-org-auth-list", org.getBusAccount(), OrgSealsAuthQueryRp.class);
                        this.esignV3SealsAuthService.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EsignV3SealsAuth::getSealId, (Object)seal.getSealId())).eq(ParentEntity::getElsAccount, (Object)org.getElsAccount()));
                        ArrayList adds = Lists.newArrayList();
                        for (OrgSealsAuthQueryRp.SealsAuth auth : authRp.getSealAuthorizedInfos()) {
                            if (!StrUtil.equals((CharSequence)auth.getSealId(), (CharSequence)seal.getSealId())) continue;
                            EsignV3SealsAuth esignV3SealsAuth = new EsignV3SealsAuth();
                            esignV3SealsAuth.setElsAccount(org.getElsAccount());
                            esignV3SealsAuth.setSealId(seal.getSealId());
                            esignV3SealsAuth.setSealName(seal.getSealName());
                            esignV3SealsAuth.setOrgId(org.getOrgId());
                            esignV3SealsAuth.setOrgName(org.getOrgName());
                            esignV3SealsAuth.setSealType(saleEsignV3Seals.getSealType());
                            String psnId = auth.getAuthorizedPsnId();
                            SaleEsignV3Personal psn = this.saleEsignV3PersonalService.getByPsnId(psnId, org.getElsAccount());
                            esignV3SealsAuth.setPsnId(psnId);
                            if (ObjectUtil.isNotEmpty((Object)((Object)psn))) {
                                esignV3SealsAuth.setPsnName(psn.getPsnName());
                                esignV3SealsAuth.setSubAccount(psn.getSubAccount());
                            }
                            esignV3SealsAuth.setSealRole(auth.getSealRole());
                            esignV3SealsAuth.setEffectiveTime((Date)DateUtil.date((long)auth.getEffectiveTime()));
                            esignV3SealsAuth.setExpireTime((Date)DateUtil.date((long)auth.getExpireTime()));
                            esignV3SealsAuth.setSealStatus(SealAuthStatusEnum.getByE3Code(auth.getAuthorizeStatus()).getCode());
                            esignV3SealsAuth.setRoleType(EsignRoleTypeEnum.SALE.getValue());
                            adds.add(esignV3SealsAuth);
                        }
                        if (CollUtil.isNotEmpty((Collection)adds)) {
                            this.esignV3SealsAuthService.saveBatch(adds);
                        }
                        if (ObjectUtil.isEmpty((Object)authRp.getTotal()) || authNum * 20 >= authRp.getTotal()) continue block4;
                        ++authNum;
                    }
                }
                if (ObjectUtil.isEmpty((Object)rp.getTotal()) || i * 20 >= rp.getTotal()) continue block2;
                ++i;
            }
        }
    }

    private void processDb(SaleEsignV3Seals saleEsignV3Seals, JSONObject jsonObject, SealCallBackEnum sealCallBackEnum) {
        if (ObjectUtil.isEmpty((Object)((Object)sealCallBackEnum))) {
            return;
        }
        sealCallBackEnum.processSeals(null, saleEsignV3Seals, jsonObject);
        if (sealCallBackEnum.equals((Object)SealCallBackEnum.SEAL_AUDIT)) {
            this.updateById((Object)saleEsignV3Seals);
            if (SealStatusEnum.PASS.getCode().equals(saleEsignV3Seals.getSealStatus())) {
                EsignV3SealsAuth esignV3SealsAuth;
                TenantContext.setTenant((String)saleEsignV3Seals.getElsAccount());
                SaleEsignV3Org saleEsignV3Org = (SaleEsignV3Org)((Object)this.saleEsignV3OrgService.getOne((Wrapper)Wrappers.lambdaQuery().eq(SaleEsignV3Org::getOrgId, (Object)saleEsignV3Seals.getOrgId()), false));
                if (ObjectUtil.isNotEmpty((Object)((Object)saleEsignV3Org)) && StrUtil.isNotBlank((CharSequence)saleEsignV3Org.getPsnId()) && ObjectUtil.isEmpty((Object)((Object)(esignV3SealsAuth = (EsignV3SealsAuth)((Object)this.esignV3SealsAuthService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EsignV3SealsAuth::getSealId, (Object)saleEsignV3Seals.getSealId())).eq(EsignV3SealsAuth::getOrgId, (Object)saleEsignV3Seals.getOrgId())).eq(EsignV3SealsAuth::getPsnId, (Object)saleEsignV3Org.getPsnId())).eq(ParentEntity::getElsAccount, (Object)saleEsignV3Seals.getElsAccount()))))))) {
                    esignV3SealsAuth = new EsignV3SealsAuth();
                    esignV3SealsAuth.setSealName(saleEsignV3Seals.getSealName());
                    esignV3SealsAuth.setSealId(saleEsignV3Seals.getSealId());
                    esignV3SealsAuth.setSealType(saleEsignV3Seals.getSealType());
                    esignV3SealsAuth.setOrgName(saleEsignV3Seals.getOrgName());
                    esignV3SealsAuth.setOrgId(saleEsignV3Seals.getOrgId());
                    esignV3SealsAuth.setPsnId(saleEsignV3Org.getPsnId());
                    esignV3SealsAuth.setPsnName(saleEsignV3Org.getPsnName());
                    esignV3SealsAuth.setSubAccount(saleEsignV3Org.getSubAccount());
                    esignV3SealsAuth.setSealRole(SealRoleEnum.ORG_ADMIN.getCode());
                    esignV3SealsAuth.setSealStatus(SealAuthStatusEnum.NOT_AUTH.getCode());
                    esignV3SealsAuth.setRoleType(EsignRoleTypeEnum.SALE.getValue());
                    this.esignV3SealsAuthService.save((Object)esignV3SealsAuth);
                }
                TenantContext.clear();
            }
        }
    }
}

