/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.bpmn.event;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.dto.ElsSubAccountDTO;
import com.els.modules.bpmn.event.BpmnEventHandlerImpl;
import com.els.modules.bpmn.utils.AuditAsyncEventUtils;
import com.els.modules.bpmn.utils.TaskAuditUtils;
import com.els.modules.extend.api.dto.ExtAuditOutputParamDTO;
import com.els.modules.extend.api.service.ExtAuditOptCallBackService;
import com.els.modules.extend.api.service.ExtWorkflowExecuteService;
import com.els.modules.workflow.dto.AuditEventDTO;
import com.els.modules.workflow.dto.AuditInputParamDTO;
import com.els.modules.workflow.dto.AuditOutputParamDTO;
import com.els.modules.workflow.entity.AuditConfig;
import com.els.modules.workflow.enumerate.AuditStatusEnum;
import com.els.modules.workflow.enums.WorkFlowType;
import com.els.modules.workflow.rpc.service.AuditOptCallBackService;
import com.els.modules.workflow.rpc.service.WorkflowExecuteService;
import com.els.modules.workflow.rpc.service.WorkflowInvokeAccountRpcService;
import com.pangubpm.combination.user.adapter.UserAdapter;
import com.pangubpm.combination.user.entity.UcUser;
import com.pangubpm.common.enums.BpmnActionEnum;
import com.pangubpm.common.utils.BpmnModelUtils;
import com.pangubpm.common.utils.StringUtils;
import com.pangubpm.common.utils.spring.SpringUtils;
import com.pangubpm.engine.core.NotFoundException;
import com.pangubpm.engine.entity.A1FlowInstanceEntity;
import com.pangubpm.engine.entity.CommuReceiverEntity;
import com.pangubpm.engine.enums.FlowInstanceEnum;
import com.pangubpm.engine.service.A1FlowInstanceService;
import com.pangubpm.engine.service.A1RuntimeService;
import com.pangubpm.engine.utils.ProcessTaskNodeUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.common.engine.impl.identity.UserInfoAuthentication;
import org.flowable.common.engine.impl.util.ThreadMapUtil;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.delegate.event.ext.NotifyContext;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.engine.impl.util.ProcessDefinitionUtil;
import org.flowable.task.service.impl.persistence.entity.TaskEntity;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Component;

@Primary
@Component
public class ExtBpmnEventHandlerImpl
extends BpmnEventHandlerImpl {
    private static final Logger log = LoggerFactory.getLogger(ExtBpmnEventHandlerImpl.class);
    @Resource
    private WorkflowExecuteService workflowExecuteService;
    @Resource
    private ExtWorkflowExecuteService extWorkflowExecuteService;
    @Resource
    private UserAdapter userAdapter;

    public void handlerProcessCreateEvent(Map<String, Object> variables, ExecutionEntityImpl executionEntity) {
    }

    private AuditOptCallBackService getAuditOptCallBackService(AuditConfig auditConfig) {
        AuditOptCallBackService callBackService = null;
        try {
            callBackService = this.workflowExecuteService.getAdapterService(auditConfig.getBeanName());
            return callBackService;
        }
        catch (NoSuchBeanDefinitionException var4) {
            throw new NotFoundException(I18nUtil.translate((String)"i18n__WWWWKEIdERjSW_3b9e1370", (String)"bean\u9002\u914d\u5bf9\u8c61\u914d\u7f6e\u6709\u8bef:") + auditConfig.getBeanName());
        }
    }

    private ExtAuditOptCallBackService getExtAuditOptCallBackService(AuditConfig auditConfig) {
        ExtAuditOptCallBackService callBackService = null;
        try {
            callBackService = this.extWorkflowExecuteService.getAdapterService(auditConfig.getBeanName());
            return callBackService;
        }
        catch (NoSuchBeanDefinitionException var4) {
            throw new NotFoundException(I18nUtil.translate((String)"i18n__WWWWKEIdERjSW_3b9e1370", (String)"bean\u9002\u914d\u5bf9\u8c61\u914d\u7f6e\u6709\u8bef:") + auditConfig.getBeanName());
        }
    }

    public void handlerTaskCreatedEvent(TaskEntityImpl taskEntity) {
        RuntimeService runtimeService = (RuntimeService)SpringUtils.getBean(RuntimeService.class);
        Map processInstanceVariables = runtimeService.getVariables(taskEntity.getProcessInstanceId());
        String extraData = (String)processInstanceVariables.get("extraData");
        String action = (String)ThreadMapUtil.get((String)"action");
        if (StringUtils.isBlank((CharSequence)action) && StringUtils.isBlank((CharSequence)(action = (String)ThreadMapUtil.get((String)"operate")))) {
            action = (String)processInstanceVariables.get("action");
        }
        String starUser = (String)processInstanceVariables.get("startUser");
        UcUser ucUser = this.userAdapter.queryUserByUserId(starUser);
        TenantContext.setTenant((String)ucUser.getTenantId());
        ExtAuditOutputParamDTO outputParamDTO = new ExtAuditOutputParamDTO();
        outputParamDTO.setProcessRootId(taskEntity.getProcessInstanceId());
        outputParamDTO.setSubmitUser(ucUser.getTenantId() + "_" + ucUser.getAccount());
        List nextAuditUser = TaskAuditUtils.getTaskAuditUser((TaskEntityImpl)taskEntity, (String)ucUser.getTenantId());
        outputParamDTO.setNextAuditUserList(nextAuditUser);
        AuditConfig auditConfig = (AuditConfig)JSON.parseObject((String)extraData, AuditConfig.class);
        outputParamDTO.setAuditStatus(AuditStatusEnum.AUDIT_DOING.getValue());
        outputParamDTO.setBpmnType(WorkFlowType.BPMN.getValue());
        String opinion = (String)ThreadMapUtil.get((String)"opinion");
        outputParamDTO.setOpinion(opinion);
        outputParamDTO.setCurrentUser((String)ThreadMapUtil.get((String)"currentUser"));
        AuditInputParamDTO inputParamDTO = TaskAuditUtils.getAuditInputParamDTO((Map)processInstanceVariables, (AuditConfig)auditConfig);
        auditConfig = TaskAuditUtils.checkParamAndGetConfig((AuditInputParamDTO)inputParamDTO);
        AuditOptCallBackService callBackService = this.getAuditOptCallBackService(auditConfig);
        ExtAuditOptCallBackService extCallBackService = this.getExtAuditOptCallBackService(auditConfig);
        String operationType = null;
        if (!(BpmnActionEnum.AGREE.getValue().equals(action) || BpmnActionEnum.UNPASS.getValue().equals(action) || BpmnActionEnum.PASS.getValue().equals(action))) {
            if (BpmnActionEnum.BACK_TO_NODE.getValue().equals(action)) {
                callBackService.rejectCallBack(inputParamDTO, (AuditOutputParamDTO)outputParamDTO);
                log.info("send mq message:task back_to_node ==>" + nextAuditUser);
                operationType = BpmnActionEnum.BACK_TO_NODE.getValue();
            } else if (BpmnActionEnum.FETCH_BACK.getValue().equals(action)) {
                callBackService.cancelCallBack(inputParamDTO, (AuditOutputParamDTO)outputParamDTO);
                log.info("send mq message:task back_to_node ==>" + nextAuditUser);
                operationType = BpmnActionEnum.FETCH_BACK.getValue();
            }
        } else {
            callBackService.completeCallBack(inputParamDTO, (AuditOutputParamDTO)outputParamDTO);
            if (Objects.nonNull(extCallBackService)) {
                extCallBackService.completeCallBack(inputParamDTO, outputParamDTO);
            }
            operationType = BpmnActionEnum.PASS.getValue();
        }
        if (!StringUtils.isEmpty((String)operationType)) {
            AuditEventDTO eventDTO = new AuditEventDTO();
            String taskTitle = (String)ThreadMapUtil.get((String)"taskTitle");
            Map map = UserInfoAuthentication.getAuthenticatedUserId();
            if (map != null && StringUtils.isBlank((CharSequence)taskTitle)) {
                taskTitle = (String)map.get("taskTitle");
            }
            eventDTO.setTaskTitle(taskTitle);
            eventDTO.setAuditUserId((String)ThreadMapUtil.get((String)"currentUser"));
            eventDTO.setPreTaskId((String)ThreadMapUtil.get((String)"completTaskId"));
            eventDTO.setPreTaskDefinitionKey((String)ThreadMapUtil.get((String)"completTaskDefinitionKey"));
            eventDTO.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
            eventDTO.setPriority((String)ThreadMapUtil.get((String)"priority"));
            eventDTO.setTaskId(taskEntity.getId());
            eventDTO.setProcessInstanceId(taskEntity.getProcessInstanceId());
            eventDTO.setOpinion(opinion);
            eventDTO.setNextAuditUserIdList(nextAuditUser);
            eventDTO.setVariables(processInstanceVariables);
            AuditAsyncEventUtils.sentAuditAsyncEvent((AuditEventDTO)eventDTO, (String)TenantContext.getTenant(), (String)operationType);
            log.info("send mq message:task created ==>" + nextAuditUser);
        }
    }

    public void handlerTaskCompletedEvent(Map<String, Object> variables, TaskEntityImpl taskEntity) {
        String extraData = (String)variables.get("extraData");
        String starUser = (String)variables.get("startUser");
        String action = (String)variables.get("action");
        String chooseNode = (String)variables.get("chooseNode");
        if (StringUtils.isBlank((CharSequence)chooseNode) && BpmnActionEnum.UNPASS.getValue().equals(action)) {
            BpmnModel bpmnModel = ProcessDefinitionUtil.getBpmnModel((String)taskEntity.getProcessDefinitionId(), (String)taskEntity.getProcessInstanceId());
            List preNodeIds = BpmnModelUtils.getPreNodeId((BpmnModel)bpmnModel, (String)taskEntity.getTaskDefinitionKey());
            chooseNode = (String)preNodeIds.get(0);
        }
        AuditConfig auditConfig = (AuditConfig)JSON.parseObject((String)extraData, AuditConfig.class);
        AuditInputParamDTO inputParamDTO = TaskAuditUtils.getAuditInputParamDTO(variables, (AuditConfig)auditConfig);
        AuditOutputParamDTO outputParamDTO = new AuditOutputParamDTO();
        outputParamDTO.setProcessRootId(taskEntity.getProcessInstanceId());
        UcUser ucUser = this.userAdapter.queryUserByUserId(starUser);
        outputParamDTO.setSubmitUser(ucUser.getTenantId() + "_" + ucUser.getAccount());
        outputParamDTO.setBpmnType(WorkFlowType.BPMN.getValue());
        List auditUserList = TaskAuditUtils.getTaskAuditUser((String)taskEntity.getProcessInstanceId(), (String)taskEntity.getTenantId());
        outputParamDTO.setNextAuditUserList(auditUserList);
        String opinion = (String)ThreadMapUtil.get((String)"opinion");
        outputParamDTO.setOpinion(opinion);
        TenantContext.setTenant((String)ucUser.getTenantId());
        auditConfig = TaskAuditUtils.checkParamAndGetConfig((AuditInputParamDTO)inputParamDTO);
        AuditOptCallBackService callBackService = this.getAuditOptCallBackService(auditConfig);
        if (BpmnActionEnum.BACK_TO_NODE.getValue().equals(action) || BpmnActionEnum.FETCH_BACK.getValue().equals(action) || BpmnActionEnum.UNPASS.getValue().equals(action)) {
            String startActivityId = ProcessTaskNodeUtils.getProcessFirstNodeId((String)taskEntity.getProcessDefinitionId(), (String)taskEntity.getProcessInstanceId());
            String userId = (String)ThreadMapUtil.get((String)"currentUser");
            String operationType = null;
            if (StringUtils.isNotBlank((CharSequence)chooseNode) && StringUtils.isNotBlank((CharSequence)startActivityId)) {
                if (chooseNode.equals(startActivityId)) {
                    A1RuntimeService a1RuntimeService = (A1RuntimeService)SpringUtils.getBean(A1RuntimeService.class);
                    if (BpmnActionEnum.FETCH_BACK.getValue().equals(action)) {
                        a1RuntimeService.invalidProcessInstance(taskEntity.getProcessInstanceId(), taskEntity.getId(), userId, StringUtils.isNotBlank((CharSequence)opinion) ? opinion : FlowInstanceEnum.REVOKETOSTART.getMsg(), FlowInstanceEnum.REVOKETOSTART);
                        outputParamDTO.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
                        callBackService.cancelCallBack(inputParamDTO, outputParamDTO);
                        log.info("send mq message:task fetch_back_start ==>" + auditUserList);
                        operationType = BpmnActionEnum.FETCH_BACK_START_USER.getValue();
                        ThreadMapUtil.put((String)"repeat", (Object)"true");
                    } else {
                        a1RuntimeService.invalidProcessInstance(taskEntity.getProcessInstanceId(), taskEntity.getId(), userId, StringUtils.isNotBlank((CharSequence)opinion) ? opinion : FlowInstanceEnum.BACKTOSTART.getMsg(), FlowInstanceEnum.BACKTOSTART);
                        outputParamDTO.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue());
                        callBackService.rejectCallBack(inputParamDTO, outputParamDTO);
                        log.info("send mq message:task back_to_start ==>" + auditUserList);
                        operationType = BpmnActionEnum.BACK_TO_START_USER.getValue();
                    }
                }
                AuditEventDTO eventDTO = new AuditEventDTO();
                String taskTitle = (String)ThreadMapUtil.get((String)"taskTitle");
                Map map = UserInfoAuthentication.getAuthenticatedUserId();
                if (map != null && StringUtils.isBlank((CharSequence)taskTitle)) {
                    taskTitle = (String)map.get("taskTitle");
                }
                eventDTO.setTaskTitle(taskTitle);
                eventDTO.setAuditUserId(userId);
                eventDTO.setPreTaskId((String)ThreadMapUtil.get((String)"completTaskId"));
                eventDTO.setPreTaskDefinitionKey((String)ThreadMapUtil.get((String)"completTaskDefinitionKey"));
                eventDTO.setTaskDefinitionKey(taskEntity.getTaskDefinitionKey());
                eventDTO.setPriority((String)ThreadMapUtil.get((String)"priority"));
                eventDTO.setProcessInstanceId(taskEntity.getProcessInstanceId());
                eventDTO.setOpinion(opinion);
                eventDTO.setNextAuditUserIdList(auditUserList);
                eventDTO.setVariables(variables);
                AuditAsyncEventUtils.sentAuditAsyncEvent((AuditEventDTO)eventDTO, (String)TenantContext.getTenant(), (String)operationType);
            }
        }
    }

    public void handlerProcessCompletedEvent(Map<String, Object> variables, ExecutionEntityImpl executionEntity) {
        String starUser = (String)variables.get("startUser");
        String extraData = (String)variables.get("extraData");
        AuditConfig auditConfig = (AuditConfig)JSON.parseObject((String)extraData, AuditConfig.class);
        AuditInputParamDTO inputParamDTO = TaskAuditUtils.getAuditInputParamDTO(variables, (AuditConfig)auditConfig);
        ExtAuditOutputParamDTO outputParamDTO = new ExtAuditOutputParamDTO();
        outputParamDTO.setProcessRootId(executionEntity.getRootProcessInstanceId());
        outputParamDTO.setAuditStatus(AuditStatusEnum.AUDIT_FINISH.getValue());
        outputParamDTO.setBpmnType(WorkFlowType.BPMN.getValue());
        UcUser user = this.userAdapter.queryUserByUserId(starUser);
        outputParamDTO.setSubmitUser(user.getTenantId() + "_" + user.getAccount());
        String opinion = (String)ThreadMapUtil.get((String)"opinion");
        outputParamDTO.setOpinion(opinion);
        outputParamDTO.setCurrentUser((String)ThreadMapUtil.get((String)"currentUser"));
        TenantContext.setTenant((String)user.getTenantId());
        auditConfig = TaskAuditUtils.checkParamAndGetConfig((AuditInputParamDTO)inputParamDTO);
        AuditOptCallBackService callBackService = this.getAuditOptCallBackService(auditConfig);
        callBackService.completeCallBack(inputParamDTO, (AuditOutputParamDTO)outputParamDTO);
        ExtAuditOptCallBackService extCallBackService = this.getExtAuditOptCallBackService(auditConfig);
        if (Objects.nonNull(extCallBackService)) {
            extCallBackService.completeCallBack(inputParamDTO, outputParamDTO);
        }
        log.info("send mq message:process_completed ==>" + outputParamDTO.getSubmitUser());
        AuditEventDTO eventDTO = new AuditEventDTO();
        String taskTitle = (String)ThreadMapUtil.get((String)"taskTitle");
        Map map = UserInfoAuthentication.getAuthenticatedUserId();
        if (map != null && StringUtils.isBlank((CharSequence)taskTitle)) {
            taskTitle = (String)map.get("taskTitle");
        }
        eventDTO.setTaskTitle(taskTitle);
        eventDTO.setAuditUserId((String)ThreadMapUtil.get((String)"currentUser"));
        eventDTO.setPreTaskId((String)ThreadMapUtil.get((String)"completTaskId"));
        eventDTO.setPreTaskDefinitionKey((String)ThreadMapUtil.get((String)"completTaskDefinitionKey"));
        eventDTO.setPriority((String)ThreadMapUtil.get((String)"priority"));
        eventDTO.setProcessInstanceId(executionEntity.getProcessInstanceId());
        eventDTO.setOpinion(opinion);
        eventDTO.setVariables(variables);
        AuditAsyncEventUtils.sentAuditAsyncEvent((AuditEventDTO)eventDTO, (String)TenantContext.getTenant(), (String)BpmnActionEnum.PROCESS_COMPLETED.getValue());
    }

    public void handlerProcessCancelledEvent(Map<String, Object> variables, String processInstanceId) {
        String operate = (String)ThreadMapUtil.get((String)"operate");
        if (StringUtils.isBlank((CharSequence)operate)) {
            operate = (String)variables.get("action");
        }
        String extraData = (String)variables.get("extraData");
        String starUser = (String)variables.get("startUser");
        AuditConfig auditConfig = (AuditConfig)JSON.parseObject((String)extraData, AuditConfig.class);
        AuditInputParamDTO inputParamDTO = TaskAuditUtils.getAuditInputParamDTO(variables, (AuditConfig)auditConfig);
        AuditOutputParamDTO outputParamDTO = new AuditOutputParamDTO();
        outputParamDTO.setProcessRootId(processInstanceId);
        UcUser ucUser = this.userAdapter.queryUserByUserId(starUser);
        outputParamDTO.setSubmitUser(ucUser.getTenantId() + "_" + ucUser.getAccount());
        outputParamDTO.setBpmnType(WorkFlowType.BPMN.getValue());
        String opinion = (String)ThreadMapUtil.get((String)"opinion");
        String repeat = (String)ThreadMapUtil.get((String)"repeat");
        outputParamDTO.setOpinion(opinion);
        AuditEventDTO eventDTO = new AuditEventDTO();
        String taskTitle = (String)ThreadMapUtil.get((String)"taskTitle");
        Map map = UserInfoAuthentication.getAuthenticatedUserId();
        if (map != null && StringUtils.isBlank((CharSequence)taskTitle)) {
            taskTitle = (String)map.get("taskTitle");
        }
        eventDTO.setTaskTitle(taskTitle);
        eventDTO.setAuditUserId((String)ThreadMapUtil.get((String)"currentUser"));
        eventDTO.setPreTaskId((String)ThreadMapUtil.get((String)"completTaskId"));
        eventDTO.setPreTaskDefinitionKey((String)ThreadMapUtil.get((String)"completTaskDefinitionKey"));
        eventDTO.setPriority((String)ThreadMapUtil.get((String)"priority"));
        eventDTO.setProcessInstanceId(processInstanceId);
        eventDTO.setOpinion(opinion);
        eventDTO.setVariables(variables);
        TenantContext.setTenant((String)ucUser.getTenantId());
        auditConfig = TaskAuditUtils.checkParamAndGetConfig((AuditInputParamDTO)inputParamDTO);
        AuditOptCallBackService callBackService = this.getAuditOptCallBackService(auditConfig);
        if (BpmnActionEnum.INVALID.getValue().equals(operate)) {
            outputParamDTO.setAuditStatus(AuditStatusEnum.AUDIT_REJECT.getValue());
            outputParamDTO.setNextAuditUserList(Arrays.asList(outputParamDTO.getSubmitUser()));
            callBackService.rejectCallBack(inputParamDTO, outputParamDTO);
            log.info("send mq message:task invalid ==>" + outputParamDTO.getSubmitUser());
            AuditAsyncEventUtils.sentAuditAsyncEvent((AuditEventDTO)eventDTO, (String)TenantContext.getTenant(), (String)BpmnActionEnum.INVALID.getValue());
        } else if (BpmnActionEnum.FETCH_BACK.getValue().equals(operate)) {
            if ("true".equals(repeat)) {
                return;
            }
            outputParamDTO.setAuditStatus(AuditStatusEnum.AUDIT_NEW.getValue());
            callBackService.cancelCallBack(inputParamDTO, outputParamDTO);
            log.info("send mq message:task fetch_back ==>" + outputParamDTO.getSubmitUser());
            AuditAsyncEventUtils.sentAuditAsyncEvent((AuditEventDTO)eventDTO, (String)TenantContext.getTenant(), (String)BpmnActionEnum.FETCH_BACK_START_USER.getValue());
        }
    }

    public void handlerTaskCopyTo(NotifyContext notifyContext) {
        String msgInfoList = notifyContext.getMsgInfoList();
        if (!StringUtils.isEmpty((String)msgInfoList)) {
            List commuReceiverList = JSONArray.parseArray((String)msgInfoList, CommuReceiverEntity.class);
            Map commuReceiverMap = commuReceiverList.parallelStream().collect(Collectors.toMap(CommuReceiverEntity::getReceiverId, Function.identity()));
            List receiverUserIds = notifyContext.getReceiverUserId();
            TaskEntity task = notifyContext.getTaskEntity();
            A1FlowInstanceService a1FlowInstanceService = (A1FlowInstanceService)SpringUtils.getBean(A1FlowInstanceService.class);
            A1FlowInstanceEntity a1FlowInstance = a1FlowInstanceService.getByProcId(notifyContext.getProcId());
            String businessId = null;
            String businessType = null;
            String title = null;
            if (a1FlowInstance == null) {
                TaskService taskService = (TaskService)SpringUtils.getBean(TaskService.class);
                Map variables = taskService.getVariables(task.getId());
                businessId = (String)variables.get("businessId");
                businessType = (String)variables.get("bizType");
                title = (String)variables.get("typeTitle");
            } else {
                businessId = a1FlowInstance.getBizKey();
                businessType = a1FlowInstance.getBizType();
                title = a1FlowInstance.getTitle();
            }
            UserAdapter userAdapter = (UserAdapter)SpringUtils.getBean(UserAdapter.class);
            UcUser ucUser = userAdapter.queryUserByUserId((String)receiverUserIds.get(0));
            TenantContext.setTenant((String)ucUser.getTenantId());
            WorkflowInvokeAccountRpcService workflowInvokeAccountRpcService = (WorkflowInvokeAccountRpcService)SpringUtils.getBean(WorkflowInvokeAccountRpcService.class);
            String userIdStr = receiverUserIds.stream().collect(Collectors.joining(",", "", ""));
            List subAccountList = workflowInvokeAccountRpcService.getSubAccountListByIds(userIdStr);
            JSONArray receiveList = new JSONArray();
            for (ElsSubAccountDTO elsSubAccountDTO : subAccountList) {
                JSONObject receiveObj = new JSONObject();
                receiveObj.put("toElsAccount", (Object)elsSubAccountDTO);
                JSONArray toSubAccountList = new JSONArray();
                toSubAccountList.add((Object)JSON.parseObject((String)JSON.toJSONString((Object)elsSubAccountDTO)));
                receiveObj.put("toSubAccountList", (Object)toSubAccountList);
                JSONObject params = new JSONObject();
                CommuReceiverEntity commuReceiverEntity = (CommuReceiverEntity)commuReceiverMap.get(elsSubAccountDTO.getId());
                params.put("commuReceiverId", (Object)commuReceiverEntity.getId());
                params.put("processInstanceId", (Object)task.getProcessInstanceId());
                params.put("businessId", (Object)businessId);
                params.put("businessType", (Object)businessType);
                receiveObj.put("urlParam", (Object)SysUtil.getUrlParamByJson((JSONObject)params));
                receiveList.add((Object)receiveObj);
            }
            AuditEventDTO eventDTO = new AuditEventDTO();
            eventDTO.setAuditUserId((String)ThreadMapUtil.get((String)"currentUser"));
            eventDTO.setTaskId(task.getId());
            eventDTO.setReceiverUserIds(receiverUserIds);
            eventDTO.setPreTaskDefinitionKey((String)ThreadMapUtil.get((String)"completTaskDefinitionKey"));
            eventDTO.setTaskDefinitionKey(task.getTaskDefinitionKey());
            eventDTO.setPriority(task.getPriority() + "");
            eventDTO.setProcessInstanceId(task.getProcessInstanceId());
            AuditAsyncEventUtils.sentAuditAsyncEvent((AuditEventDTO)eventDTO, (String)TenantContext.getTenant(), (String)BpmnActionEnum.COPY_TO.getValue());
            TaskAuditUtils.sendMsg((String)ucUser.getTenantId(), (String)businessType, (JSONArray)receiveList, (String)title, (String)"workFlow", (String)"copy_to");
            log.info("send mq message:task copy to ==>" + receiveList);
        }
    }

    public void handlerTaskHandTo(NotifyContext notifyContext) {
        List receiverUserIds = notifyContext.getReceiverUserId();
        TaskEntity task = notifyContext.getTaskEntity();
        A1FlowInstanceService a1FlowInstanceService = (A1FlowInstanceService)SpringUtils.getBean(A1FlowInstanceService.class);
        A1FlowInstanceEntity a1FlowInstance = a1FlowInstanceService.getByProcId(notifyContext.getProcId());
        TaskService taskService = (TaskService)SpringUtils.getBean(TaskService.class);
        Map processInstanceVariables = taskService.getVariables(task.getId());
        String extraData = (String)processInstanceVariables.get("extraData");
        WorkflowInvokeAccountRpcService accountRpcService = (WorkflowInvokeAccountRpcService)SpringUtils.getBean(WorkflowInvokeAccountRpcService.class);
        ElsSubAccountDTO elsSubAccountDTO = accountRpcService.queryUserByUserId((String)receiverUserIds.get(0));
        AuditConfig auditConfig = (AuditConfig)JSON.parseObject((String)extraData, AuditConfig.class);
        AuditInputParamDTO auditInputParamDTO = TaskAuditUtils.getAuditInputParamDTO((Map)processInstanceVariables, (AuditConfig)auditConfig);
        TenantContext.setTenant((String)elsSubAccountDTO.getElsAccount());
        String operate = ThreadMapUtil.get((String)"operate").toString();
        String operateType = null;
        if (StringUtils.isNotBlank((CharSequence)operate) && "handover".equals(operate)) {
            JSONArray receiveList = new JSONArray();
            JSONObject receiveObj = new JSONObject();
            receiveObj.put("toElsAccount", (Object)elsSubAccountDTO);
            JSONArray toSubAccountList = new JSONArray();
            toSubAccountList.add((Object)JSON.parseObject((String)JSON.toJSONString((Object)elsSubAccountDTO)));
            receiveObj.put("toSubAccountList", (Object)toSubAccountList);
            receiveList.add((Object)receiveObj);
            TaskAuditUtils.sendMsg((String)elsSubAccountDTO.getElsAccount(), (String)"workFlow", (JSONArray)receiveList, (String)a1FlowInstance.getTitle(), (String)"workFlow", (String)"bpmn_handover");
            operateType = BpmnActionEnum.HANDOVER.getValue();
        } else {
            TaskAuditUtils.sendMsg((String)elsSubAccountDTO.getElsAccount(), (AuditInputParamDTO)auditInputParamDTO, Arrays.asList(task), (String)a1FlowInstance.getTitle(), (String)"workFlow", (String)"bpmn_transfer");
            operateType = BpmnActionEnum.TRANSFER.getValue();
        }
        AuditEventDTO eventDTO = new AuditEventDTO();
        eventDTO.setAuditUserId((String)ThreadMapUtil.get((String)"currentUser"));
        eventDTO.setTaskId(task.getId());
        eventDTO.setReceiverUserIds(receiverUserIds);
        eventDTO.setPreTaskDefinitionKey((String)ThreadMapUtil.get((String)"completTaskDefinitionKey"));
        eventDTO.setTaskDefinitionKey(task.getTaskDefinitionKey());
        eventDTO.setPriority(task.getPriority() + "");
        eventDTO.setProcessInstanceId(task.getProcessInstanceId());
        eventDTO.setVariables(processInstanceVariables);
        AuditAsyncEventUtils.sentAuditAsyncEvent((AuditEventDTO)eventDTO, (String)TenantContext.getTenant(), (String)operateType);
        log.info("send mq message:task hand to ==>" + JSON.toJSONString((Object)elsSubAccountDTO));
    }
}

