/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.config;

import org.apache.commons.lang.StringUtils;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RedissonConfig {
    @Value(value="${spring.redis.host}")
    private String host;
    @Value(value="${spring.redis.port}")
    private String port;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.database}")
    private Integer database;

    @Bean
    public RedissonClient getRedisson() {
        Config config = new Config();
        SingleServerConfig singleServerConfig = config.useSingleServer();
        singleServerConfig.setAddress("redis://" + this.host + ":" + this.port);
        singleServerConfig.setDatabase(this.database.intValue());
        if (!StringUtils.isBlank((String)this.password)) {
            singleServerConfig.setPassword(this.password);
        }
        return Redisson.create((Config)config);
    }
}

