/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.handler;

import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.net.NetUtil;
import cn.hutool.core.util.IdUtil;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SnowflakeGeneratorHandler {
    private static final Logger log = LoggerFactory.getLogger(SnowflakeGeneratorHandler.class);
    private long workerId = 0L;
    private long datacenterId = 1L;
    private Snowflake snowflake = IdUtil.createSnowflake((long)this.workerId, (long)this.datacenterId);

    @PostConstruct
    public void init() {
        try {
            this.workerId = NetUtil.ipv4ToLong((String)NetUtil.getLocalhostStr());
            log.info("\u5f53\u524d\u673a\u5668\u7684workerId: " + this.workerId);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.warn("\u5f53\u524d\u673a\u5668\u7684workerId\u83b7\u53d6\u5931\u8d25 ----> " + e);
            this.workerId = NetUtil.getLocalhostStr().hashCode();
        }
    }

    public synchronized long snowflakeId() {
        return this.snowflake.nextId();
    }

    public synchronized long snowflakeId(long workerId, long datacenterId) {
        Snowflake snowflake = IdUtil.createSnowflake((long)workerId, (long)datacenterId);
        return snowflake.nextId();
    }

    public static void main(String[] args) {
        System.out.println(new SnowflakeGeneratorHandler().snowflakeId());
    }
}

