/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.handler;

import cn.hutool.core.lang.TypeReference;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SysUtil;
import com.els.modules.extend.api.config.ElsConfig;
import com.els.modules.extend.api.dto.ErpResponse;
import com.els.modules.extend.api.dto.SrmInterfaceRequest;
import com.els.modules.extend.api.dto.SrmInterfaceResponse;
import com.els.modules.extend.api.dto.WmsResponse;
import com.els.modules.extend.api.dto.WmsResponseToken;
import com.els.modules.extend.api.enums.InterfaceEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SrmInterfaceHandler {
    private static final Logger log = LoggerFactory.getLogger(SrmInterfaceHandler.class);
    @Autowired
    private InterfaceUtil interfaceUtil;
    @Autowired
    ElsConfig config;
    private static final String MSG_WMS_RESPONSE = "success";

    public <T> T doRequest(SrmInterfaceRequest request, TypeReference<T> valueTypeRef) {
        JSONObject jsonObject = this.interfaceUtil.callInterface(request.getBus_account(), "", (JSONObject)JSONObject.toJSON((Object)request), null);
        Result result = (Result)JSONObject.parseObject((String)jsonObject.toJSONString(), Result.class);
        if (200 != result.getCode() || !result.isSuccess()) {
            log.error("\u8bf7\u6c42srm\u63a5\u53e3\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)result.getMessage());
            throw new ELSBootException(result.getMessage());
        }
        Object t = JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)result.getResult()), valueTypeRef, (boolean)true);
        return (T)t;
    }

    public <T> T doRequest(JSONObject paramJson, TypeReference<T> valueTypeRef) {
        JSONObject jsonObject = this.interfaceUtil.callInterface(SysUtil.getPurchaseAccount(), "", paramJson, null);
        Result result = (Result)JSONObject.parseObject((String)jsonObject.toJSONString(), Result.class);
        if (200 != result.getCode() || !result.isSuccess()) {
            log.error("\u8bf7\u6c42srm\u63a5\u53e3\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)result.getMessage());
            throw new ELSBootException(result.getMessage());
        }
        Object t = JSONUtil.toBean((String)JSONUtil.toJsonStr((Object)result.getResult()), valueTypeRef, (boolean)true);
        return (T)t;
    }

    public void resolvingResponse(SrmInterfaceResponse response) {
        if (200 == response.getStatus()) {
            log.info(response.getMessage());
            return;
        }
        log.error(response.getMessage());
        throw new ELSBootException(response.getMessage());
    }

    public String doXMLRequestString(SrmInterfaceRequest request) {
        JSONObject jsonObject = this.interfaceUtil.callInterface(request.getBus_account(), "", (JSONObject)JSONObject.toJSON((Object)request), null);
        Result result = (Result)JSONObject.parseObject((String)jsonObject.toJSONString(), Result.class);
        if (200 != result.getCode() || !result.isSuccess()) {
            log.error("\u8bf7\u6c42srm\u63a5\u53e3\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)result.getMessage());
            throw new ELSBootException(result.getMessage());
        }
        return (String)result.getResult();
    }

    public Result doProcedure(SrmInterfaceRequest request) {
        JSONObject jsonObject = this.interfaceUtil.callInterface(request.getBus_account(), "", (JSONObject)JSONObject.toJSON((Object)request), null);
        Result result = (Result)JSONObject.parseObject((String)jsonObject.toJSONString(), Result.class);
        if (200 != result.getCode() || !result.isSuccess()) {
            log.error("\u8bf7\u6c42srm\u63a5\u53e3\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)result.getMessage());
            throw new ELSBootException(result.getMessage());
        }
        return result;
    }

    public <T, R> T requestWMS(Object param, InterfaceEnum interfaceEnum) {
        SrmInterfaceRequest tokenRequest = new SrmInterfaceRequest();
        tokenRequest.setBus_account(SysUtil.getPurchaseAccount());
        tokenRequest.setSrm_interface_code(InterfaceEnum.WMS_TOKEN.getCode());
        WmsResponse<WmsResponseToken> tokenWmsResponse = this.doRequest(tokenRequest, new TypeReference<WmsResponse<WmsResponseToken>>(){});
        if (200 != tokenWmsResponse.getCode()) {
            log.error("\u83b7\u53d6WMS\u5e73\u53f0token\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)tokenWmsResponse.getMessage());
            throw new ELSBootException(String.format("WMS\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u5185\u5bb9\uff1a%s\uff0c\u8bf7\u8054\u7cfbWMS\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", tokenWmsResponse.getMessage()));
        }
        String wmsToken = tokenWmsResponse.getData().getAccess_token();
        SrmInterfaceRequest<Object> request = new SrmInterfaceRequest<Object>();
        request.setBus_account(SysUtil.getPurchaseAccount());
        request.setSrm_interface_code(interfaceEnum.getCode());
        request.setBody(param);
        JSONObject header = new JSONObject();
        header.put("Authorization", (Object)String.join((CharSequence)" ", "Bearer", wmsToken));
        request.setHeader_param(header);
        WmsResponse response = (WmsResponse)this.doRequest(request, new TypeReference<WmsResponse<T>>(){});
        if (200 != response.getCode()) {
            log.error("\u8bf7\u6c42\u3010{}\u3011\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)interfaceEnum.getName(), (Object)response.getMessage());
            throw new ELSBootException(String.format("WMS\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u5185\u5bb9\uff1a%s\uff0c\u8bf7\u8054\u7cfbWMS\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", response.getMessage()));
        }
        return response.getData();
    }

    public <T, R> T requestERP(Object param, InterfaceEnum interfaceEnum) {
        SrmInterfaceRequest<Object> request = new SrmInterfaceRequest<Object>();
        request.setBus_account(SysUtil.getPurchaseAccount());
        request.setSrm_interface_code(interfaceEnum.getCode());
        request.setBody(param);
        ErpResponse response = (ErpResponse)this.doRequest(request, new TypeReference<ErpResponse<T>>(){});
        if (200 != response.getCode()) {
            log.error("\u8bf7\u6c42\u3010{}\u3011\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)interfaceEnum.getName(), (Object)response.getMsg());
            throw new ELSBootException(String.format("ERP\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u5185\u5bb9\uff1a%s\uff0c\u8bf7\u8054\u7cfbERP\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", response.getMsg()));
        }
        return response.getData();
    }

    public <T, R> T requestERP(JSONObject param, InterfaceEnum interfaceEnum) {
        ErpResponse response = (ErpResponse)this.doRequest(param, new TypeReference<ErpResponse<T>>(){});
        if (200 != response.getCode()) {
            log.error("\u8bf7\u6c42\u3010{}\u3011\u5e73\u53f0\u53d1\u751f\u5f02\u5e38\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a{}", (Object)interfaceEnum.getName(), (Object)response.getMsg());
            throw new ELSBootException(String.format("ERP\u7cfb\u7edf\u9519\u8bef\uff0c\u9519\u8bef\u5185\u5bb9\uff1a%s\uff0c\u8bf7\u8054\u7cfbERP\u7cfb\u7edf\u7ba1\u7406\u5458\uff01", response.getMsg()));
        }
        return response.getData();
    }
}

