/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.util;

import com.google.common.collect.Maps;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.springframework.cglib.beans.BeanGenerator;
import org.springframework.cglib.beans.BeanMap;

public class ReflectExtUtil {
    public static Object getTarget(Object dest, Map<String, Object> addProperties) {
        PropertyUtilsBean propertyUtilsBean = new PropertyUtilsBean();
        PropertyDescriptor[] descriptors = propertyUtilsBean.getPropertyDescriptors(dest);
        HashMap propertyMap = Maps.newHashMap();
        for (PropertyDescriptor d : descriptors) {
            if ("class".equalsIgnoreCase(d.getName())) continue;
            propertyMap.put(d.getName(), d.getPropertyType());
        }
        addProperties.forEach((k, v) -> propertyMap.put(k, v.getClass()));
        DynamicBean dynamicBean = new DynamicBean(dest.getClass(), propertyMap);
        propertyMap.forEach((k, v) -> {
            try {
                if (!addProperties.containsKey(k)) {
                    dynamicBean.setValue((String)k, propertyUtilsBean.getNestedProperty(dest, k));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        addProperties.forEach((k, v) -> {
            try {
                dynamicBean.setValue((String)k, v);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        Object target = dynamicBean.getTarget();
        return target;
    }

    public static class DynamicBean {
        private Object target;
        private BeanMap beanMap;

        public DynamicBean(Class superclass, Map<String, Class> propertyMap) {
            this.target = this.generateBean(superclass, propertyMap);
            this.beanMap = BeanMap.create((Object)this.target);
        }

        public void setValue(String property, Object value) {
            this.beanMap.put((Object)property, value);
        }

        public Object getValue(String property) {
            return this.beanMap.get((Object)property);
        }

        public Object getTarget() {
            return this.target;
        }

        private Object generateBean(Class superclass, Map<String, Class> propertyMap) {
            BeanGenerator generator = new BeanGenerator();
            if (null != superclass) {
                generator.setSuperclass(superclass);
            }
            BeanGenerator.addProperties((BeanGenerator)generator, propertyMap);
            return generator.create();
        }
    }
}

