/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.common.utils;

import cn.hutool.core.util.StrUtil;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import java.lang.reflect.Field;
import java.util.Objects;
import org.apache.commons.lang3.time.FastDateFormat;

public class OrderSqlUtil {
    private static final String insert_label = "INSERT INTO %s(";
    private static final String values_label = "VALUES(";
    private static final String end_label = ");";

    public static String getInsertSql(String tableName, Object object) {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format(insert_label, tableName));
        Class<?> aClass = object.getClass();
        Field[] fields = aClass.getDeclaredFields();
        try {
            int i;
            for (i = 0; i < fields.length; ++i) {
                sb.append(OrderSqlUtil.humpToLine(fields[i].getName())).append(",");
            }
            sb.deleteCharAt(sb.length() - 1).append(") ").append(values_label);
            block11: for (i = 0; i < fields.length; ++i) {
                String simpleName;
                fields[i].setAccessible(true);
                switch (simpleName = fields[i].getType().getSimpleName()) {
                    case "Date": {
                        sb.append(Objects.isNull(fields[i].get(object)) ? null : "'" + FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(fields[i].get(object)) + "'").append(",");
                        continue block11;
                    }
                    case "String": {
                        String str = (String)fields[i].get(object);
                        if (StrUtil.isNotBlank((CharSequence)str)) {
                            sb.append("N'").append(str.contains("'") ? str.replace("'", "''") + "'" : str + "'").append(",");
                            continue block11;
                        }
                        sb.append("N''").append(",");
                        continue block11;
                    }
                    default: {
                        sb.append(Objects.isNull(fields[i].get(object)) ? null : "'" + fields[i].get(object) + "'").append(",");
                    }
                }
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        catch (Exception e) {
            throw new ELSBootException(I18nUtil.translate((String)"i18n_alert_bLsqlIH_fdc5ab93", (String)"\u751f\u6210sql\u5f02\u5e38"), (Throwable)e, new String[0]);
        }
        sb.append(end_label);
        return sb.toString();
    }

    private static String humpToLine(String str) {
        return str.replaceAll("[A-Z]", "_$0").toLowerCase();
    }
}

