/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.service.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.extend.api.service.UploadFileForOtherService;
import com.els.modules.extend.api.utils.HttpRequestUtils;
import java.io.File;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Resource;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class UploadFileForOtherServiceImpl
implements UploadFileForOtherService {
    private static final Logger log = LoggerFactory.getLogger(UploadFileForOtherServiceImpl.class);
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String uploadFile(String url) {
        CloseableHttpClient client = null;
        HttpGet request = new HttpGet(url);
        try {
            client = HttpClients.createDefault();
            InputStream inputStream = HttpRequestUtils.httpGetUrl(request, client);
            StorageFileInfo fileInfo = new StorageFileInfo();
            LocalDateTime time = LocalDateTime.now();
            DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
            String nowday = dtf.format(time);
            String documentName = url.substring(url.lastIndexOf("/") + 1);
            documentName = documentName.replaceAll("-", "_");
            String documentLocation = File.separator + "files" + File.separator + TenantContext.getTenant() + File.separator + nowday + File.separator + documentName;
            if (documentLocation.contains("\\")) {
                documentLocation = documentLocation.replace("\\", "/");
            }
            String savePath = CharSequenceUtil.emptyToDefault(null, (String)documentLocation);
            savePath = savePath.replaceAll(" ", "_");
            fileInfo.setPath(savePath);
            fileInfo.setFilename(documentName);
            fileInfo.setOriginalFilename(documentName);
            fileInfo = this.fileStoreSignServiceImpl.storeFile(inputStream, fileInfo, (String)null);
            String downloadPath = this.fileStoreSignServiceImpl.getDownloadPath(fileInfo.getPath(), fileInfo.getSaveType());
            log.info("ERP\u56fe\u7247\u4e0a\u4f20\u6210\u529f:" + downloadPath);
            inputStream.close();
            String string = savePath;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                request.releaseConnection();
                if (client != null) {
                    client.close();
                }
            }
            catch (Exception exception) {}
        }
        return null;
    }
}

