/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import com.els.common.util.RedisUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.mapstruct.ap.internal.util.Strings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ExtendTenantContext
extends TenantContext {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private RedisUtil redisUtil;
    private static final String USER_CACHE_KEY = "sys:org:user:";
    private static final List<String> CONFIG_TENANT = new ArrayList<String>();
    private static final List<String> SERVICE_ADDRESS = new ArrayList<String>(1);
    @Value(value="${els.config.purchaseAccount}")
    private String elsAccount;
    @Value(value="${els.config.service.address}")
    private String serviceAddr;
    private static final ThreadLocal<String> defaultCurrentTenant = new ThreadLocal();

    @PostConstruct
    public void init() {
        CONFIG_TENANT.addAll(this.elsAccount.contains(",") ? Arrays.asList(this.elsAccount.split(",")) : Collections.singletonList(this.elsAccount));
        SERVICE_ADDRESS.add(this.serviceAddr);
    }

    public ElsSubAccount getElsSubAccountById(String id) {
        if (Strings.isEmpty((String)id)) {
            return null;
        }
        return (ElsSubAccount)this.elsSubAccountService.getById((Serializable)((Object)id));
    }

    public static String getDefaultConfigServiceAddr() {
        return SERVICE_ADDRESS.get(0);
    }

    public static String getDefaultConfigTenant() {
        return CONFIG_TENANT.get(0);
    }

    public static void setDefaultTenant(String tenant) {
        defaultCurrentTenant.set(tenant);
    }

    public static String getDefaultTenant() {
        return defaultCurrentTenant.get();
    }

    public static void clearDefaultTenant() {
        defaultCurrentTenant.remove();
    }

    public String getServiceAddr() {
        return this.serviceAddr;
    }
}

