/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import com.els.common.exception.ELSBootException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FTPUtils {
    private static final int DEFAULT_PORT = 21;
    private static final Logger log = LoggerFactory.getLogger(FTPUtils.class);
    private String host;
    private int port;
    private String username;
    private String password;
    private int timeOut = 120000;
    private String encoding = "GBK";
    private FTPClient ftpClient = null;

    public FTPUtils(String host, int port, String username, String password, Integer timeOut, String encoding) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        if (null != timeOut) {
            this.timeOut = timeOut;
        }
        if (StringUtils.isNotBlank((CharSequence)encoding)) {
            this.encoding = encoding;
        }
    }

    public void ftpConnection() throws IOException {
        this.ftpClient = new FTPClient();
        try {
            this.ftpClient.setDefaultPort(21);
            this.ftpClient.setConnectTimeout(this.timeOut);
            this.ftpClient.setDefaultTimeout(this.timeOut);
            this.ftpClient.setDataTimeout(this.timeOut);
            this.ftpClient.setControlEncoding(this.encoding);
            this.ftpClient.connect(this.host, this.port);
            this.ftpClient.login(this.username, this.password);
            int replyCode = this.ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)replyCode)) {
                this.ftpClient.disconnect();
                throw new ELSBootException("FTP\u8fde\u63a5\u5931\u8d25\uff01");
            }
            this.ftpClient.enterLocalPassiveMode();
            this.ftpClient.setFileType(2);
            this.ftpClient.setFileTransferMode(10);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ELSBootException("FTP\u8fde\u63a5\u5f02\u5e38", (Throwable)e, new String[0]);
        }
    }

    public void ftpClose() throws IOException {
        if (this.ftpClient != null && this.ftpClient.isConnected()) {
            this.ftpClient.logout();
            this.ftpClient.disconnect();
        }
    }

    public void downloadFile(String localPath, String localFileName, String ftpFilePath) throws IOException {
        if (this.ftpClient == null || !this.ftpClient.isConnected()) {
            throw new ELSBootException("\u8bf7\u5148\u8c03\u7528ftpConnection\uff0c\u8fde\u63a5FTP\u3002");
        }
        FileOutputStream os = null;
        File localFile = new File(localPath + "/" + localFileName);
        if (!localFile.getParentFile().exists()) {
            localFile.getParentFile().mkdirs();
            localFile.createNewFile();
        }
        os = new FileOutputStream(localFile);
        boolean isFind = this.ftpClient.retrieveFile(new String(ftpFilePath.getBytes(this.encoding), this.encoding), (OutputStream)os);
        if (!isFind) {
            localFile.delete();
            throw new ELSBootException("\u672a\u627e\u5230\u6587\u4ef6\uff1a[" + ftpFilePath + "]");
        }
        ((OutputStream)os).close();
    }

    public boolean downloadFileToStreamm(OutputStream os, String ftpFilePath) throws IOException {
        if (this.ftpClient == null || !this.ftpClient.isConnected()) {
            throw new ELSBootException("\u8bf7\u5148\u8c03\u7528ftpConnection\uff0c\u8fde\u63a5FTP\u3002");
        }
        return this.ftpClient.retrieveFile(new String(ftpFilePath.getBytes(this.encoding), this.encoding), os);
    }
}

