/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSON;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.message.api.dto.ElsMsgConfigHeadDTO;
import com.els.modules.message.api.dto.MsgConfigItemDTO;
import com.els.modules.message.api.service.MsgConfigRpcService;
import com.els.modules.supplier.api.dto.SupplierMasterDataDTO;
import com.els.modules.supplier.api.service.SupplierMasterDataRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.service.ElsSubAccountService;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SmsSendUtil {
    private static final Logger log = LoggerFactory.getLogger(SmsSendUtil.class);
    @Value(value="${ipaas.config.url}")
    private String paasUrl;
    @Value(value="${ipaas.config.elsAccount}")
    private String paasElsAccount;
    @Value(value="${ipaas.config.subAccount}")
    private String paasSubAccount;
    @Value(value="${ipaas.config.pwd}")
    private String paasPwd;
    @Value(value="${ipaas.config.service}")
    private String paasService;
    @Resource(name="srmPoolExecutor")
    public ThreadPoolExecutor srmPoolExecutor;
    @Resource
    private MsgConfigRpcService msgConfigRpcService;
    @Resource
    private ElsSubAccountService elsSubAccountService;
    @Resource
    private SupplierMasterDataRpcService supplierMasterDataRpcService;

    public void sendMsg(String businessType, String optType, JSONObject dataJson, List<String> toElsAccountList, String purchaseUser) {
        LoginUser loginUser = SysUtil.getLoginUser();
        if (StrUtil.equals((CharSequence)"contract", (CharSequence)businessType)) {
            dataJson.set("publishUser", (Object)loginUser.getRealname());
        }
        this.srmPoolExecutor.execute(() -> {
            log.error("\u5f00\u59cb\u6267\u884c\u53d1\u9001\u77ed\u4fe1\u903b\u8f91=====>{}", (Object)DateUtil.now());
            TenantContext.setTenant((String)SysUtil.getPurchaseAccount());
            if (CollUtil.isNotEmpty((Collection)toElsAccountList)) {
                log.error("\u53d1\u7ed9\u4f9b\u5e94\u5546=====>");
                List supplierMasterDataDTOS = this.supplierMasterDataRpcService.selectSupplerList(SysUtil.getPurchaseAccount(), toElsAccountList);
                List toElsAccounts = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsSubAccountService.lambdaQuery().notIn(ElsSubAccount::getElsAccount, new Object[]{SysUtil.getPurchaseAccount(), "100000"})).in(ElsSubAccount::getElsAccount, (Collection)toElsAccountList)).list();
                for (ElsSubAccount toElsAccount : toElsAccounts) {
                    if (!StrUtil.isNotEmpty((CharSequence)toElsAccount.getPhone())) continue;
                    String elsAccount = toElsAccount.getElsAccount();
                    SupplierMasterDataDTO supplierMasterDataDTO = supplierMasterDataDTOS.stream().filter(info -> StrUtil.equals((CharSequence)elsAccount, (CharSequence)info.getToElsAccount())).findFirst().orElse(null);
                    if (ObjectUtil.isNotNull((Object)supplierMasterDataDTO)) {
                        dataJson.set("supplierName", (Object)supplierMasterDataDTO.getSupplierName());
                    }
                    this.sendMsg(businessType, optType, dataJson, toElsAccount.getPhone());
                }
            } else if (StrUtil.isNotBlank((CharSequence)purchaseUser)) {
                log.error("\u53d1\u7ed9\u91c7\u8d2d\u5458=====>");
                ElsSubAccount account = (ElsSubAccount)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.elsSubAccountService.lambdaQuery().eq(ElsSubAccount::getElsAccount, (Object)SysUtil.getPurchaseAccount())).and(wrapper -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(ElsSubAccount::getSubAccount, (Object)purchaseUser)).or()).eq(ElsSubAccount::getRealname, (Object)purchaseUser);
                })).last("limit 1")).one();
                if (ObjectUtil.isNotNull((Object)account)) {
                    dataJson.set("publishUser", (Object)account.getRealname());
                    this.sendMsg(businessType, optType, dataJson, account.getPhone());
                }
            }
        });
    }

    private void sendMsg(String businessType, String optType, JSONObject dataJson, String phone) {
        ElsMsgConfigHeadDTO elsMsgConfigHeadDTO;
        List msgConfigItemDTOS;
        MsgConfigItemDTO msgConfigItemDTO;
        TenantContext.setTenant((String)SysUtil.getPurchaseAccount());
        List msgConfigHeadDTOS = this.msgConfigRpcService.getByOperation(SysUtil.getPurchaseAccount(), businessType, optType);
        List elsMsgConfigHeadDTOS = msgConfigHeadDTOS.stream().filter(info -> StrUtil.equals((CharSequence)"1", (CharSequence)info.getStatus())).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(elsMsgConfigHeadDTOS) && ObjectUtil.isNotNull((Object)(msgConfigItemDTO = (MsgConfigItemDTO)(msgConfigItemDTOS = this.msgConfigRpcService.findListByMainId((elsMsgConfigHeadDTO = (ElsMsgConfigHeadDTO)elsMsgConfigHeadDTOS.get(0)).getId())).stream().filter(info -> StrUtil.equals((CharSequence)"4", (CharSequence)info.getMsgType())).findFirst().orElse(null)))) {
            String msgContent = msgConfigItemDTO.getMsgContent();
            List fieldNameList = ReUtil.findAll((String)"\\$\\{([^}]*)\\}", (CharSequence)msgContent, (int)1);
            String templateNumber = msgConfigItemDTO.getTemplateNumber();
            JSONObject body = new JSONObject();
            body.set("elsAccount", (Object)this.paasElsAccount);
            body.set("service", (Object)this.paasService);
            body.set("interfaceCode", (Object)templateNumber);
            JSONObject data = new JSONObject();
            data.set("phone", (Object)phone);
            JSONObject content = new JSONObject();
            if (CollUtil.isNotEmpty((Collection)fieldNameList)) {
                for (String fieldName : fieldNameList) {
                    if (!dataJson.containsKey((Object)fieldName)) continue;
                    if (StrUtil.equals((CharSequence)"quoteEndTime", (CharSequence)fieldName) || StrUtil.equals((CharSequence)"applyEndTime", (CharSequence)fieldName) || StrUtil.equals((CharSequence)"startTime", (CharSequence)fieldName)) {
                        content.set(fieldName, (Object)DateUtil.formatDateTime((Date)dataJson.getDate((Object)fieldName)));
                        continue;
                    }
                    content.set(fieldName, dataJson.get((Object)fieldName));
                }
            }
            data.set("content", (Object)content);
            body.set("data", (Object)data);
            log.error("\u6d88\u606f\u53d1\u9001\u5185\u5bb9=====>{}", (Object)body);
            ((HttpRequest)((HttpRequest)((HttpRequest)HttpUtil.createPost((String)this.paasUrl).header("elsAccount", this.paasElsAccount)).header("subAccount", this.paasSubAccount)).header("pwd", this.paasPwd)).body(JSONUtil.toJsonStr((JSON)body)).execute();
        }
    }
}

