/*
 * Decompiled with CFR 0.152.
 */
package com.els.aspect;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.aspect.annotation.SrmValidated;
import com.els.common.context.SrmLengthCheckTableHolder;
import com.els.common.exception.ELSBootException;
import com.els.common.util.AopElUtils;
import com.els.common.util.ClassTypeBuilder;
import com.els.common.util.I18nUtil;
import com.els.common.validator.ValidResult;
import com.els.common.validator.ValidationUtil;
import com.els.modules.base.api.dto.TemplateConfigHeadDTO;
import com.els.modules.base.api.dto.TemplateConfigItemDTO;
import com.els.modules.base.api.dto.TemplateGroupDTO;
import com.els.modules.base.api.dto.TemplateHeadDTO;
import com.els.rpc.service.InvokeBaseRpcService;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.Lazy;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.stereotype.Component;

@Aspect
@Component
@EnableAspectJAutoProxy
public class ValidationAspect {
    private static final Logger log = LoggerFactory.getLogger(ValidationAspect.class);
    private static String BASE_FORM = "baseForm";
    private static String HEAD = "head";
    private static String ITEM = "item";
    @Lazy
    @Resource
    private InvokeBaseRpcService invokeBaseRpcService;

    @Pointcut(value="@annotation(com.els.common.aspect.annotation.SrmValidated)")
    public void pointcut() {
    }

    private void templateParamCheck(JSONObject headVo, String elsAccount, String templateNumber, String templateVersion) {
        TemplateHeadDTO config = this.invokeBaseRpcService.getTemplateConfig(elsAccount, templateNumber, templateVersion);
        List configHeadList = config.getTemplateConfigHeadList();
        List configItemList = config.getTemplateConfigItemList();
        List groupList = config.getTemplateGroupList();
        Map headColumnMap = configHeadList.stream().filter(x -> "1".equals(x.getRequired())).collect(Collectors.toMap(TemplateConfigHeadDTO::getFieldName, Function.identity(), (v1, v2) -> v2));
        Map itemColumnMap = configItemList.stream().filter(x -> "1".equals(x.getRequired())).collect(Collectors.groupingBy(TemplateConfigItemDTO::getGroupCode, Collectors.mapping(Function.identity(), Collectors.toMap(TemplateConfigItemDTO::getFieldName, Function.identity(), (v1, v2) -> v2))));
        Map groupColumnMap = groupList.stream().filter(x -> HEAD.equals(x.getGroupType()) || ITEM.equals(x.getGroupType())).collect(Collectors.toMap(TemplateGroupDTO::getGroupCode, Function.identity(), (v1, v2) -> v2));
        if (CollUtil.isNotEmpty(headColumnMap)) {
            headColumnMap.forEach((fieldName, headDTO) -> {
                boolean isNull;
                Object fieldValue = headVo.getObject(fieldName, Object.class);
                boolean bl = isNull = null == fieldValue || fieldValue instanceof String && CharSequenceUtil.isBlank((CharSequence)((String)fieldValue));
                if (isNull) {
                    TemplateGroupDTO groupDTO = (TemplateGroupDTO)groupColumnMap.get(BASE_FORM);
                    String errorMsg = I18nUtil.translate((String)groupDTO.getGroupNameI18nKey(), (String)groupDTO.getGroupName()) + ":[" + I18nUtil.translate((String)headDTO.getFieldLabelI18nKey(), (String)headDTO.getFieldLabel()) + "]" + I18nUtil.translate((String)"i18n_alert_xOLV_25690410", (String)"\u4e0d\u80fd\u4e3a\u7a7a");
                    throw new ELSBootException(errorMsg);
                }
            });
        }
        groupColumnMap.remove(BASE_FORM);
        if (CollUtil.isNotEmpty(groupColumnMap)) {
            groupColumnMap.forEach((groupCode, group) -> {
                Map groupItem = (Map)itemColumnMap.get(groupCode);
                if (CollUtil.isEmpty((Map)groupItem) && CollUtil.isNotEmpty((Map)itemColumnMap)) {
                    if (itemColumnMap.containsKey(null)) {
                        groupItem = (Map)itemColumnMap.get(null);
                    }
                    if (itemColumnMap.containsKey("")) {
                        groupItem = (Map)itemColumnMap.get("");
                    }
                }
                if (CollUtil.isEmpty((Map)groupItem)) {
                    return;
                }
                itemColumnMap.forEach((itemColumnCode, templateColumnMap) -> {
                    Object itemObj = headVo.getObject(itemColumnCode, Object.class);
                    if (null == itemObj) {
                        return;
                    }
                    if (itemObj instanceof List) {
                        JSONArray itemList = headVo.getJSONArray(itemColumnCode);
                        for (int index = 0; index < itemList.size(); ++index) {
                            JSONObject item = itemList.getJSONObject(index);
                            for (String needColumn : templateColumnMap.keySet()) {
                                TemplateConfigItemDTO c = (TemplateConfigItemDTO)templateColumnMap.get(needColumn);
                                Object fieldValue = item.getObject(needColumn, Object.class);
                                boolean isNull = null == fieldValue || fieldValue instanceof String && CharSequenceUtil.isBlank((CharSequence)((String)fieldValue));
                                if (!isNull) continue;
                                String errorMsg = I18nUtil.translate((String)group.getGroupNameI18nKey(), (String)group.getGroupName()) + "[" + (index + 1) + "]:[" + I18nUtil.translate((String)c.getFieldLabelI18nKey(), (String)c.getFieldLabel()) + "]" + I18nUtil.translate((String)"i18n_alert_xOLV_25690410", (String)"\u4e0d\u80fd\u4e3a\u7a7a");
                                throw new ELSBootException(errorMsg);
                            }
                        }
                    }
                });
            });
        }
    }

    @Before(value="pointcut()")
    public void before(JoinPoint point) {
        if (point.getArgs() == null || point.getArgs().length <= 0) {
            return;
        }
        long time = System.currentTimeMillis();
        try {
            ValidResult validResult;
            MethodSignature signature = (MethodSignature)point.getSignature();
            Method method = signature.getMethod();
            SrmValidated annotation = method.getAnnotation(SrmValidated.class);
            Class<?>[] parameterTypes = method.getParameterTypes();
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class type = parameterTypes[i];
                if (type.isAssignableFrom(List.class) || type.isAssignableFrom(Set.class) || type.isAssignableFrom(Collection.class)) {
                    Type t = method.getGenericParameterTypes()[i];
                    try {
                        if (t instanceof ParameterizedType) {
                            Type[] actualTypeArguments = ((ParameterizedType)ParameterizedType.class.cast(t)).getActualTypeArguments();
                            if (null == actualTypeArguments || actualTypeArguments.length == 0) continue;
                            type = (Class)actualTypeArguments[0];
                        }
                    }
                    catch (Exception actualTypeArguments) {
                        // empty catch block
                    }
                }
                if (!CharSequenceUtil.isNotEmpty((CharSequence)ClassTypeBuilder.getTableNameAnnotation(type))) continue;
                SrmLengthCheckTableHolder.set(type);
            }
            if (annotation.openTemplateCheck()) {
                String elTemplateAccount = CharSequenceUtil.emptyToDefault((CharSequence)annotation.templateAccount(), (String)"templateAccount");
                String elTemplateNumber = CharSequenceUtil.emptyToDefault((CharSequence)annotation.templateNumber(), (String)"templateNumber");
                String elTemplateVersion = CharSequenceUtil.emptyToDefault((CharSequence)annotation.templateVersion(), (String)"templateVersion");
                Map paramMap = AopElUtils.getAllParameters((JoinPoint)point);
                if (!paramMap.isEmpty()) {
                    boolean haveTemplate;
                    String elParam = (String)paramMap.keySet().iterator().next();
                    if (!elTemplateAccount.startsWith("#")) {
                        elTemplateAccount = String.format("#%s.templateAccount", elParam);
                    }
                    if (!elTemplateNumber.startsWith("#")) {
                        elTemplateNumber = String.format("#%s.templateNumber", elParam);
                    }
                    if (!elTemplateVersion.startsWith("#")) {
                        elTemplateVersion = String.format("#%s.templateVersion", elParam);
                    }
                    EvaluationContext context = AopElUtils.buildContext((JoinPoint)point, (Object)paramMap);
                    Expression sourceEl = AopElUtils.getExpressionByKey((String)elTemplateAccount);
                    String templateAccount = (String)sourceEl.getValue(context, String.class);
                    sourceEl = AopElUtils.getExpressionByKey((String)elTemplateNumber);
                    String templateNumber = (String)sourceEl.getValue(context, String.class);
                    sourceEl = AopElUtils.getExpressionByKey((String)elTemplateVersion);
                    String templateVersion = (String)sourceEl.getValue(context, String.class);
                    boolean bl = haveTemplate = CharSequenceUtil.isNotEmpty((CharSequence)templateAccount) && CharSequenceUtil.isNotEmpty((CharSequence)templateNumber) && CharSequenceUtil.isNotEmpty((CharSequence)templateVersion);
                    if (haveTemplate) {
                        this.templateParamCheck((JSONObject)paramMap.get(elParam), templateAccount, templateNumber, templateVersion);
                    }
                }
            }
            if (!(validResult = ValidationUtil.validateParameters((SrmValidated)annotation, (JoinPoint)point, (Object)point.getTarget(), (Method)method, (Object[])point.getArgs(), (Class[])new Class[0])).isHasErrors()) {
                for (int i = 0; i < point.getArgs().length && !(validResult = ValidationUtil.validateBean((SrmValidated)annotation, (JoinPoint)point, (Object)point.getArgs()[i], (Class[])new Class[0])).isHasErrors(); ++i) {
                }
            }
            if (validResult.isHasErrors()) {
                throw new ELSBootException(validResult.getMessage());
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            log.info("ValidationAspect_cost_time:" + (System.currentTimeMillis() - time));
            SrmLengthCheckTableHolder.remove();
        }
    }
}

