/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.common.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.util.CollectionUtils;

public class ListUtils {
    private ListUtils() {
    }

    public static <T> List<T> filter(List<T> list, Predicate<T> predicate) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        return list.stream().filter(predicate).collect(Collectors.toList());
    }

    public static <T, E> List<E> convert(List<T> list, Function<T, E> function) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.EMPTY_LIST;
        }
        return list.stream().map(function).collect(Collectors.toList());
    }

    public static <T> List<T> distinct(List<T> list, Function<T, String> field) {
        return list.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet(Comparator.comparing(field))), ArrayList::new));
    }

    public static <T, K, V> Map<K, V> toMap(List<T> list, Function<T, K> key, Function<T, V> value) {
        return list.stream().collect(Collectors.toMap(key, value, (key1, key2) -> key2));
    }

    public static <K, T> Map<K, Map<K, List<T>>> group(List<T> list, Predicate<T> predicate, Function<T, K> value1, Function<T, K> value2) {
        return list.stream().filter(predicate).collect(Collectors.groupingBy(value1, Collectors.groupingBy(value2)));
    }
}

