/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.interfaces.service;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SpringContextUtils;
import com.els.common.util.SysUtil;
import com.els.modules.extend.interfaces.vo.res.base.GenericInterfaceResVO;
import org.apache.commons.lang3.StringUtils;

public abstract class CallTmsInterfaceRpcService<T extends GenericInterfaceResVO<E>, E>
extends TypeReference<T> {
    static String RESULT_MESSAGE_FIELD = "message";
    static String RESULT_FLAG_FIELD = "code";
    static String SUCCESS_FLAG = "200";
    static String RESULT_RESULT_FIELD = "result";
    static String GET_TMS_ACCESS_TOKEN = "getTmsAccessToken";

    protected String getTmsAccessToken() {
        RedisUtil redisUtil = (RedisUtil)SpringContextUtils.getBean(RedisUtil.class);
        String tmsAccessToken = (String)redisUtil.get("tms_access_token");
        if (StringUtils.isNotEmpty((CharSequence)tmsAccessToken)) {
            System.out.println("\u7f13\u5b58\u62ff\u5230TMSTOKEN:" + tmsAccessToken);
            return tmsAccessToken;
        }
        GenericInterfaceResVO interfaceResult = this.getTmsAccessTokenFromInterfacePlatForm(null, new JSONObject(), GET_TMS_ACCESS_TOKEN);
        if (!interfaceResult.isSuccess()) {
            throw new ELSBootException(interfaceResult.getMessage());
        }
        JSONObject tmsResultJsonObject = (JSONObject)interfaceResult.getResult();
        tmsAccessToken = "Bearer " + tmsResultJsonObject.getString("access_token");
        if (StringUtils.isNotEmpty((CharSequence)tmsAccessToken)) {
            redisUtil.set("tms_access_token", (Object)tmsAccessToken, (long)tmsResultJsonObject.getInteger("expires_in").intValue());
            return tmsAccessToken;
        }
        return null;
    }

    protected GenericInterfaceResVO getTmsAccessTokenFromInterfacePlatForm(JSONObject body, JSONObject urlParam, String interfaceCode) {
        JSONObject interfacePlatFormResult = this.callInterfacePlatForm(body, urlParam, interfaceCode);
        GenericInterfaceResVO genericInterfaceResVO = (GenericInterfaceResVO)JSONObject.parseObject((String)String.valueOf(interfacePlatFormResult), GenericInterfaceResVO.class);
        return genericInterfaceResVO;
    }

    protected T businessCallInterfacePlatForm(JSONObject body, JSONObject urlParam, String interfaceCode) {
        JSONObject interfacePlatFormResult = this.callInterfacePlatForm(body, urlParam, interfaceCode);
        GenericInterfaceResVO genericInterfaceResVO = (GenericInterfaceResVO)JSONObject.parseObject((String)String.valueOf(interfacePlatFormResult), (TypeReference)this, (Feature[])new Feature[0]);
        return (T)genericInterfaceResVO;
    }

    private JSONObject callInterfacePlatForm(JSONObject body, JSONObject urlParam, String interfaceCode) {
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)SysUtil.getPurchaseAccount());
        param.put("srm_interface_code", (Object)interfaceCode);
        JSONObject authorization = new JSONObject();
        if (!GET_TMS_ACCESS_TOKEN.equals(interfaceCode)) {
            authorization.put("Authorization", (Object)this.getTmsAccessToken());
        }
        param.put("header_param", (Object)authorization);
        if (body != null) {
            param.put("body", (Object)body);
        }
        if (urlParam != null) {
            param.put("url_param", (Object)urlParam);
        }
        InterfaceUtil interfaceUtil = (InterfaceUtil)SpringContextUtils.getBean(InterfaceUtil.class);
        return interfaceUtil.callInterface(SysUtil.getPurchaseAccount(), "", param, (Object)"");
    }
}

