/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.service.Impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.ConvertUtils;
import com.els.common.util.I18nUtil;
import com.els.common.util.PasswordUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.base.api.service.SimpleOpenApiRpcService;
import com.els.modules.org.api.dto.PurchaseOrganizationInfoDTO;
import com.els.modules.org.api.service.PurchaseOrganizationInfoRpcService;
import com.els.modules.system.entity.ElsSubAccount;
import com.els.modules.system.entity.SubaccountOrg;
import com.els.modules.system.service.ElsSubAccountService;
import com.els.modules.system.service.SubaccountOrgService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="standardElsSubAccount")
public class StandardElsSubAccountServiceImpl
implements SimpleOpenApiRpcService {
    @Autowired
    private ElsSubAccountService elsSubAccountService;
    @Autowired
    private SubaccountOrgService subaccountOrgService;
    @Autowired
    private PurchaseOrganizationInfoRpcService purchaseOrganizationInfoRpcService;

    public JSONObject invoke(JSONObject param) {
        ArrayList<ElsSubAccount> updateList = new ArrayList<ElsSubAccount>();
        ArrayList<ElsSubAccount> createList = new ArrayList<ElsSubAccount>();
        ArrayList<SubaccountOrg> createAccountOrgList = new ArrayList<SubaccountOrg>();
        ArrayList updateAccountOrgList = new ArrayList();
        if (!param.containsKey((Object)"headList")) {
            throw new ELSBootException(I18nUtil.translate((String)"", (String)"headList \u4e0d\u80fd\u4e3a\u7a7a"));
        }
        List list = JSONObject.parseArray((String)param.getString("headList"), ElsSubAccount.class);
        if (CollectionUtil.isNotEmpty((Collection)list) && list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!StringUtils.isBlank((CharSequence)((ElsSubAccount)list.get(i)).getSubAccount()) && !((ElsSubAccount)list.get(i)).getSubAccount().equals("")) continue;
                list.remove(i);
                --i;
            }
        }
        if (CollectionUtil.isEmpty((Collection)list) || list == null || list.size() < 1) {
            return new JSONObject();
        }
        this.checkRepeat(list);
        Date date = new Date();
        JSONArray headArray = new JSONArray();
        for (ElsSubAccount user : list) {
            String orgCode;
            PurchaseOrganizationInfoDTO purchaseOrganizationInfoDTO;
            if (StringUtils.isEmpty((CharSequence)user.getPassword())) {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u7528\u6237\u3010" + user.getSubAccount() + "\u3011\u7684\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a")));
            }
            String orgId = user.getOrgCode();
            String orgCategoryCode = "";
            if (StringUtils.isNotBlank((CharSequence)orgId)) {
                purchaseOrganizationInfoDTO = this.purchaseOrganizationInfoRpcService.selectById(orgId);
                if (!Objects.nonNull(purchaseOrganizationInfoDTO)) {
                    orgCode = "";
                    throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u673a\u6784id\u3010" + orgId + "\u3011\u4e0d\u5b58\u5728")));
                }
            } else {
                orgCode = "";
                throw new ELSBootException(I18nUtil.translate((String)"", (String)("\u673a\u6784id\u3010" + orgId + "\u3011\u4e0d\u80fd\u4e3a\u7a7a")));
            }
            orgCode = purchaseOrganizationInfoDTO.getOrgCode();
            orgCategoryCode = "company";
            ElsSubAccount sysUser = this.elsSubAccountService.getUserBySubAccount(user.getSubAccount());
            if (sysUser != null) {
                user.setId(sysUser.getId());
                ElsSubAccount updateAccount = new ElsSubAccount();
                updateAccount.setId(sysUser.getId());
                updateAccount.setWorkNo(user.getWorkNo());
                updateAccount.setAccountValidityDate(user.getAccountValidityDate());
                updateAccount.setPhone(user.getPhone());
                updateAccount.setOrgCode(user.getOrgCode());
                updateAccount.setSex(user.getSex());
                updateAccount.setTelephone(user.getTelephone());
                updateAccount.setEmail(user.getEmail());
                updateAccount.setRealname(user.getRealname());
                updateAccount.setStatus(user.getStatus());
                updateList.add(updateAccount);
                List queryList = this.subaccountOrgService.selectByMainId(user.getId());
                if (!StringUtils.isNotBlank((CharSequence)orgCode)) continue;
                if (CollectionUtil.isEmpty((Collection)queryList)) {
                    SubaccountOrg subaccountOrg = new SubaccountOrg();
                    subaccountOrg.setElsAccount(TenantContext.getTenant());
                    subaccountOrg.setOrgCode(orgCode);
                    subaccountOrg.setOrgCategoryCode(orgCategoryCode);
                    subaccountOrg.setUserName(user.getSubAccount());
                    subaccountOrg.setUserId(user.getId());
                    subaccountOrg.setCreateTime(new Date());
                    subaccountOrg.setDeleted(CommonConstant.DEL_FLAG_0);
                    createAccountOrgList.add(subaccountOrg);
                    continue;
                }
                List filterList = queryList.stream().filter(sbo -> sbo.getOrgCode().equals(orgCode)).collect(Collectors.toList());
                if (!CollectionUtil.isEmpty(filterList)) continue;
                SubaccountOrg subaccountOrg = new SubaccountOrg();
                subaccountOrg.setElsAccount(TenantContext.getTenant());
                subaccountOrg.setOrgCode(orgCode);
                subaccountOrg.setOrgCategoryCode(orgCategoryCode);
                subaccountOrg.setUserName(user.getSubAccount());
                subaccountOrg.setUserId(user.getId());
                subaccountOrg.setCreateTime(new Date());
                subaccountOrg.setDeleted(CommonConstant.DEL_FLAG_0);
                createAccountOrgList.add(subaccountOrg);
                continue;
            }
            String salt = ConvertUtils.randomGen((int)8);
            user.setSalt(salt);
            String passwd = user.getPassword();
            if (StringUtils.isBlank((CharSequence)passwd)) {
                passwd = "jiaotou@2024";
            }
            String passwordEncode = PasswordUtil.encrypt((String)(TenantContext.getTenant() + "_" + user.getSubAccount()), (String)passwd, (String)salt);
            user.setPassword(passwordEncode);
            user.setFbk2(passwd);
            if (user.getStatus() == null) {
                user.setStatus(Integer.valueOf(1));
            }
            user.setDeleted(CommonConstant.DEL_FLAG_0);
            user.setId(IdWorker.getIdStr());
            user.setCreateTime(date);
            user.setElsAccount(TenantContext.getTenant());
            createList.add(user);
            JSONObject headObj = SysUtil.objectToJSON((Object)user);
            headObj.remove((Object)"salt");
            headObj.remove((Object)"password");
            headArray.add((Object)headObj);
            List queryList = this.subaccountOrgService.selectByMainId(user.getId());
            if (!StringUtils.isNotBlank((CharSequence)orgCode)) continue;
            if (CollectionUtil.isEmpty((Collection)queryList)) {
                SubaccountOrg subaccountOrg = new SubaccountOrg();
                subaccountOrg.setElsAccount(TenantContext.getTenant());
                subaccountOrg.setOrgCode(orgCode);
                subaccountOrg.setOrgCategoryCode(orgCategoryCode);
                subaccountOrg.setUserName(user.getSubAccount());
                subaccountOrg.setUserId(user.getId());
                subaccountOrg.setCreateTime(new Date());
                subaccountOrg.setDeleted(CommonConstant.DEL_FLAG_0);
                createAccountOrgList.add(subaccountOrg);
                continue;
            }
            List filterList = queryList.stream().filter(sbo -> orgCode.equals(sbo.getOrgCode())).collect(Collectors.toList());
            if (!CollectionUtil.isEmpty(filterList)) continue;
            SubaccountOrg subaccountOrg = new SubaccountOrg();
            subaccountOrg.setElsAccount(TenantContext.getTenant());
            subaccountOrg.setOrgCode(orgCode);
            subaccountOrg.setOrgCategoryCode(orgCategoryCode);
            subaccountOrg.setUserName(user.getSubAccount());
            subaccountOrg.setUserId(user.getId());
            subaccountOrg.setCreateTime(new Date());
            subaccountOrg.setDeleted(CommonConstant.DEL_FLAG_0);
            createAccountOrgList.add(subaccountOrg);
        }
        this.elsSubAccountService.saveBatch(createList);
        this.subaccountOrgService.saveBatch(createAccountOrgList);
        this.elsSubAccountService.updateBatchById(updateList);
        this.subaccountOrgService.updateBatchById(updateAccountOrgList);
        JSONObject resultObj = new JSONObject();
        resultObj.put("headList", (Object)headArray);
        return resultObj;
    }

    private void checkRepeat(List<ElsSubAccount> list) {
        String key;
        Map<String, List<ElsSubAccount>> map = list.stream().collect(Collectors.groupingBy(ElsSubAccount::getSubAccount));
        Iterator<String> var3 = map.keySet().iterator();
        do {
            if (var3.hasNext()) continue;
            return;
        } while (map.get(key = var3.next()).size() <= 1);
        throw new ELSBootException(I18nUtil.translate((String)"", (String)"subAccount\u91cd\u590d\uff01"));
    }

    private Date convertStringToData(String curDate) {
        Date newDate = null;
        try {
            SimpleDateFormat dft = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            newDate = dft.parse(curDate);
        }
        catch (Exception ex) {
            throw new ELSBootException("\u5f53\u524d\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a(" + curDate + ")");
        }
        return newDate;
    }
}

