/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api;

import com.alibaba.fastjson.JSONObject;
import com.els.common.constant.CommonConstant;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InterfaceToSAPUtil {
    private static final Logger log = LoggerFactory.getLogger(InterfaceToSAPUtil.class);
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private InterfaceUtil interfaceUtil;
    private static final String SAP_TOKEN_KEY = "sap:token:key:";
    private static final String TOKEN_BEARER = "Bearer ";

    public JSONObject getSapHeaders() {
        JSONObject headParam = new JSONObject();
        try {
            String token = (String)this.redisUtil.get(SAP_TOKEN_KEY + SysUtil.getPurchaseAccount());
            if (StringUtils.isNotBlank((CharSequence)token)) {
                headParam.put("Authorization", (Object)(TOKEN_BEARER + token));
            } else {
                JSONObject jsonObject = this.interfaceUtil.callInterface(SysUtil.getPurchaseAccount(), "", "getSapToken", headParam, null, null, (Object)new JSONObject());
                if (CommonConstant.SC_OK_200.equals(jsonObject.getIntValue("code"))) {
                    JSONObject result = jsonObject.getJSONObject("result");
                    String accessToken = result.getString("access_token");
                    headParam.put("Authorization", (Object)(TOKEN_BEARER + accessToken));
                    this.redisUtil.set(SAP_TOKEN_KEY + SysUtil.getPurchaseAccount(), (Object)accessToken, 3598L);
                }
            }
            return headParam;
        }
        catch (Exception e) {
            throw new ELSBootException("\u8c03\u7528\u63a5\u53e3\u5e73\u53f0\u83b7\u53d6SAP -TOKEN\u4fe1\u606f\u63a5\u53e3\u5931\u8d25," + e.getMessage());
        }
    }
}

