/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.api.utils;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.ObjectUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.els.common.api.vo.Result;
import com.els.common.exception.ELSBootException;
import com.els.common.util.Assert;
import com.els.common.util.DateUtils;
import com.els.common.util.RedisUtil;
import com.els.modules.account.api.dto.ThirdAuthDTO;
import com.els.modules.extend.api.utils.InterfaceCodeEnum;
import com.els.rpc.service.InvokeAccountRpcService;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Resource;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class SrmInterfaceUtil {
    private static final Logger logger = LoggerFactory.getLogger(SrmInterfaceUtil.class);
    @Resource
    private RedisUtil redisUtil;
    @Resource
    private InvokeAccountRpcService invokeAccountRpcService;
    @Value(value="${els.config.purchaseAccount}")
    private String purchaseAccount;
    private static String INTERFACE_PLATFORM_KEY = "sys:thirdAuth:interfaceToken:";
    private static String INTERFACE_PLATFORM_URL = "/els/openApi/invoke";

    public String call(InterfaceCodeEnum interfaceCodeEnum, Object obj, JSONObject headerParam, JSONObject urlParam) {
        JSONObject param = new JSONObject();
        param.put("bus_account", (Object)this.purchaseAccount);
        param.put("interface_code", (Object)interfaceCodeEnum.getValue());
        param.put("url_param", (Object)urlParam);
        param.put("header_param", (Object)headerParam);
        param.put("body", obj);
        logger.info("\u63a5\u53e3\u3010" + interfaceCodeEnum.getDesc() + "\u3011\u8bf7\u6c42\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)param));
        JSONObject result = this.callInterface(this.purchaseAccount, param);
        logger.info("\u63a5\u53e3\u3010" + interfaceCodeEnum.getDesc() + "\u3011\u8fd4\u56de\u63a5\u53e3\uff1a" + JSONObject.toJSONString((Object)result));
        Boolean success = result.getBoolean("success");
        if (null == success || !success.booleanValue()) {
            throw new ELSBootException(JSONObject.toJSONString((Object)result));
        }
        String interfaceResult = result.getString("result");
        if (null == interfaceResult || StringUtils.isBlank((CharSequence)interfaceResult)) {
            throw new ELSBootException("\u63a5\u53e3\u5e73\u53f0\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        return interfaceResult;
    }

    public Result<?> callErp(InterfaceCodeEnum interfaceCodeEnum, Object obj) {
        Long start = System.currentTimeMillis();
        Result finalResult = new Result();
        try {
            JSONObject object = new JSONObject();
            object.put("P_IFACE_CODE", (Object)interfaceCodeEnum.getErpInterfaceCode());
            object.put("P_BATCH_NUMBER", (Object)SrmInterfaceUtil.getUuid());
            object.put("P_REQUEST_DATA", obj);
            String result = this.call(interfaceCodeEnum, object, null, null);
            logger.info("\u63a5\u53e3\u5e73\u53f0\u8c03\u7528\u6210\u529f \u63a5\u53e3\u7f16\u7801\u3010" + interfaceCodeEnum.getValue() + interfaceCodeEnum.getDesc() + "\u3011\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
            if (ObjectUtils.isEmpty((Object)result)) {
                return Result.error((String)"\u540c\u6b65ERP\u5931\u8d25");
            }
            JSONObject resultObj = JSONObject.parseObject((String)result.toString());
            resultObj = SrmInterfaceUtil.analysisResult(resultObj);
            finalResult.setResult((Object)resultObj);
            finalResult.setSuccess(true);
            return finalResult;
        }
        catch (ELSBootException e) {
            logger.info("\u63a5\u53e3\u5e73\u53f0\u8c03\u7528\u5931\u8d25 \u63a5\u53e3\u7f16\u7801\u3010" + interfaceCodeEnum.getValue() + interfaceCodeEnum.getDesc() + "\u3011\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
            throw new ELSBootException("\u540c\u6b65ERP\u5931\u8d25:" + e.getMessage());
        }
    }

    public static String getUuid() {
        return UUID.randomUUID().toString().replaceAll("-", "").substring(0, 22);
    }

    public static JSONObject analysisResult(JSONObject result) {
        try {
            String OutputParametersStr = result.getString("OutputParameters");
            JSONObject OutputParametersObj = JSONObject.parseObject((String)OutputParametersStr);
            String X_RESPONSE_DATA = OutputParametersObj.getString("X_RESPONSE_DATA");
            String X_RETURN_MESG = OutputParametersObj.getString("X_RETURN_MESG");
            String X_RETURN_CODE = OutputParametersObj.getString("X_RETURN_CODE");
            if (!"S000A000".equals(X_RETURN_CODE)) {
                throw new ELSBootException("ERP\u63d0\u793a\uff1a" + X_RETURN_MESG);
            }
            Assert.isNotNull((Object)X_RESPONSE_DATA, (String)"ERP\u8fd4\u56de\u7684\u4e1a\u52a1\u6570\u636e\u4e3a\u7a7a\uff01");
            String dataStr = SrmInterfaceUtil.decodeByJava8(X_RESPONSE_DATA);
            JSONObject object = JSONObject.parseObject((String)dataStr);
            return object;
        }
        catch (Exception e) {
            throw new ELSBootException("\u89e3\u6790ERP\u8fd4\u56de\u6570\u636e\u5931\u8d25");
        }
    }

    public static String decodeByJava8(String str) {
        byte[] result = new byte[]{};
        try {
            result = Base64.decodeBase64((byte[])str.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return new String(result);
    }

    public static void main(String[] args) {
        String str = "{\"OutputParameters\":{\"X_RESPONSE_DATA\":\"eyJyZXN1bHQiOlt7InNvdXJjZVN5c3RlbSI6IlNSTSIsInNvdXJjZURvY051bWJl\\nciI6IjEiLCJkb2N1bWVudE51bSI6IiIsImxpbmVOdW0iOjEsInN0YXR1c0NvZGUi\\nOiJTIiwibWVzc3NhZ2UiOiIifV19\",\"X_RETURN_MESG\":\"\",\"X_RETURN_CODE\":\"S000A000\"}}";
        JSONObject object = JSONObject.parseObject((String)str);
        JSONObject reslut = SrmInterfaceUtil.analysisResult(object);
        System.out.println(reslut);
    }

    public static String getDate(Date date) {
        return null == date ? "" : DateUtils.date2Str((Date)date, (SimpleDateFormat)((SimpleDateFormat)DateUtils.getDatetimeFormat().get()));
    }

    public static String getExpiryDate(Date date) {
        return null == date ? "" : DateUtils.date2Str((Date)date, (SimpleDateFormat)((SimpleDateFormat)DateUtils.getDateSdf().get())) + " 23:59:59";
    }

    private JSONObject callInterface(String elsAccount, JSONObject param) {
        JSONObject authObj = this.getAuthObj(elsAccount);
        StringBuilder url = new StringBuilder(authObj.getString("appUrl"));
        url.append(INTERFACE_PLATFORM_URL);
        String result = ((HttpRequest)HttpRequest.post((String)url.toString()).header("token", authObj.getString("token"))).body(param.toJSONString()).execute().body();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        return resultObj;
    }

    private JSONObject getAuthObj(String elsAccount) {
        JSONObject authObj = (JSONObject)this.redisUtil.get(INTERFACE_PLATFORM_KEY + elsAccount);
        if (authObj != null) {
            return authObj;
        }
        try {
            ThirdAuthDTO authDTO = this.invokeAccountRpcService.getThirdAuthByType(elsAccount, "0");
            if (authDTO == null) {
                throw new ELSBootException("\u672a\u914d\u7f6e\u63a5\u53e3\u5e73\u53f0\u51ed\u8bc1\u4fe1\u606f\uff0c\u8c03\u7528\u5931\u8d25\uff01");
            }
            StringBuilder url = new StringBuilder(authDTO.getAppUrl());
            url.append("/els/openApi/getToken").append("?key=").append(authDTO.getAppKey()).append("&secret=").append(authDTO.getAppSecret());
            String result = HttpUtil.get((String)url.toString());
            JSONObject resultObj = JSONObject.parseObject((String)result);
            int code = resultObj.getIntValue("code");
            if (code == 200) {
                authObj = new JSONObject();
                String token = resultObj.getJSONObject("result").getString("token");
                long expiresIn = resultObj.getJSONObject("result").getLongValue("expiresIn");
                authObj.put("token", (Object)token);
                authObj.put("appUrl", (Object)authDTO.getAppUrl());
                this.redisUtil.set(INTERFACE_PLATFORM_KEY + elsAccount, (Object)authObj, expiresIn - 200L);
                return authObj;
            }
            throw new ELSBootException("\u83b7\u53d6\u63a5\u53e3\u5e73\u53f0token\u5931\u8d25\uff01");
        }
        catch (Exception var11) {
            logger.error("InterfaceUtil_getToken_failed:", (Throwable)var11);
            throw var11;
        }
    }

    public JSONObject callSms(InterfaceCodeEnum interfaceCodeEnum, Object object, JSONObject headerParam, JSONObject urlParam) {
        Long start = System.currentTimeMillis();
        JSONObject resultObj = null;
        try {
            String result = this.call(interfaceCodeEnum, object, headerParam, urlParam);
            logger.info("\u63a5\u53e3\u5e73\u53f0\u8c03\u7528\u6210\u529f \u63a5\u53e3\u7f16\u7801\u3010" + interfaceCodeEnum.getValue() + interfaceCodeEnum.getDesc() + "\u3011\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
            return resultObj;
        }
        catch (ELSBootException e) {
            logger.info("\u63a5\u53e3\u5e73\u53f0\u8c03\u7528\u5931\u8d25 \u63a5\u53e3\u7f16\u7801\u4e3a\u3010" + interfaceCodeEnum.getValue() + interfaceCodeEnum.getDesc() + "\u3011\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start) + "ms");
            throw new ELSBootException("\u540c\u6b65\u53d1\u9001\u6d88\u606f\u5931\u8d25:" + e.getMessage());
        }
    }
}

