/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.extend.util;

import com.alibaba.fastjson.JSONObject;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.Code128Writer;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Base64;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QRCodeUtil {
    private static final Logger log = LoggerFactory.getLogger(QRCodeUtil.class);
    private static String base64Url = "data:image/png;base64,";

    public static String createQRCode(String json) throws IOException, WriterException {
        log.info("QRCodeUtil->createQRCode: json: " + json);
        QRCodeWriter qrCodeWriter = new QRCodeWriter();
        HashMap<EncodeHintType, String> hints = new HashMap<EncodeHintType, String>();
        hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
        BitMatrix bitMatrix = qrCodeWriter.encode(json, BarcodeFormat.QR_CODE, 600, 600, hints);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)outputStream);
        Base64.Encoder encoder = Base64.getEncoder();
        String text = encoder.encodeToString(outputStream.toByteArray());
        return base64Url + text;
    }

    public static void main(String[] args) throws IOException, WriterException {
        JSONObject json = new JSONObject();
        json.put("url", (Object)"https://open.weixin.qq.com/connect/oauth2/authorize?");
        json.put("appid", (Object)"wxab9a283207ebd3d9");
        json.put("redirect_uri", (Object)"http://tdcode.natapp1.cc/els/wechat/auth");
        json.put("response_type", (Object)"code");
        json.put("scope", (Object)"snsapi_userinfo");
        json.put("state", (Object)"STATE#wechat_redirec");
        System.out.println(json);
        System.out.println("=======================");
        System.out.println(QRCodeUtil.createQRCode(json.toString()));
        String barcodeText = "R40.000120241106000001";
        System.out.println(barcodeText);
        System.out.println("=======================");
        System.out.println(QRCodeUtil.generateBarcode(barcodeText));
    }

    public static String generateBarcode(String barcodeText) throws WriterException, IOException {
        log.info("QRCodeUtil->createQRCode: barcodeText: " + barcodeText);
        Code128Writer barcodeWriter = new Code128Writer();
        BitMatrix bitMatrix = barcodeWriter.encode(barcodeText, BarcodeFormat.CODE_128, 600, 200);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"PNG", (OutputStream)baos);
        Base64.Encoder encoder = Base64.getEncoder();
        String text = encoder.encodeToString(baos.toByteArray());
        return base64Url + text;
    }
}

